/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Explicit
extends AbstractASN1Value {
    public static final ASN1Form FORM = ASN1Form.CONSTRUCTED;
    private final ASN1Value content;
    private final ASN1Tag tag;

    public ASN1Explicit(ASN1Tag aSN1Tag, ASN1Value aSN1Value) {
        Assert.debugAssert(aSN1Tag != null && aSN1Value != null);
        this.content = aSN1Value;
        this.tag = aSN1Tag;
    }

    public ASN1Value getContent() {
        return this.content;
    }

    @Override
    public ASN1Tag getTag() {
        return this.tag;
    }

    public static ASN1Explicit getInstance(byte[] byArray, ASN1Tag aSN1Tag, ASN1Template aSN1Template) throws InvalidBERException {
        return (ASN1Explicit)ASN1Util.decode(new Template(aSN1Tag, aSN1Template), byArray);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.content.encode(byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Header header = new Header(aSN1Tag, FORM, byArray.length);
        header.encode(outputStream);
        outputStream.write(byArray);
    }

    public static Template getTemplate(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
        return new Template(aSN1Tag, aSN1Template);
    }

    public static class Template
    implements ASN1Template {
        private final ASN1Template content;
        private final ASN1Tag tag;

        public Template(ASN1Tag aSN1Tag, ASN1Template aSN1Template) {
            this.content = aSN1Template;
            this.tag = aSN1Tag;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return this.tag.equals(aSN1Tag);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.tag, inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, ASN1Form.CONSTRUCTED);
                if (header.getContentLength() == -1L && !(header = new Header(inputStream)).isEOC()) {
                    throw new InvalidBERException("No end-of-contents marker");
                }
                return new ASN1Explicit(this.tag, this.content.decode(inputStream));
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Explicit");
            }
        }
    }
}

