/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;

public class ASN1Integer
extends BigInteger
implements ASN1Value {
    private static final long serialVersionUID = 886972449294198557L;
    private byte[] encodedContents;
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 2L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();

    private byte[] getEncodedContents() {
        if (this.encodedContents == null) {
            this.encodedContents = this.toByteArray();
        }
        return this.encodedContents;
    }

    private Header getHeader(ASN1Tag aSN1Tag) {
        return new Header(aSN1Tag, FORM, this.getContentLength());
    }

    public ASN1Integer(String string) throws NumberFormatException {
        super(string);
    }

    public ASN1Integer(String string, int n) throws NumberFormatException {
        super(string, n);
    }

    public ASN1Integer(byte[] byArray) throws NumberFormatException {
        super(byArray);
    }

    public ASN1Integer(int n, byte[] byArray) throws NumberFormatException {
        super(n, byArray);
    }

    public ASN1Integer(int n, Random random) throws NumberFormatException {
        super(n, random);
    }

    public ASN1Integer(int n, int n2, Random random) {
        super(n, n2, random);
    }

    public ASN1Integer(long l) {
        super(BigInteger.valueOf(l).toByteArray());
    }

    public ASN1Integer(BigInteger bigInteger) {
        super(bigInteger.toByteArray());
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.getHeader(aSN1Tag).encode(outputStream);
        outputStream.write(this.getEncodedContents());
    }

    public long getContentLength() {
        return this.getEncodedContents().length;
    }

    public static ASN1Integer getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1Integer)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public byte[] encode() {
        return ASN1Util.encode(this.getTag(), this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = (ASN1Integer)object;
        return this.getTag().equals(aSN1Integer.getTag()) && Arrays.equals(this.getEncodedContents(), aSN1Integer.getEncodedContents());
    }

    @Override
    public int hashCode() {
        return 31 + Arrays.hashCode(ASN1Util.encode(this));
    }

    public static class Template
    implements ASN1Template {
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(this.getTag(), inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, FORM);
                if (header.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for ASN1Integer");
                }
                byte[] byArray = new byte[(int)header.getContentLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new ASN1Integer(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Integer");
            }
        }
    }
}

