/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class ASN1OctetString
extends AbstractASN1Value {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 4L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();
    private final byte[] data;

    public ASN1OctetString(byte[] byArray) {
        this.data = ASN1Util.copy(byArray);
    }

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public byte[] toByteArray() {
        return ASN1Util.copy(this.data);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        Header header = new Header(aSN1Tag, FORM, this.data.length);
        header.encode(outputStream);
        outputStream.write(this.data);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString aSN1OctetString = (ASN1OctetString)object;
        return this.getTag().equals(aSN1OctetString.getTag()) && Arrays.equals(this.data, aSN1OctetString.data);
    }

    public static ASN1OctetString getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1OctetString)ASN1Util.decode(TEMPLATE, byArray);
    }

    public static class Template
    implements ASN1Template {
        public ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        protected ASN1Value generateInstance(byte[] byArray) {
            return new ASN1OctetString(byArray);
        }

        protected String getName() {
            return "ASN1OctetString";
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                byte[] byArray;
                Header header = new Header(inputStream);
                header.validate(aSN1Tag);
                if (header.getContentLength() == -1L) {
                    Header header2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    Template template = new Template();
                    do {
                        if ((header2 = Header.lookAhead(inputStream)).isEOC()) continue;
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)template.decode(inputStream);
                        byteArrayOutputStream.write(aSN1OctetString.toByteArray());
                    } while (!header2.isEOC());
                    header2 = new Header(inputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                } else {
                    byArray = new byte[(int)header.getContentLength()];
                    ASN1Util.readFully(byArray, inputStream);
                }
                return this.generateInstance(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, this.getName());
            }
        }
    }
}

