/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1TimeBase;
import com.bifit.security.asn1.InvalidBERException;
import java.util.Calendar;
import java.util.Date;

public class ASN1UTCTime
extends AbstractASN1TimeBase {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 23L);
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public ASN1UTCTime(Date date) {
        super(ASN1UTCTime.zeroMillis(date));
    }

    public static Date zeroMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    @Override
    protected boolean isUTC() {
        return true;
    }

    public static ASN1UTCTime getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1UTCTime)ASN1Util.decode(TEMPLATE, byArray);
    }

    public static class Template
    extends AbstractASN1TimeBase.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected boolean isUTC() {
            return true;
        }

        @Override
        protected String typeName() {
            return "ASN1UTCTime";
        }

        @Override
        protected AbstractASN1TimeBase generateInstance(Date date) {
            return new ASN1UTCTime(date);
        }
    }
}

