/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1PrintableString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public abstract class AbstractASN1TimeBase
extends AbstractASN1Value {
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    private Date date;

    public AbstractASN1TimeBase(Date date) {
        this.date = date;
    }

    public Date toDate() {
        return this.date;
    }

    protected abstract boolean isUTC();

    protected void setDate(Date date) {
        this.date = date;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        int n;
        if (this.isUTC()) {
            new Header(aSN1Tag, FORM, 13L).encode(outputStream);
        } else {
            new Header(aSN1Tag, FORM, 15L).encode(outputStream);
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(this.date);
        if (this.isUTC()) {
            n = calendar.get(1);
            outputStream.write(n % 100 / 10 + 48);
            outputStream.write(n % 10 + 48);
        } else {
            n = calendar.get(1);
            outputStream.write(n % 10000 / 1000 + 48);
            outputStream.write(n % 1000 / 100 + 48);
            outputStream.write(n % 100 / 10 + 48);
            outputStream.write(n % 10 + 48);
        }
        n = calendar.get(2) + 1;
        Assert.debugAssert(n >= 1 && n <= 12);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(5);
        Assert.debugAssert(n >= 1 && n <= 31);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(11);
        Assert.debugAssert(n >= 0 && n <= 23);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(12);
        Assert.debugAssert(n >= 0 && n <= 59);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        n = calendar.get(13);
        Assert.debugAssert(n >= 0 && n <= 59);
        outputStream.write(n / 10 + 48);
        outputStream.write(n % 10 + 48);
        outputStream.write(90);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AbstractASN1TimeBase)) {
            return false;
        }
        AbstractASN1TimeBase abstractASN1TimeBase = (AbstractASN1TimeBase)object;
        return this.getTag().equals(abstractASN1TimeBase.getTag()) && this.date.equals(abstractASN1TimeBase.date);
    }

    @Override
    public int hashCode() {
        return this.getTag().hashCode() + (this.date == null ? 0 : this.date.hashCode());
    }

    public static abstract class AbstractTemplate {
        protected abstract boolean isUTC();

        protected abstract ASN1Tag getTag();

        protected abstract String typeName();

        protected abstract AbstractASN1TimeBase generateInstance(Date var1);

        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return this.getTag().equals(aSN1Tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            TimeZone timeZone;
            int n;
            int n2;
            ASN1PrintableString aSN1PrintableString;
            ASN1PrintableString.Template template = new ASN1PrintableString.Template();
            try {
                aSN1PrintableString = (ASN1PrintableString)template.decode(aSN1Tag, inputStream);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, this.typeName());
            }
            char[] cArray = aSN1PrintableString.toCharArray();
            int n3 = 0;
            if (this.isUTC()) {
                AbstractTemplate.checkBounds(n3, 2, cArray.length);
                n2 = (cArray[n3] - 48) * 10;
                n2 = (n2 += cArray[n3 + 1] - 48) < 70 ? (n2 += 2000) : (n2 += 1900);
                n3 += 2;
            } else {
                AbstractTemplate.checkBounds(n3, 4, cArray.length);
                n2 = (cArray[n3] - 48) * 1000;
                n2 += (cArray[n3 + 1] - 48) * 100;
                n2 += (cArray[n3 + 2] - 48) * 10;
                AbstractTemplate.checkRange(n2 += cArray[n3 + 3] - 48, 0, 9999, "year");
                n3 += 4;
            }
            int n4 = 0;
            AbstractTemplate.checkBounds(n3, 2, cArray.length);
            n4 = (cArray[n3] - 48) * 10;
            AbstractTemplate.checkRange(n4 += cArray[n3 + 1] - 48, 1, 12, "month");
            --n4;
            AbstractTemplate.checkBounds(n3 += 2, 2, cArray.length);
            int n5 = (cArray[n3] - 48) * 10;
            AbstractTemplate.checkRange(n5 += cArray[n3 + 1] - 48, 1, 31, "day");
            AbstractTemplate.checkBounds(n3 += 2, 2, cArray.length);
            int n6 = (cArray[n3] - 48) * 10;
            AbstractTemplate.checkRange(n6 += cArray[n3 + 1] - 48, 0, 23, "hour");
            AbstractTemplate.checkBounds(n3 += 2, 2, cArray.length);
            int n7 = (cArray[n3] - 48) * 10;
            AbstractTemplate.checkRange(n7 += cArray[n3 + 1] - 48, 0, 59, "minute");
            if ((n3 += 2) < cArray.length && cArray[n3] >= '0' && cArray[n3] <= '9') {
                AbstractTemplate.checkBounds(n3, 2, cArray.length);
                n = (cArray[n3] - 48) * 10;
                AbstractTemplate.checkRange(n += cArray[n3 + 1] - 48, 0, 59, "second");
                n3 += 2;
            } else {
                n = 0;
            }
            if (!this.isUTC()) {
                while (n3 < cArray.length && cArray[n3] != '+' && cArray[n3] != '-' && cArray[n3] != 'Z') {
                    ++n3;
                }
            }
            if (n3 < cArray.length) {
                AbstractTemplate.checkBounds(n3, 1, cArray.length);
                if (cArray[n3] == '+' || cArray[n3] == '-') {
                    AbstractTemplate.checkBounds(n3 + 1, 4, cArray.length);
                    int n8 = (cArray[n3 + 1] - 48) * 10;
                    int n9 = (cArray[n3 + 3] - 48) * 10;
                    AbstractTemplate.checkRange(n8 += cArray[n3 + 2] - 48, 0, 23, "hour offset");
                    AbstractTemplate.checkRange(n9 += cArray[n3 + 4] - 48, 0, 59, "minute offset");
                    if (cArray[n3] == '-') {
                        n8 = -n8;
                        n9 = -n9;
                    }
                    n3 += 5;
                    timeZone = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                    timeZone.setRawOffset((n8 * 60 + n9) * 60 * 1000);
                } else {
                    if (cArray[n3] != 'Z') throw new InvalidBERException("Invalid character " + cArray[n3]);
                    ++n3;
                    boolean bl = false;
                    boolean bl2 = false;
                    timeZone = (TimeZone)TimeZone.getTimeZone("GMT").clone();
                }
            } else {
                if (this.isUTC()) {
                    throw new InvalidBERException("no timezone specified for ASN1UTCTime");
                }
                timeZone = TimeZone.getDefault();
            }
            if (n3 != cArray.length) {
                throw new InvalidBERException("Extra characters at end");
            }
            Calendar calendar = Calendar.getInstance(timeZone);
            calendar.set(14, 0);
            calendar.set(n2, n4, n5, n6, n7, n);
            return this.generateInstance(calendar.getTime());
        }

        private static void checkRange(int n, int n2, int n3, String string) throws InvalidBERException {
            if (n < n2 || n > n3) {
                throw new InvalidBERException("Invalid " + string);
            }
        }

        private static void checkBounds(int n, int n2, int n3) throws InvalidBERException {
            if (n + n2 > n3) {
                throw new InvalidBERException("Too few characters in ASN1TimeBase");
            }
        }
    }
}

