/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;

public class Header {
    private byte[] cachedEncoding;
    private final ASN1Tag tag;
    private long contentLength;
    private final ASN1Form form;
    private static final int PRIME = 31;
    private static final int MAX_LOOK_AHEAD = 32;

    public long getTotalLength() {
        long l = this.contentLength == -1L ? -1L : (long)this.encode().length + this.contentLength;
        return l;
    }

    public ASN1Tag getTag() {
        return this.tag;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public ASN1Form getForm() {
        return this.form;
    }

    public static Header lookAhead(InputStream inputStream) throws IOException, InvalidBERException {
        if (!inputStream.markSupported()) {
            throw new IOException("Mark not supported on this input stream");
        }
        inputStream.mark(32);
        Header header = new Header(inputStream);
        inputStream.reset();
        return header;
    }

    public Header(InputStream inputStream) throws InvalidBERException, IOException {
        long l;
        byte by;
        Object object;
        int n = inputStream.read();
        if (n == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(n);
        byte by2 = (byte)n;
        ASN1Tag.Class clazz = ASN1Tag.Class.fromInt((by2 & 0xFF) >>> 6);
        this.form = (by2 & 0x20) == 32 ? ASN1Form.CONSTRUCTED : ASN1Form.PRIMITIVE;
        if ((by2 & 0x1F) == 31) {
            int n2;
            object = new ArrayList<Byte>();
            do {
                if ((n = inputStream.read()) == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
                }
                byteArrayOutputStream.write(n);
                by = (byte)n;
                object.add(by);
            } while ((by & 0x80) == 128);
            Assert.debugAssert(!object.isEmpty());
            byte[] byArray = new byte[(object.size() * 7 + 7) / 8];
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray[n2] = 0;
            }
            int n3 = 0;
            n2 = byArray.length - 1;
            for (int i = object.size() - 1; i >= 0; --i) {
                Assert.debugAssert(i >= 0);
                Assert.debugAssert(i < object.size());
                Assert.debugAssert(n2 >= 0);
                Assert.debugAssert(n2 < byArray.length);
                byte by3 = (byte)((Byte)object.get(i) & 0x7F);
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] | by3 << n3);
                if (n3 > 1) {
                    Assert.debugAssert(n2 > 0);
                    int n5 = --n2;
                    byArray[n5] = (byte)(byArray[n5] | by3 >>> 8 - n3);
                }
                n3 = (n3 + 7) % 8;
            }
            l = new BigInteger(1, byArray).longValue();
        } else {
            l = by2 & 0x1F;
        }
        this.tag = new ASN1Tag(clazz, l);
        n = inputStream.read();
        if (n == -1) {
            throw new InvalidBERException("End-of-file reached while decoding ASN.1 header");
        }
        byteArrayOutputStream.write(n);
        by = (byte)n;
        if ((by & 0x80) == 0) {
            this.contentLength = by;
        } else if ((by & 0x7F) == 0) {
            this.contentLength = -1L;
        } else {
            object = new byte[by & 0x7F];
            ASN1Util.readFully((byte[])object, inputStream);
            byteArrayOutputStream.write((byte[])object);
            this.contentLength = new BigInteger(1, (byte[])object).longValue();
        }
        this.cachedEncoding = byteArrayOutputStream.toByteArray();
    }

    public Header(ASN1Tag aSN1Tag, ASN1Form aSN1Form, long l) {
        this.tag = aSN1Tag;
        this.form = aSN1Form;
        Assert.debugAssert(l >= 0L);
        this.contentLength = l;
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encode());
    }

    public byte[] encode() {
        Object object;
        if (this.cachedEncoding != null) {
            return ASN1Util.copy(this.cachedEncoding);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        n = (byte)(n | this.tag.getTagClass().toInt() << 6);
        if (this.form.equals(ASN1Form.CONSTRUCTED)) {
            n = (byte)(n | 0x20);
        }
        if (this.tag.getNum() <= 30L) {
            n = (byte)((long)n | this.tag.getNum() & 0x1FL);
            byteArrayOutputStream.write(n);
        } else {
            n = (byte)(n | 0x1F);
            object = BigInteger.valueOf(this.tag.getNum());
            byteArrayOutputStream.write(n);
            int n2 = ((BigInteger)object).bitLength();
            int n3 = (n2 + 6) / 7;
            --n3;
            while (n3 > 0) {
                long l = this.tag.getNum() >>> 7 * n3;
                byteArrayOutputStream.write((byte)l & 0x7F | 0x80);
                --n3;
            }
            byteArrayOutputStream.write((byte)this.tag.getNum() & 0x7F);
        }
        if (this.contentLength == -1L) {
            byteArrayOutputStream.write(-128);
        } else if (this.contentLength <= 127L) {
            byteArrayOutputStream.write((byte)this.contentLength);
        } else {
            object = Header.unsignedBigIntToByteArray(BigInteger.valueOf(this.contentLength));
            byteArrayOutputStream.write((byte)((Object)object).length | 0x80);
            byteArrayOutputStream.write((byte[])object, 0, ((Object)object).length);
        }
        this.cachedEncoding = byteArrayOutputStream.toByteArray();
        return ASN1Util.copy(this.cachedEncoding);
    }

    public static byte[] unsignedBigIntToByteArray(BigInteger bigInteger) {
        Assert.debugAssert(bigInteger.compareTo(BigInteger.valueOf(0L)) != -1);
        int n = bigInteger.bitLength();
        int n2 = n == 0 ? 1 : (n + 7) / 8;
        byte[] byArray = bigInteger.toByteArray();
        if (n2 == byArray.length) {
            return byArray;
        }
        Assert.debugAssert(n2 == byArray.length - 1);
        Assert.debugAssert(byArray[0] == 0);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 1, byArray2, 0, n2);
        return byArray2;
    }

    public void validate(ASN1Tag aSN1Tag, ASN1Form aSN1Form) throws InvalidBERException {
        this.validate(aSN1Tag);
        if (this.getForm() != aSN1Form) {
            throw new InvalidBERException("Incorrect form: expected [" + aSN1Form + "], found [" + this.getForm());
        }
    }

    public void validate(ASN1Tag aSN1Tag) throws InvalidBERException {
        if (!aSN1Tag.equals(this.getTag())) {
            throw new InvalidBERException("Incorrect tag: expected [" + aSN1Tag + "], found [" + this.getTag() + "]");
        }
    }

    public boolean isEOC() {
        return this.tag.equals(ASN1Tag.EOC);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (int)(this.contentLength ^ this.contentLength >>> 32);
        n = 31 * n + this.form.hashCode();
        n = 31 * n + this.tag.hashCode();
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Header)) {
            return false;
        }
        Header header = (Header)object;
        if (this.contentLength != header.contentLength) {
            return false;
        }
        if (!this.form.equals(header.form)) {
            return false;
        }
        return this.tag.equals(header.tag);
    }
}

