/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.EncryptedContentInfo;
import com.bifit.security.pkix.cms.SetOfAttribute;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class EncryptedData
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final EncryptedContentInfo b;
    private final SetOfAttribute c;
    public static final ASN1Integer DEFAULT_VERSION = new ASN1Integer(0L);
    public static final ASN1Template TEMPLATE = new a();

    public EncryptedData(ASN1Integer aSN1Integer, EncryptedContentInfo encryptedContentInfo, SetOfAttribute setOfAttribute) {
        super(EncryptedData.class);
        PKIXUtils.verifyNotNull(aSN1Integer, encryptedContentInfo);
        this.a = aSN1Integer;
        this.b = encryptedContentInfo;
        this.c = setOfAttribute;
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this(DEFAULT_VERSION, encryptedContentInfo, null);
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.b;
    }

    public SetOfAttribute getUnprotectedAttrs() {
        return this.c;
    }

    public static EncryptedData getInstance(byte[] byArray) throws PKIXException {
        try {
            return (EncryptedData)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(EncryptedContentInfo.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), SetOfAttribute.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            Assert.debugAssert(((aSN1Tag = this.getSequence(aSN1Tag, inputStream)).size() == 3 ? 1 : 0) != 0);
            return new EncryptedData((ASN1Integer)aSN1Tag.elementAt(0), (EncryptedContentInfo)aSN1Tag.elementAt(1), (SetOfAttribute)aSN1Tag.elementAt(2));
        }
    }
}

