/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.IssuerAndSerialNumber;
import com.bifit.security.pkix.cms.RecipientKeyIdentifier;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class KeyAgreeRecipientIdentifier
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    KeyAgreeRecipientIdentifier(Type type, ASN1Value aSN1Value) {
        super(KeyAgreeRecipientIdentifier.class, aSN1Value);
        this.a = type;
    }

    public static KeyAgreeRecipientIdentifier getInstanceIssuerAndSerialNum(IssuerAndSerialNumber issuerAndSerialNumber) {
        return new KeyAgreeRecipientIdentifier(Type.ISSUER_AND_SERIAL_NUMBER, (ASN1Value)issuerAndSerialNumber);
    }

    public static KeyAgreeRecipientIdentifier getInstanceRKeyId(RecipientKeyIdentifier recipientKeyIdentifier) {
        return new KeyAgreeRecipientIdentifier(Type.R_KEY_ID, (ASN1Value)recipientKeyIdentifier);
    }

    public static KeyAgreeRecipientIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (KeyAgreeRecipientIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        if (this.a == Type.ISSUER_AND_SERIAL_NUMBER) {
            aSN1Tag = IssuerAndSerialNumber.TAG;
        } else {
            Assert.debugAssert((this.a == Type.R_KEY_ID ? 1 : 0) != 0);
            aSN1Tag = ASN1Tag.get((long)0L);
        }
        return aSN1Tag;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        if (this.a == Type.ISSUER_AND_SERIAL_NUMBER) {
            return (IssuerAndSerialNumber)this.value;
        }
        return null;
    }

    public RecipientKeyIdentifier getRKeyId() {
        if (this.a == Type.R_KEY_ID) {
            return (RecipientKeyIdentifier)this.value;
        }
        return null;
    }

    public boolean isIssuerAndSerialNumber() {
        return this.a == Type.ISSUER_AND_SERIAL_NUMBER;
    }

    public boolean isRKeyId() {
        return this.a == Type.R_KEY_ID;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(IssuerAndSerialNumber.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)0L), RecipientKeyIdentifier.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = object = inputStream.getTag().getNum() == 0L ? Type.R_KEY_ID : Type.ISSUER_AND_SERIAL_NUMBER;
            inputStream = inputStream.getValue();
            return new KeyAgreeRecipientIdentifier(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        ISSUER_AND_SERIAL_NUMBER,
        R_KEY_ID;

    }
}

