/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PublicKey;

public class OriginatorPublicKey
extends AbstractASN1Sequence {
    private AlgorithmIdentifier a;
    private ASN1BitString b;
    public static final ASN1Template TEMPLATE = new a();

    public OriginatorPublicKey(AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(OriginatorPublicKey.class);
        PKIXUtils.verifyNotNull(algorithmIdentifier, aSN1BitString);
        this.a = algorithmIdentifier;
        this.b = aSN1BitString;
    }

    public OriginatorPublicKey(PublicKey object) throws PKIXException {
        super(OriginatorPublicKey.class);
        PKIXUtils.verifyNotNull(object);
        object = OriginatorPublicKey.getInstance(object.getEncoded());
        this.a = ((OriginatorPublicKey)object).a;
        this.b = ((OriginatorPublicKey)object).b;
    }

    public static OriginatorPublicKey getInstance(byte[] byArray) throws PKIXException {
        try {
            return (OriginatorPublicKey)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public ASN1BitString getPublicKey() {
        return this.b;
    }

    public AlgorithmIdentifier getAlgorithm() {
        return this.a;
    }

    public void setAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.a = algorithmIdentifier;
    }

    public void setPublicKey(ASN1BitString aSN1BitString) {
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.b = aSN1BitString;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new OriginatorPublicKey((AlgorithmIdentifier)aSN1Tag.elementAt(0), (ASN1BitString)aSN1Tag.elementAt(1));
        }
    }
}

