/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.cms;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.cms.KeyAgreeRecipientInfo;
import com.bifit.security.pkix.cms.KeyTransRecipientInfo;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class RecipientInfo
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    RecipientInfo(Type type, ASN1Value aSN1Value) {
        super(RecipientInfo.class, aSN1Value);
        this.a = type;
        PKIXUtils.verifyNotNull(aSN1Value);
    }

    public static RecipientInfo getInstanceKeyTrans(KeyTransRecipientInfo keyTransRecipientInfo) {
        return new RecipientInfo(Type.KEY_TRANS_RECIPIENT_INFO, (ASN1Value)keyTransRecipientInfo);
    }

    public static RecipientInfo getInstanceKeyAgree(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        return new RecipientInfo(Type.KEY_ARGEE_RECIPIENT_INFO, (ASN1Value)keyAgreeRecipientInfo);
    }

    public static RecipientInfo getInstanceKEK(ASN1Any aSN1Any) {
        return new RecipientInfo(Type.KEK_RECIPIENT_INFO, (ASN1Value)aSN1Any);
    }

    public static RecipientInfo getInstancePassword(ASN1Any aSN1Any) {
        return new RecipientInfo(Type.PASSWORD_RECIPIENT_INFO, (ASN1Value)aSN1Any);
    }

    public static RecipientInfo getInstanceOther(ASN1Any aSN1Any) {
        return new RecipientInfo(Type.OTHER_RECIPIENT_INFO, (ASN1Value)aSN1Any);
    }

    public static RecipientInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RecipientInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public KeyTransRecipientInfo getTransRecipient() {
        if (this.a == Type.KEY_TRANS_RECIPIENT_INFO) {
            return (KeyTransRecipientInfo)this.value;
        }
        return null;
    }

    public KeyAgreeRecipientInfo getKeyAgree() {
        if (this.a == Type.KEY_ARGEE_RECIPIENT_INFO) {
            return (KeyAgreeRecipientInfo)this.value;
        }
        return null;
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        switch (this.a) {
            case KEY_TRANS_RECIPIENT_INFO: {
                aSN1Tag = KeyTransRecipientInfo.TAG;
                break;
            }
            case KEY_ARGEE_RECIPIENT_INFO: {
                aSN1Tag = ASN1Tag.get((long)1L);
                break;
            }
            case KEK_RECIPIENT_INFO: {
                aSN1Tag = ASN1Tag.get((long)2L);
                break;
            }
            case PASSWORD_RECIPIENT_INFO: {
                aSN1Tag = ASN1Tag.get((long)3L);
                break;
            }
            default: {
                Assert.debugAssert((this.a == Type.OTHER_RECIPIENT_INFO ? 1 : 0) != 0);
                aSN1Tag = ASN1Tag.get((long)4L);
            }
        }
        return aSN1Tag;
    }

    static /* synthetic */ Type a(ASN1Tag object) {
        switch ((int)object.getNum()) {
            case 1: {
                object = Type.KEY_ARGEE_RECIPIENT_INFO;
                break;
            }
            case 2: {
                object = Type.KEK_RECIPIENT_INFO;
                break;
            }
            case 3: {
                object = Type.PASSWORD_RECIPIENT_INFO;
                break;
            }
            case 4: {
                object = Type.OTHER_RECIPIENT_INFO;
                break;
            }
            default: {
                object = Type.KEY_TRANS_RECIPIENT_INFO;
            }
        }
        return object;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(KeyTransRecipientInfo.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)1L), KeyAgreeRecipientInfo.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)2L), ASN1Any.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)3L), ASN1Any.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)4L), ASN1Any.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = RecipientInfo.a(inputStream.getTag());
            inputStream = inputStream.getValue();
            return new RecipientInfo(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        KEY_TRANS_RECIPIENT_INFO,
        KEY_ARGEE_RECIPIENT_INFO,
        KEK_RECIPIENT_INFO,
        PASSWORD_RECIPIENT_INFO,
        OTHER_RECIPIENT_INFO;

    }
}

