/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.esf.OtherRevVals;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.ocsp.BasicOCSPResponse;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.x509.CertificateList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RevocationValues
extends AbstractASN1Sequence {
    private ASN1Sequence a;
    private ASN1Sequence b;
    private OtherRevVals c;
    public static final ASN1Template TEMPLATE = new a();

    public RevocationValues() {
        super(RevocationValues.class);
    }

    public void setCrlVals(ASN1Sequence aSN1Sequence) throws IOException {
        if (aSN1Sequence != null && !aSN1Sequence.checkElementsType(CertificateList.class)) {
            throw new IOException("Invalid crlVals type");
        }
        this.a = aSN1Sequence;
    }

    public void addCrlVal(CertificateList certificateList) {
        if (this.a == null) {
            this.a = new ASN1Sequence();
        }
        this.a.addElement((ASN1Value)certificateList);
    }

    public ASN1Sequence getCrlVals() {
        return this.a;
    }

    public CertificateList getCrlVal(int n) {
        if (this.a == null) {
            return null;
        }
        return (CertificateList)this.a.elementAt(n);
    }

    public void setOcspVals(ASN1Sequence aSN1Sequence) throws IOException {
        if (aSN1Sequence != null && !aSN1Sequence.checkElementsType(BasicOCSPResponse.class)) {
            throw new IOException("Invalid ocspVals type");
        }
        this.b = aSN1Sequence;
    }

    public void addOcspVal(BasicOCSPResponse basicOCSPResponse) {
        if (this.b == null) {
            this.b = new ASN1Sequence();
        }
        this.b.addElement((ASN1Value)basicOCSPResponse);
    }

    public ASN1Sequence getOcspVals() {
        return this.b;
    }

    public BasicOCSPResponse getOcspVals(int n) {
        if (this.b == null) {
            return null;
        }
        return (BasicOCSPResponse)this.b.elementAt(n);
    }

    public void setOtherRevVals(OtherRevVals otherRevVals) {
        this.c = otherRevVals;
    }

    public OtherRevVals getOtherRevVals() {
        return this.c;
    }

    public static RevocationValues getInstance(byte[] byArray) throws PKIXException {
        try {
            return (RevocationValues)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.a);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Value)this.b);
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)2L), (ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Template)ASN1Sequence.getSequenceTemplate((ASN1Template)CertificateList.TEMPLATE));
            this.seqt.addOptionalElement(ASN1Tag.get((long)1L), (ASN1Template)ASN1Sequence.getSequenceTemplate((ASN1Template)BasicOCSPResponse.TEMPLATE));
            this.seqt.addOptionalElement(ASN1Tag.get((long)2L), OtherRevVals.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new RevocationValues();
            ((RevocationValues)object).setCrlVals((ASN1Sequence)aSN1Tag.elementAt(0));
            ((RevocationValues)object).setOcspVals((ASN1Sequence)aSN1Tag.elementAt(1));
            ((RevocationValues)object).setOtherRevVals((OtherRevVals)aSN1Tag.elementAt(2));
            return object;
        }
    }
}

