/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.esf;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.esf.SignaturePolicyId;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SignaturePolicyIdentifier
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    public SignaturePolicyIdentifier(Type type, ASN1Value aSN1Value) {
        super(SignaturePolicyIdentifier.class, aSN1Value);
        this.a = type;
    }

    public static SignaturePolicyIdentifier getInstance(byte[] byArray) throws PKIXException {
        try {
            return (SignaturePolicyIdentifier)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public Type getType() {
        return this.a;
    }

    public SignaturePolicyId getSignaturePolicyId() {
        return (SignaturePolicyId)this.value;
    }

    public static SignaturePolicyIdentifier getInstanceSignaturePolicyId(SignaturePolicyId signaturePolicyId) {
        return new SignaturePolicyIdentifier(Type.SIGNATURE_POLICY_ID, (ASN1Value)signaturePolicyId);
    }

    @Override
    public ASN1Tag getTag() {
        Assert.debugAssert((this.a == Type.SIGNATURE_POLICY_ID ? 1 : 0) != 0);
        return SignaturePolicyId.TAG;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.value.encode(outputStream);
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(SignaturePolicyId.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Assert.debugAssert((boolean)inputStream.getTag().equals((Object)SignaturePolicyId.TAG));
            return SignaturePolicyIdentifier.getInstanceSignaturePolicyId((SignaturePolicyId)inputStream.getValue());
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    public static final class Type
    extends Enum<Type> {
    }
}

