/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.ocsp;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Primitive;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.log.PKIXLogger;
import com.bifit.security.pkix.log.PKIXLoggerFactory;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ResponderID
extends AbstractASN1Primitive {
    private Name a;
    private ASN1OctetString b;
    public static final ASN1Template TEMPLATE = new a();
    private static final PKIXLogger c = PKIXLoggerFactory.getLogger(ResponderID.class);

    public ResponderID(Name name) {
        c.debug("name = " + name);
        PKIXUtils.verifyNotNull(name);
        this.a = name;
    }

    public ResponderID(ASN1OctetString aSN1OctetString) {
        c.debug("keyHash = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
    }

    public Name getName() {
        return this.a;
    }

    public void setName(Name name) {
        c.debug("name = " + name);
        PKIXUtils.verifyNotNull(name);
        this.a = name;
        this.b = null;
    }

    public ASN1OctetString getKeyHash() {
        return this.b;
    }

    public void setKeyHash(ASN1OctetString aSN1OctetString) {
        c.debug("keyHash = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1OctetString);
        this.b = aSN1OctetString;
        this.a = null;
    }

    public void encode(OutputStream outputStream) throws IOException {
        if (this.a != null && this.b == null) {
            new ASN1Explicit(ASN1Tag.get((long)1L), (ASN1Value)this.a).encode(outputStream);
            return;
        }
        if (this.b != null && this.a == null) {
            new ASN1Explicit(ASN1Tag.get((long)2L), (ASN1Value)this.b).encode(outputStream);
        }
    }

    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag = this.a != null && this.b == null ? ASN1Tag.get((long)1L) : ASN1Tag.get((long)2L);
        return aSN1Tag;
    }

    public String toString() {
        String string = this.a == null ? "ResponderID [keyHash=" + PKIXUtils.arrayToString(this.b.toByteArray()) + "]" : "ResponderID [name=" + this.a + "]";
        return string;
    }

    private static final class a
    implements ASN1Template {
        private final ASN1Choice.Template a = new ASN1Choice.Template();

        public a() {
            this.a.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)1L), (ASN1Template)Name.TEMPLATE));
            this.a.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)2L), (ASN1Template)ASN1OctetString.TEMPLATE));
        }

        public final boolean tagMatch(ASN1Tag aSN1Tag) {
            return this.a.tagMatch(aSN1Tag);
        }

        public final ASN1Value decode(InputStream object) throws IOException, InvalidBERException {
            if ((object = (ASN1Choice)this.a.decode((InputStream)object)).getTag().equals((Object)ASN1Tag.get((long)1L))) {
                object = (Name)((ASN1Explicit)object.getValue()).getContent();
                return new ResponderID((Name)object);
            }
            object = (ASN1OctetString)((ASN1Explicit)object.getValue()).getContent();
            return new ResponderID((ASN1OctetString)object);
        }

        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(inputStream);
        }
    }
}

