/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Set;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Attribute
extends AbstractASN1Sequence {
    private final ASN1ObjectIdentifier a;
    private final ASN1Set b;
    public static final ASN1Template TEMPLATE = new a();

    public Attribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Set aSN1Set) {
        super(Attribute.class);
        this.debug("type = " + aSN1ObjectIdentifier + ", values = " + aSN1Set);
        this.a = aSN1ObjectIdentifier;
        this.b = aSN1Set;
    }

    public Attribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Value aSN1Value) throws PKIXException {
        super(Attribute.class);
        this.debug("type = " + aSN1ObjectIdentifier + ", value = " + aSN1Value);
        this.a = aSN1ObjectIdentifier;
        this.b = new ASN1Set();
        try {
            this.b.addElement((ASN1Value)new ASN1Any(ASN1Util.encode((ASN1Value)aSN1Value)));
            return;
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public ASN1ObjectIdentifier getType() {
        return this.a;
    }

    public ASN1Set getValues() {
        return this.b;
    }

    public ASN1Value getValue(ASN1Template aSN1Template) throws PKIXException {
        this.debug("template = " + aSN1Template);
        try {
            return ((ASN1Any)this.b.elementAt(0)).decodeWith(aSN1Template);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "Attribute [oid=" + this.a + ", values=" + this.b + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addElement((ASN1Template)new ASN1Set.OF_Template(ASN1Any.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return new Attribute((ASN1ObjectIdentifier)aSN1Tag.elementAt(0), (ASN1Set)aSN1Tag.elementAt(1));
        }
    }
}

