/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.primitive;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.GOST34310ValidationParms;
import com.bifit.security.pkix.utils.PKIXUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DHParameters
extends AbstractASN1Sequence {
    private final ASN1Integer a;
    private final ASN1Integer b;
    private final ASN1Integer c;
    private final GOST34310ValidationParms d;
    private final ASN1OctetString e;
    public static final ASN1Template TEMPLATE = new a();

    public DHParameters(ASN1Integer aSN1Integer, ASN1Integer aSN1Integer2, ASN1Integer aSN1Integer3, GOST34310ValidationParms gOST34310ValidationParms, ASN1OctetString aSN1OctetString) {
        super(DHParameters.class);
        this.debug("p = " + aSN1Integer + ", q = " + aSN1Integer2 + ", a = " + aSN1Integer3 + ", dke = " + aSN1OctetString);
        PKIXUtils.verifyNotNull(aSN1Integer, aSN1Integer2, aSN1Integer3);
        this.a = aSN1Integer;
        this.b = aSN1Integer2;
        this.c = aSN1Integer3;
        this.d = gOST34310ValidationParms;
        this.e = aSN1OctetString;
    }

    public ASN1Integer getP() {
        return this.a;
    }

    public ASN1Integer getQ() {
        return this.b;
    }

    public ASN1Integer getA() {
        return this.c;
    }

    public GOST34310ValidationParms getValidationParms() {
        return this.d;
    }

    public ASN1OctetString getDke() {
        return this.e;
    }

    public static DHParameters getInstance(byte[] byArray) throws PKIXException {
        try {
            return (DHParameters)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalElement((ASN1Value)this.d);
        aSN1Sequence.addOptionalElement((ASN1Value)this.e);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addOptionalElement(GOST34310ValidationParms.TEMPLATE);
            this.seqt.addOptionalElement(ASN1OctetString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            aSN1Tag = (ASN1Sequence)this.seqt.decode(aSN1Tag, inputStream);
            return new DHParameters((ASN1Integer)aSN1Tag.elementAt(0), (ASN1Integer)aSN1Tag.elementAt(1), (ASN1Integer)aSN1Tag.elementAt(2), (GOST34310ValidationParms)aSN1Tag.elementAt(3), (ASN1OctetString)aSN1Tag.elementAt(4));
        }
    }
}

