/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.tsp;

import com.bifit.security.asn1.ASN1Boolean;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.tsp.MessageImprint;
import com.bifit.security.pkix.tsp.TSAPolicyId;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extensions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TimeStampReq
extends AbstractASN1Sequence {
    public static final int SUPPORTED_VERSION = 1;
    private final ASN1Integer a = new ASN1Integer(1L);
    private MessageImprint b;
    private ASN1ObjectIdentifier c;
    private ASN1Integer d;
    private boolean e;
    private Extensions f;
    public static final ASN1Template TEMPLATE = new a();

    public TimeStampReq(MessageImprint messageImprint) {
        super(TimeStampReq.class);
        this.debug("messImpr = " + messageImprint);
        PKIXUtils.verifyNotNull(messageImprint);
        this.b = messageImprint;
    }

    public MessageImprint getMessImpr() {
        return this.b;
    }

    public void setMessImpr(MessageImprint messageImprint) {
        this.debug("messImpr = " + messageImprint);
        PKIXUtils.verifyNotNull(messageImprint);
        this.b = messageImprint;
    }

    public ASN1ObjectIdentifier getReqPolicy() {
        return this.c;
    }

    public void setReqPolicy(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("OID = " + aSN1ObjectIdentifier);
        this.c = aSN1ObjectIdentifier;
    }

    public void setReqPolicy(TSAPolicyId tSAPolicyId) {
        this.debug("OID = " + tSAPolicyId.getIdentifier());
        this.c = tSAPolicyId.getIdentifier();
    }

    public ASN1Integer getNonce() {
        return this.d;
    }

    public void setNonce(ASN1Integer aSN1Integer) {
        this.debug("NONCE = " + aSN1Integer);
        this.d = aSN1Integer;
    }

    public void generateNonce() {
        String string = String.valueOf(System.currentTimeMillis());
        String string2 = String.valueOf(System.nanoTime());
        this.d = new ASN1Integer(string + string2);
        this.debug("NONCE = " + this.d);
    }

    public boolean isCertReq() {
        return this.e;
    }

    public void setCertReq(boolean bl) {
        this.debug("certReq = " + bl);
        this.e = bl;
    }

    public Extensions getExts() {
        return this.f;
    }

    public void setExts(Extensions extensions) {
        this.debug("EXTENSIONS = " + extensions);
        this.f = extensions;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addOptionalElement((ASN1Value)this.c);
        aSN1Sequence.addOptionalElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)new ASN1Boolean(this.e));
        aSN1Sequence.addOptionalElement(ASN1Tag.get((long)0L), (ASN1Value)this.f);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "TimeStampReq [version=" + this.a + ", messImpr=" + this.b + ", reqPolicy=" + this.c + ", nonce=" + this.d + ", certReq=" + this.e + ", exts=" + this.f + "]";
    }

    public void writeFile(String string) throws IOException {
        this.debug("PATH = " + string);
        PKIXUtils.writeFile(this.encode(), new File(string));
    }

    public static TimeStampReq getInstance(byte[] byArray) throws PKIXException {
        try {
            return (TimeStampReq)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static TimeStampReq getInstance(File file) throws IOException {
        try {
            return TimeStampReq.getInstance(PKIXUtils.readFile(file));
        }
        catch (PKIXException pKIXException) {
            throw new IOException("Error reading TSP request", pKIXException);
        }
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(MessageImprint.TEMPLATE);
            this.seqt.addOptionalElement(ASN1ObjectIdentifier.TEMPLATE);
            this.seqt.addOptionalElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(ASN1Boolean.TEMPLATE, (ASN1Value)new ASN1Boolean(false));
            this.seqt.addOptionalElement(ASN1Tag.get((long)0L), Extensions.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag object, InputStream object2) throws IOException, InvalidBERException {
            if ((object2 = (ASN1Integer)(object = this.getSequence((ASN1Tag)object, (InputStream)object2)).elementAt(0)).intValue() != 1) {
                throw new IOException("Unsupported syntax version " + object2);
            }
            object2 = (MessageImprint)object.elementAt(1);
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)object.elementAt(2);
            ASN1Integer aSN1Integer = (ASN1Integer)object.elementAt(3);
            ASN1Boolean aSN1Boolean = (ASN1Boolean)object.elementAt(4);
            object = (Extensions)object.elementAt(5);
            object2 = new TimeStampReq((MessageImprint)object2);
            ((TimeStampReq)object2).setReqPolicy(aSN1ObjectIdentifier);
            ((TimeStampReq)object2).setNonce(aSN1Integer);
            ((TimeStampReq)object2).setCertReq(aSN1Boolean.toBoolean());
            ((TimeStampReq)object2).setExts((Extensions)object);
            return object2;
        }
    }
}

