/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.utils;

import com.bifit.security.pkix.crypto.VerifyAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class PKIXUtils {
    private final DocumentBuilderFactory a = DocumentBuilderFactory.newInstance();
    private static final PKIXUtils b;
    private static final XPath c;
    private static final char[] d;
    private static final byte[] e;

    private PKIXUtils() {
        this.a.setValidating(false);
    }

    public static Document getTemplate(File file) throws IOException {
        try {
            return PKIXUtils.getInstance().a.newDocumentBuilder().parse(file);
        }
        catch (SAXException sAXException) {
            throw new IOException("Error reading template from file", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException("Error reading template from file", parserConfigurationException);
        }
    }

    public static String arrayToString(byte[] byArray) {
        if (byArray == null) {
            return " null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : byArray) {
            stringBuffer.append(String.format("%02x", by));
        }
        return stringBuffer.toString();
    }

    public static byte[] swap(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[byArray2.length - i - 1] = byArray[i];
        }
        return byArray2;
    }

    public static void verifyNotNull(Object ... objectArray) {
        for (Object object : objectArray) {
            if (object != null) continue;
            throw new NullPointerException();
        }
    }

    public static boolean isSpecified(String string) {
        return string != null && !string.isEmpty();
    }

    public static boolean hasCerts(VerifyAdapter ... verifyAdapterArray) {
        for (int i = 0; i < verifyAdapterArray.length; ++i) {
            if (verifyAdapterArray[i].hasCertificate()) continue;
            return false;
        }
        return true;
    }

    public static byte[] readFile(String string) throws IOException {
        return PKIXUtils.readFile(new File(string));
    }

    public static byte[] readFile(File object) throws IOException {
        object = new FileInputStream((File)object);
        byte[] byArray = new byte[((FileInputStream)object).available()];
        ((FileInputStream)object).read(byArray);
        ((FileInputStream)object).close();
        return byArray;
    }

    public static void writeFile(byte[] byArray, File object) throws IOException {
        object = new FileOutputStream((File)object);
        ((FileOutputStream)object).write(byArray);
        ((FileOutputStream)object).close();
    }

    public static XPath getXPath() {
        return c;
    }

    public static PKIXUtils getInstance() {
        return b;
    }

    public static void compareVersion(int n, int n2) throws IOException {
        if (n != n2) {
            throw new IOException("Unsupported syntax version " + n2);
        }
    }

    public static byte[] parseBase64Binary(String string) {
        int n;
        int n2;
        int n3;
        block6: {
            String string2 = string;
            int n4 = string2.length();
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                n2 = e[string2.charAt(n3)];
                if (n2 == 127) continue;
                if (n2 != -1) break;
                n = string2.length() / 4 * 3;
                break block6;
            }
            n = (n2 = n4 - ++n3) > 2 ? string2.length() / 4 * 3 : string2.length() / 4 * 3 - n2;
        }
        int n5 = n;
        byte[] byArray = new byte[n];
        n3 = 0;
        n2 = string.length();
        byte[] byArray2 = new byte[4];
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            char c2 = string.charAt(i);
            if ((c2 = e[c2]) != '\uffffffff') {
                byArray2[n6++] = c2;
            }
            if (n6 != 4) continue;
            byArray[n3++] = (byte)(byArray2[0] << 2 | byArray2[1] >> 4);
            if (byArray2[2] != 127) {
                byArray[n3++] = (byte)(byArray2[1] << 4 | byArray2[2] >> 2);
            }
            if (byArray2[3] != 127) {
                byArray[n3++] = (byte)(byArray2[2] << 6 | byArray2[3]);
            }
            n6 = 0;
        }
        if (n5 == n3) {
            return byArray;
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, 0, byArray3, 0, n3);
        return byArray3;
    }

    public static String printBase64Binary(byte[] byArray) {
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = byArray;
        char[] cArray = new char[(n + 2) / 3 << 2];
        boolean bl2 = false;
        char[] cArray2 = cArray;
        int n2 = n;
        n = 0;
        byte[] byArray3 = byArray2;
        int n3 = 0;
        while (n2 >= 3) {
            cArray2[n3++] = PKIXUtils.a(byArray3[n] >> 2);
            cArray2[n3++] = PKIXUtils.a((byArray3[n] & 3) << 4 | byArray3[n + 1] >> 4 & 0xF);
            cArray2[n3++] = PKIXUtils.a((byArray3[n + 1] & 0xF) << 2 | byArray3[n + 2] >> 6 & 3);
            cArray2[n3++] = PKIXUtils.a(byArray3[n + 2] & 0x3F);
            n2 -= 3;
            n += 3;
        }
        if (n2 == 1) {
            cArray2[n3++] = PKIXUtils.a(byArray3[n] >> 2);
            cArray2[n3++] = PKIXUtils.a((byArray3[n] & 3) << 4);
            cArray2[n3++] = 61;
            cArray2[n3++] = 61;
        }
        if (n2 == 2) {
            cArray2[n3++] = PKIXUtils.a(byArray3[n] >> 2);
            cArray2[n3++] = PKIXUtils.a((byArray3[n] & 3) << 4 | byArray3[n + 1] >> 4 & 0xF);
            cArray2[n3++] = PKIXUtils.a((byArray3[n + 1] & 0xF) << 2);
            cArray2[n3++] = 61;
        }
        int n4 = n3;
        assert (n4 == cArray.length);
        return new String(cArray);
    }

    private static char a(int n) {
        return d[n & 0x3F];
    }

    public static byte[] copy(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    static {
        int n;
        b = new PKIXUtils();
        c = XPathFactory.newInstance().newXPath();
        Object[] objectArray = new char[64];
        for (n = 0; n < 26; ++n) {
            objectArray[n] = (char)(n + 65);
        }
        for (n = 26; n < 52; ++n) {
            objectArray[n] = (char)(97 + (n - 26));
        }
        for (n = 52; n < 62; ++n) {
            objectArray[n] = (char)(48 + (n - 52));
        }
        objectArray[62] = 43;
        objectArray[63] = 47;
        d = objectArray;
        objectArray = new byte[128];
        for (n = 0; n < 128; ++n) {
            objectArray[n] = -1;
        }
        n = 65;
        while (n <= 90) {
            int n2 = n++;
            objectArray[n2] = (char)(n2 - 65);
        }
        n = 97;
        while (n <= 122) {
            int n3 = n++;
            objectArray[n3] = (char)(n3 - 97 + 26);
        }
        n = 48;
        while (n <= 57) {
            int n4 = n++;
            objectArray[n4] = (char)(n4 - 48 + 52);
        }
        objectArray[43] = 62;
        objectArray[47] = 63;
        objectArray[61] = 127;
        e = (byte[])objectArray;
    }
}

