/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.V2Form;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;

public class AttCertIssuer
extends AbstractASN1Choice {
    private final Type a;
    public static final ASN1Template TEMPLATE = new a();

    AttCertIssuer(Type type, ASN1Value aSN1Value) {
        super(AttCertIssuer.class, aSN1Value);
        this.a = type;
    }

    public static AttCertIssuer getInstanceV1Form(GeneralNames generalNames) {
        return new AttCertIssuer(Type.V1_FORM, (ASN1Value)generalNames);
    }

    public static AttCertIssuer getInstanceV2Form(V2Form v2Form) {
        return new AttCertIssuer(Type.V2_FORM, (ASN1Value)v2Form);
    }

    public static AttCertIssuer getInstance(byte[] byArray) throws PKIXException {
        try {
            return (AttCertIssuer)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public Type getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        ASN1Tag aSN1Tag;
        if (this.a == Type.V1_FORM) {
            aSN1Tag = GeneralNames.TAG;
        } else {
            Assert.debugAssert((this.a == Type.V2_FORM ? 1 : 0) != 0);
            aSN1Tag = ASN1Tag.get((long)0L);
        }
        return aSN1Tag;
    }

    public GeneralNames getV1Form() {
        if (this.a == Type.V1_FORM) {
            return (GeneralNames)this.value;
        }
        return null;
    }

    public V2Form getV2Form() {
        if (this.a == Type.V2_FORM) {
            return (V2Form)this.value;
        }
        return null;
    }

    public boolean isV1Form() {
        return this.a == Type.V1_FORM;
    }

    public boolean isV2Form() {
        return this.a == Type.V2_FORM;
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(GeneralNames.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)0L), V2Form.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            inputStream = (ASN1Choice)this.choicet.decode(inputStream);
            Type type = object = inputStream.getTag().getNum() == 0L ? Type.V2_FORM : Type.V1_FORM;
            inputStream = inputStream.getValue();
            return new AttCertIssuer(type, (ASN1Value)inputStream);
        }
    }

    public static enum Type {
        V1_FORM,
        V2_FORM;

    }
}

