/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Attributes;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.AttCertIssuer;
import com.bifit.security.pkix.x509.AttCertValidityPeriod;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.Holder;
import com.bifit.security.pkix.x509.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AttributeCertificateInfo
extends AbstractASN1Sequence {
    private ASN1Integer a;
    private Holder b;
    private AttCertIssuer c;
    private AlgorithmIdentifier d;
    private ASN1Integer e;
    private AttCertValidityPeriod f;
    private Attributes g;
    private ASN1BitString h;
    private Extensions i;
    public static final ASN1Template TEMPLATE = new a();

    public AttributeCertificateInfo(Holder holder, AttCertIssuer attCertIssuer, AlgorithmIdentifier algorithmIdentifier, ASN1Integer aSN1Integer, AttCertValidityPeriod attCertValidityPeriod, Attributes attributes) {
        this(Version.v2.getASNValue(), holder, attCertIssuer, algorithmIdentifier, aSN1Integer, attCertValidityPeriod, attributes);
    }

    public AttributeCertificateInfo(ASN1Integer aSN1Integer, Holder holder, AttCertIssuer attCertIssuer, AlgorithmIdentifier algorithmIdentifier, ASN1Integer aSN1Integer2, AttCertValidityPeriod attCertValidityPeriod, Attributes attributes) {
        super(AttributeCertificateInfo.class);
        PKIXUtils.verifyNotNull(aSN1Integer, holder, attCertIssuer, algorithmIdentifier, aSN1Integer2, attCertValidityPeriod, attributes);
        this.a = aSN1Integer;
        this.b = holder;
        this.c = attCertIssuer;
        this.d = algorithmIdentifier;
        this.e = aSN1Integer2;
        this.f = attCertValidityPeriod;
        this.g = attributes;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public void setVersion(ASN1Integer aSN1Integer) {
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.a = aSN1Integer;
    }

    public Holder getHolder() {
        return this.b;
    }

    public void setHolder(Holder holder) {
        PKIXUtils.verifyNotNull(holder);
        this.b = holder;
    }

    public AttCertIssuer getIssuer() {
        return this.c;
    }

    public void setIssuer(AttCertIssuer attCertIssuer) {
        PKIXUtils.verifyNotNull(attCertIssuer);
        this.c = attCertIssuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.d;
    }

    public void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.d = algorithmIdentifier;
    }

    public ASN1Integer getSerialNumber() {
        return this.e;
    }

    public void setSerialNumber(ASN1Integer aSN1Integer) {
        PKIXUtils.verifyNotNull(aSN1Integer);
        this.e = aSN1Integer;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.f;
    }

    public void setAttrCertValidityPeriod(AttCertValidityPeriod attCertValidityPeriod) {
        PKIXUtils.verifyNotNull(attCertValidityPeriod);
        this.f = attCertValidityPeriod;
    }

    public Attributes getAttributes() {
        return this.g;
    }

    public void setAttributes(Attributes attributes) {
        PKIXUtils.verifyNotNull(attributes);
        this.g = attributes;
    }

    public ASN1BitString getIssuerUniqueID() {
        return this.h;
    }

    public void setIssuerUniqueID(ASN1BitString aSN1BitString) {
        this.h = aSN1BitString;
    }

    public Extensions getExtensions() {
        return this.i;
    }

    public void setExtensions(Extensions extensions) {
        this.i = extensions;
    }

    public static AttributeCertificateInfo getInstance(byte[] byArray) throws PKIXException {
        try {
            return (AttributeCertificateInfo)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addElement((ASN1Value)this.e);
        aSN1Sequence.addElement((ASN1Value)this.f);
        aSN1Sequence.addElement((ASN1Value)this.g);
        aSN1Sequence.addOptionalElement((ASN1Value)this.h);
        aSN1Sequence.addOptionalElement((ASN1Value)this.i);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(Holder.TEMPLATE);
            this.seqt.addElement(AttCertIssuer.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(AttCertValidityPeriod.TEMPLATE);
            this.seqt.addElement(Attributes.TEMPLATE);
            this.seqt.addOptionalElement(ASN1BitString.TEMPLATE);
            this.seqt.addOptionalElement(Extensions.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws InvalidBERException, IOException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = new AttributeCertificateInfo((ASN1Integer)aSN1Tag.elementAt(0), (Holder)aSN1Tag.elementAt(1), (AttCertIssuer)aSN1Tag.elementAt(2), (AlgorithmIdentifier)aSN1Tag.elementAt(3), (ASN1Integer)aSN1Tag.elementAt(4), (AttCertValidityPeriod)aSN1Tag.elementAt(5), (Attributes)aSN1Tag.elementAt(6));
            ((AttributeCertificateInfo)object).setIssuerUniqueID((ASN1BitString)aSN1Tag.elementAt(7));
            ((AttributeCertificateInfo)object).setExtensions((Extensions)aSN1Tag.elementAt(8));
            return object;
        }
    }
}

