/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.CryptoConverter;
import com.bifit.security.pkix.crypto.SignatureAdapter;
import com.bifit.security.pkix.crypto.VerifyAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.AbstractASN1Value;
import com.bifit.security.pkix.primitive.Time;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Certificate;
import com.bifit.security.pkix.x509.RevokedCertificate;
import com.bifit.security.pkix.x509.RevokedCertificates;
import com.bifit.security.pkix.x509.TBSCertList;
import com.bifit.security.pkix.x509.ext.DeltaCRLIndicator;
import com.bifit.security.pkix.x509.ext.FreshestCRL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;

public class CertificateList
extends AbstractASN1Sequence {
    private TBSCertList a;
    private AlgorithmIdentifier b;
    private ASN1BitString c;
    public static final ASN1Template TEMPLATE = new a();
    public static final ASN1Template UND_TEMPLATE = new b();

    public CertificateList(TBSCertList tBSCertList, AlgorithmIdentifier algorithmIdentifier, ASN1BitString aSN1BitString) {
        super(CertificateList.class);
        this.debug("tbsCertList = " + tBSCertList + ", sigAlg = " + algorithmIdentifier + "signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(tBSCertList, algorithmIdentifier, aSN1BitString);
        this.a = tBSCertList;
        this.b = algorithmIdentifier;
        this.c = aSN1BitString;
    }

    public CertificateList(TBSCertList tBSCertList, SignatureAdapter signatureAdapter) throws CryptoException {
        super(CertificateList.class);
        this.debug("tbsCertList = " + tBSCertList + ", adapter = " + signatureAdapter);
        PKIXUtils.verifyNotNull(tBSCertList, signatureAdapter);
        this.a = tBSCertList;
        this.b = signatureAdapter.getSignatureAlgorithm();
        this.c = CryptoConverter.signBytes2BitString(signatureAdapter.getSignatureAlgorithm(), signatureAdapter.sign(tBSCertList.encode()));
    }

    public TBSCertList getTbsCertList() {
        return this.a;
    }

    public void setTbsCertList(TBSCertList tBSCertList) {
        this.debug("tbsCertList = " + tBSCertList);
        PKIXUtils.verifyNotNull(tBSCertList);
        this.a = tBSCertList;
    }

    public AlgorithmIdentifier getSigAlg() {
        return this.b;
    }

    public void setSigAlg(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("sigAlg = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public ASN1BitString getSignature() {
        return this.c;
    }

    public void setSignature(ASN1BitString aSN1BitString) {
        this.debug("signature = " + aSN1BitString);
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.c = aSN1BitString;
    }

    public boolean isContain(Certificate certificate) {
        this.debug("cert = " + certificate);
        RevokedCertificates revokedCertificates = this.a.getRevokedCertificates();
        if (revokedCertificates == null) {
            return false;
        }
        certificate = certificate.getInfo().getSerialNumber();
        for (int i = 0; i < revokedCertificates.size(); ++i) {
            ASN1Integer aSN1Integer = ((RevokedCertificate)revokedCertificates.elementAt(i)).getCertSN();
            if (!aSN1Integer.equals((Object)certificate)) continue;
            return true;
        }
        return false;
    }

    public Date getThisUpdate() {
        return this.a.getThisUpdate().toDate();
    }

    public Date getNextUpdate() {
        Time time = this.a.getNextUpdate();
        if (time != null) {
            return time.toDate();
        }
        return null;
    }

    public RevokedCertificate getCertificateInfo(Certificate certificate) {
        this.debug("cert = " + certificate);
        certificate = certificate.getInfo().getSerialNumber();
        return this.getCertificateInfo((ASN1Integer)certificate);
    }

    public RevokedCertificate getCertificateInfo(ASN1Integer aSN1Integer) {
        RevokedCertificates revokedCertificates = this.a.getRevokedCertificates();
        if (revokedCertificates == null) {
            return null;
        }
        return revokedCertificates.getRevokedCertificate(aSN1Integer);
    }

    public boolean isFull() {
        AbstractASN1Value abstractASN1Value = this.a.getCrlExtensions();
        if (abstractASN1Value != null) {
            return (abstractASN1Value = abstractASN1Value.getExtension(FreshestCRL.OID)) != null;
        }
        return false;
    }

    public boolean isDelta() {
        AbstractASN1Value abstractASN1Value = this.a.getCrlExtensions();
        if (abstractASN1Value != null) {
            return (abstractASN1Value = abstractASN1Value.getExtension(DeltaCRLIndicator.OID)) != null;
        }
        return false;
    }

    public boolean isOutdated() {
        Date date = this.a.getNextUpdate().toDate();
        return date != null && new Date().after(date);
    }

    public boolean verify(VerifyAdapter verifyAdapter) throws CryptoException {
        this.debug("adapter = " + verifyAdapter);
        try {
            return verifyAdapter.verify(this.a.encode(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), this.c));
        }
        catch (InvalidBERException invalidBERException) {
            throw new CryptoException("Error verifying signature", (Throwable)invalidBERException);
        }
    }

    public static boolean verifyUndecoded(byte[] object, VerifyAdapter verifyAdapter) throws CryptoException {
        try {
            ASN1Sequence aSN1Sequence = (ASN1Sequence)ASN1Util.decode((ASN1Template)UND_TEMPLATE, (byte[])object);
            object = aSN1Sequence;
            ASN1Any aSN1Any = (ASN1Any)aSN1Sequence.elementAt(0);
            object = (ASN1BitString)object.elementAt(2);
            return verifyAdapter.verify(aSN1Any.getEncoded(), CryptoConverter.signBitString2Bytes(verifyAdapter.getSignatureAlgorithm(), (ASN1BitString)object));
        }
        catch (InvalidBERException invalidBERException) {
            throw new CryptoException("Error verifying signature", (Throwable)invalidBERException);
        }
    }

    public void writeFile(String string) throws IOException {
        this.debug("PATH = " + string);
        PKIXUtils.writeFile(this.encode(), new File(string));
    }

    public static CertificateList getInstance(byte[] byArray) throws PKIXException {
        try {
            return (CertificateList)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public static CertificateList getInstance(File file) throws IOException {
        try {
            return CertificateList.getInstance(PKIXUtils.readFile(file));
        }
        catch (PKIXException pKIXException) {
            throw new IOException("Error reading CRL from file", pKIXException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement((ASN1Value)this.a);
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "CertificateList [tbsCertList=" + this.a + ", sigAlg=" + this.b + ", signature=" + this.c + "]";
    }

    private static final class b
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public b() {
            this.seqt.addElement(ASN1Any.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, inputStream);
            return aSN1Tag;
        }
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addElement(TBSCertList.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(ASN1BitString.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object);
            object = (TBSCertList)aSN1Tag.elementAt(0);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)aSN1Tag.elementAt(1);
            aSN1Tag = (ASN1BitString)aSN1Tag.elementAt(2);
            return new CertificateList((TBSCertList)object, algorithmIdentifier, (ASN1BitString)aSN1Tag);
        }
    }
}

