/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BMPString;
import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1UTF8String;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.ASN1VisibleString;
import com.bifit.security.asn1.AbstractASN1CharacterString;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.util.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DisplayText
extends AbstractASN1Choice {
    public static final int VISIBLE_STRING = 1;
    public static final int BMP_STRING = 2;
    public static final int UTF8_STRING = 3;
    private final int a;
    public static final ASN1Template TEMPLATE = new a();

    private DisplayText(int n, AbstractASN1CharacterString abstractASN1CharacterString) {
        super(DisplayText.class, (ASN1Value)abstractASN1CharacterString);
        this.a = n;
    }

    public int getType() {
        return this.a;
    }

    public ASN1VisibleString getVisibleString() {
        return (ASN1VisibleString)this.value;
    }

    public ASN1BMPString getBMPString() {
        return (ASN1BMPString)this.value;
    }

    public ASN1UTF8String getUTF8String() {
        return (ASN1UTF8String)this.value;
    }

    public static DisplayText createVisibleString(ASN1VisibleString aSN1VisibleString) {
        return new DisplayText(1, (AbstractASN1CharacterString)aSN1VisibleString);
    }

    public static DisplayText createBMPString(ASN1BMPString aSN1BMPString) {
        return new DisplayText(2, (AbstractASN1CharacterString)aSN1BMPString);
    }

    public static DisplayText createUTF8String(ASN1UTF8String aSN1UTF8String) {
        return new DisplayText(3, (AbstractASN1CharacterString)aSN1UTF8String);
    }

    @Override
    public ASN1Tag getTag() {
        if (this.a == 1) {
            return ASN1VisibleString.TAG;
        }
        if (this.a == 2) {
            return ASN1BMPString.TAG;
        }
        Assert.debugAssert((this.a == 3 ? 1 : 0) != 0);
        return ASN1UTF8String.TAG;
    }

    public static DisplayText getInstance(byte[] byArray) throws PKIXException {
        try {
            return (DisplayText)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.value.encode(outputStream);
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(ASN1VisibleString.TEMPLATE);
            this.choicet.addElement(ASN1BMPString.TEMPLATE);
            this.choicet.addElement(ASN1UTF8String.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            if ((inputStream = (ASN1Choice)this.choicet.decode(inputStream)).getTag() == ASN1VisibleString.TAG) {
                return DisplayText.createVisibleString((ASN1VisibleString)inputStream.getValue());
            }
            if (inputStream.getTag() == ASN1BMPString.TAG) {
                return DisplayText.createBMPString((ASN1BMPString)inputStream.getValue());
            }
            Assert.debugAssert((boolean)inputStream.getTag().equals((Object)ASN1UTF8String.TAG));
            return DisplayText.createUTF8String((ASN1UTF8String)inputStream.getValue());
        }
    }
}

