/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.DecodeExtensionException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.AbstractGenericASN1Sequence;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class Extensions
extends AbstractGenericASN1Sequence<Extension> {
    public static final ASN1Template TEMPLATE = new a();

    public Extensions(Extension extension) {
        super(Extensions.class);
        this.sequence.addElement((ASN1Value)extension);
    }

    Extensions(ASN1Sequence aSN1Sequence) {
        super(aSN1Sequence, Extensions.class);
    }

    public Extensions(Extension ... extensionArray) {
        super(Extensions.class);
        if (extensionArray.length == 0) {
            throw new IllegalArgumentException("Must contain at least 1 element");
        }
        this.sequence = new ASN1Sequence();
        for (Extension extension : extensionArray) {
            this.sequence.addElement((ASN1Value)extension);
        }
    }

    public Extension getExtension(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        for (int i = 0; i < this.sequence.size(); ++i) {
            Extension extension = (Extension)this.elementAt(i);
            if (!extension.getOID().equals((Object)aSN1ObjectIdentifier)) continue;
            return extension;
        }
        return null;
    }

    public BaseExtension getDecoded(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Extension extension = this.getExtension(aSN1ObjectIdentifier);
        if (extension == null) {
            return null;
        }
        try {
            return extension.getDecoded();
        }
        catch (Exception exception) {
            this.error("DECODE_EXT_ERROR = " + aSN1ObjectIdentifier, exception);
            return null;
        }
    }

    @Override
    public void removeElementAt(int n) {
        if (this.sequence.size() == 1) {
            throw new IllegalStateException("Must contain at least 1 element");
        }
        super.removeElementAt(n);
    }

    @Override
    public void removeAllElements() {
        throw new IllegalStateException("Must contain at least 1 element");
    }

    public List<BaseExtension> getDecoded() throws DecodeExtensionException {
        ArrayList<BaseExtension> arrayList = new ArrayList<BaseExtension>();
        for (int i = 0; i < this.sequence.size(); ++i) {
            arrayList.add(((Extension)this.elementAt(i)).getDecoded());
        }
        return arrayList;
    }

    public static Extensions getInstance(byte[] byArray) throws PKIXException {
        try {
            return (Extensions)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "Extensions [sequence=" + this.sequence + "]";
    }

    public static Extensions init(Extensions extensions, Extension extension) {
        if (extensions == null) {
            extensions = new Extensions(extension);
        } else {
            extensions.addElement(extension);
        }
        return extensions;
    }

    public static Extensions fromList(List<Extension> list) {
        if (list.isEmpty()) {
            return null;
        }
        Extensions extensions = new Extensions(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            extensions.addElement((ASN1Value)list.get(i));
        }
        return extensions;
    }

    private static final class a
    extends AbstractGenericASN1Sequence.AbstractGenericTemplate {
        public a() {
            super(Extension.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            return new Extensions((ASN1Sequence)this.seqt.decode(aSN1Tag, inputStream));
        }
    }
}

