/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Any;
import com.bifit.security.asn1.ASN1Choice;
import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1IA5String;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.exception.ValidateException;
import com.bifit.security.pkix.primitive.AbstractASN1Choice;
import com.bifit.security.pkix.x509.GeneralNameType;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.pkix.x509.OtherName;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GeneralName
extends AbstractASN1Choice {
    private final GeneralNameType a;
    public static final a TEMPLATE = new a();

    public GeneralName(GeneralNameType generalNameType, ASN1Value aSN1Value) {
        super(GeneralName.class, aSN1Value);
        this.debug("type = " + (Object)((Object)generalNameType) + ", name = " + aSN1Value);
        this.a = generalNameType;
    }

    public GeneralNameType getType() {
        return this.a;
    }

    @Override
    public ASN1Tag getTag() {
        return this.a.getTag();
    }

    public static GeneralName getInstance(byte[] byArray) throws PKIXException {
        try {
            return (GeneralName)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (this.a == GeneralNameType.DIRECTORY_NAME) {
            new ASN1Explicit(this.getTag(), this.value).encode(outputStream);
            return;
        }
        this.value.encode(this.getTag(), outputStream);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.encode(outputStream);
    }

    public String toString() {
        if (this.a == GeneralNameType.IP_ADDRESS) {
            byte[] byArray = ((ASN1OctetString)this.value).toByteArray();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < byArray.length / 2; ++j) {
                    stringBuilder.append((byArray[j + i * byArray.length / 2] & 0xFF) + ".");
                }
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
                stringBuilder.append('/');
            }
            StringBuilder stringBuilder3 = stringBuilder;
            stringBuilder3.deleteCharAt(stringBuilder3.length() - 1);
            return stringBuilder.toString();
        }
        return "GeneralName [type=" + (Object)((Object)this.a) + ", name=" + this.value + "]";
    }

    public static GeneralName parseIPAdress(String stringArray) throws ValidateException {
        stringArray = stringArray.replace('/', '.');
        if ((stringArray = stringArray.split("\\.")).length != 8 && stringArray.length != 32) {
            throw new ValidateException("Illegal address length");
        }
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(stringArray[i]);
        }
        ASN1OctetString aSN1OctetString = new ASN1OctetString(byArray);
        return new GeneralName(GeneralNameType.IP_ADDRESS, (ASN1Value)aSN1OctetString);
    }

    private static final class a
    extends AbstractASN1Choice.AbstractTemplateChoice {
        public a() {
            this.choicet.addElement(ASN1Tag.get((long)0L), OtherName.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)1L), ASN1IA5String.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)2L), ASN1IA5String.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)3L), ASN1Any.TEMPLATE);
            this.choicet.addElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)4L), (ASN1Template)Name.TEMPLATE));
            this.choicet.addElement(ASN1Tag.get((long)5L), ASN1Any.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)6L), ASN1IA5String.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)7L), ASN1OctetString.TEMPLATE);
            this.choicet.addElement(ASN1Tag.get((long)8L), ASN1ObjectIdentifier.TEMPLATE);
        }

        public final ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            GeneralNameType generalNameType = GeneralNameType.getByTag((inputStream = (ASN1Choice)this.choicet.decode(inputStream)).getTag());
            inputStream = generalNameType == GeneralNameType.DIRECTORY_NAME ? ((ASN1Explicit)inputStream.getValue()).getContent() : inputStream.getValue();
            return new GeneralName(generalNameType, (ASN1Value)inputStream);
        }
    }
}

