/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.AbstractASN1Primitive;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.log.PKIXLogger;
import com.bifit.security.pkix.log.PKIXLoggerFactory;
import com.bifit.security.pkix.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.io.OutputStream;

public class KeyIdentifier
extends AbstractASN1Primitive {
    private final ASN1OctetString a;
    public static final ASN1Tag TAG = ASN1OctetString.TAG;
    public static final ASN1Template TEMPLATE = ASN1OctetString.TEMPLATE;
    private static final PKIXLogger b = PKIXLoggerFactory.getLogger(KeyIdentifier.class);

    public KeyIdentifier(SubjectPublicKeyInfo object, DigestAdapter digestAdapter) throws CryptoException {
        b.debug("pubKeyInfo = " + object + ", adapter = " + digestAdapter);
        object = ((SubjectPublicKeyInfo)object).getPublicKeyBytes();
        this.a = new ASN1OctetString(digestAdapter.digest((byte[])object));
    }

    public KeyIdentifier(ASN1OctetString aSN1OctetString) {
        b.debug("identifier = " + aSN1OctetString);
        this.a = aSN1OctetString;
    }

    public ASN1OctetString getIdentifier() {
        return this.a;
    }

    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.a.encode(aSN1Tag, outputStream);
    }

    public ASN1Tag getTag() {
        return TAG;
    }

    public String toString() {
        return "KeyIdentifier [identifier=" + this.a + "]";
    }
}

