/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.primitive.AbstractGenericASN1Sequence;
import com.bifit.security.pkix.x500.DirectoryString;
import com.bifit.security.pkix.x509.AttrValueAssertion;
import com.bifit.security.pkix.x509.GeneralName;
import com.bifit.security.pkix.x509.GeneralNameType;
import com.bifit.security.pkix.x509.NameAttribute;
import com.bifit.security.pkix.x509.RelativeDistinguishedName;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class Name
extends AbstractGenericASN1Sequence<RelativeDistinguishedName> {
    public static final ASN1Template TEMPLATE = new a();

    public Name() {
        super(Name.class);
    }

    public Name(X500Principal object) throws InvalidBERException {
        super(Name.class);
        this.debug("principal = " + object);
        object = (Name)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])((X500Principal)object).getEncoded());
        this.sequence = ((Name)object).sequence;
    }

    public Name(Collection<RelativeDistinguishedName> object) {
        super(Name.class);
        object = object.iterator();
        while (object.hasNext()) {
            RelativeDistinguishedName relativeDistinguishedName = (RelativeDistinguishedName)object.next();
            this.addElement(relativeDistinguishedName);
        }
    }

    public Name(String object) throws CharConversionException {
        super(Name.class);
        this.debug("name = " + (String)object);
        try {
            object = (Name)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])new X500Principal((String)object).getEncoded());
            this.sequence = ((Name)object).sequence;
            return;
        }
        catch (InvalidBERException invalidBERException) {
            throw new CharConversionException(invalidBERException.getMessage());
        }
    }

    Name(ASN1Sequence aSN1Sequence) {
        super(Name.class);
        this.debug("rdns = " + aSN1Sequence);
        this.sequence = aSN1Sequence;
    }

    @Override
    public void addElement(AttrValueAssertion attrValueAssertion) {
        this.debug("attrValueAssertion = " + attrValueAssertion);
        this.addElement(new RelativeDistinguishedName(attrValueAssertion));
    }

    public X500Principal getX500Principal() {
        return new X500Principal(ASN1Util.encode((ASN1Value)this));
    }

    public void addAttribute(NameAttribute nameAttribute, String string) throws CharConversionException, InvalidBERException {
        this.addElement(new AttrValueAssertion(nameAttribute.getOID(), string));
    }

    public void addAttribute(String string, String string2) throws CharConversionException, InvalidBERException {
        this.addAttribute(NameAttribute.valueOf(string), string2);
    }

    public String getAttribute(NameAttribute nameAttribute) throws InvalidBERException {
        nameAttribute = nameAttribute.getOID();
        for (int i = 0; i < this.sequence.size(); ++i) {
            AttrValueAssertion attrValueAssertion = (AttrValueAssertion)((RelativeDistinguishedName)this.sequence.elementAt(i)).elementAt(0);
            if (!attrValueAssertion.getType().equals((Object)nameAttribute)) continue;
            return ((DirectoryString)attrValueAssertion.getValue().decodeWith(DirectoryString.TEMPLATE)).toString();
        }
        return null;
    }

    public GeneralName getAsGeneralName() {
        return new GeneralName(GeneralNameType.DIRECTORY_NAME, (ASN1Value)this);
    }

    public List<NameAttribute> getAttributes() {
        ArrayList<NameAttribute> arrayList = new ArrayList<NameAttribute>();
        for (int i = 0; i < this.sequence.size(); ++i) {
            AttrValueAssertion attrValueAssertion = (AttrValueAssertion)((RelativeDistinguishedName)this.sequence.elementAt(i)).elementAt(0);
            NameAttribute nameAttribute = NameAttribute.getByOID(attrValueAssertion.getType().toString());
            if (nameAttribute != null) {
                arrayList.add(nameAttribute);
                continue;
            }
            this.warn("Uknown attribute : " + attrValueAssertion.getType().toString());
        }
        return arrayList;
    }

    public String getRFC1485() throws InvalidBERException {
        return new X500Principal(this.encode()).toString();
    }

    public String toString() {
        try {
            return this.getRFC1485();
        }
        catch (InvalidBERException invalidBERException) {
            return "Name [rdns=" + this.sequence + "]";
        }
    }

    private static final class a
    extends AbstractGenericASN1Sequence.AbstractGenericTemplate {
        public a() {
            super(RelativeDistinguishedName.TEMPLATE);
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = (ASN1Sequence)this.seqt.decode(aSN1Tag, inputStream);
            return new Name((ASN1Sequence)aSN1Tag);
        }
    }
}

