/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Primitive;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.log.PKIXLogger;
import com.bifit.security.pkix.log.PKIXLoggerFactory;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.ReasonBits;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;

public class ReasonFlags
extends AbstractASN1Primitive {
    private final BitSet a;
    public static final ASN1Tag TAG = ASN1BitString.TAG;
    public static final ASN1Template TEMPLATE = new a();
    private static final PKIXLogger b = PKIXLoggerFactory.getLogger(ReasonFlags.class);

    public ReasonFlags(ReasonBits ... reasonBitsArray) {
        this.a = new BitSet();
        this.a.clear();
        for (ReasonBits reasonBits : reasonBitsArray) {
            this.a.set(reasonBits.getIndex(), true);
        }
    }

    public ReasonFlags(ASN1BitString aSN1BitString) {
        b.debug("bits = " + aSN1BitString);
        PKIXUtils.verifyNotNull(aSN1BitString);
        this.a = aSN1BitString.toBitSet();
    }

    public void setBit(ReasonBits reasonBits, boolean bl) {
        b.debug("bit = " + (Object)((Object)reasonBits) + ", state = " + bl);
        this.a.set(reasonBits.getIndex(), bl);
    }

    public boolean getBit(ReasonBits reasonBits) {
        b.debug("bit = " + (Object)((Object)reasonBits));
        return this.a.get(reasonBits.getIndex());
    }

    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        new ASN1BitString(this.a, this.a.length()).encode(aSN1Tag, outputStream);
    }

    public ASN1Tag getTag() {
        return TAG;
    }

    public static ReasonFlags getInstance(byte[] byArray) throws PKIXException {
        try {
            return (ReasonFlags)ASN1Util.decode((ASN1Template)TEMPLATE, (byte[])byArray);
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public String toString() {
        return "ReasonFlags [bits=" + this.a + "]";
    }

    private static final class a
    implements ASN1Template {
        private final ASN1Template a = ASN1BitString.TEMPLATE;

        public final boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals((Object)aSN1Tag);
        }

        public final ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            aSN1Tag = (ASN1BitString)this.a.decode(aSN1Tag, inputStream);
            return new ReasonFlags((ASN1BitString)aSN1Tag);
        }
    }
}

