/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509;

import com.bifit.security.asn1.ASN1Explicit;
import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.DecodeExtensionException;
import com.bifit.security.pkix.log.DebugLogger;
import com.bifit.security.pkix.primitive.AbstractASN1Sequence;
import com.bifit.security.pkix.primitive.Time;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.AlgorithmIdentifier;
import com.bifit.security.pkix.x509.Extensions;
import com.bifit.security.pkix.x509.Name;
import com.bifit.security.pkix.x509.RevokedCertificates;
import com.bifit.security.pkix.x509.Version;
import com.bifit.security.pkix.x509.ext.CRLNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TBSCertList
extends AbstractASN1Sequence {
    private Version a;
    private AlgorithmIdentifier b;
    private Name c;
    private Time d;
    private Time e;
    private RevokedCertificates f;
    private Extensions g;
    public static final ASN1Template TEMPLATE = new a();

    public TBSCertList(Version version, AlgorithmIdentifier algorithmIdentifier, Name name, Time time) {
        super(TBSCertList.class);
        this.debug("version = " + (Object)((Object)version) + ", signature = " + algorithmIdentifier + ", issuer = " + name + ", thisUpdate = " + time);
        PKIXUtils.verifyNotNull(algorithmIdentifier, name, time);
        this.a = version;
        this.b = algorithmIdentifier;
        this.c = name;
        this.d = time;
        if (version != null && version != Version.v2) {
            throw new IllegalArgumentException("Version present, version MUST be v2");
        }
    }

    public Version getVersion() {
        return this.a;
    }

    public void setVersion(Version version) {
        this.debug("version = " + (Object)((Object)version));
        if (version != null && version != Version.v2) {
            throw new IllegalArgumentException("Version present, version MUST be v2");
        }
        this.a = version;
    }

    public AlgorithmIdentifier getSigAlgorithm() {
        return this.b;
    }

    public void setSigAlgorithm(AlgorithmIdentifier algorithmIdentifier) {
        this.debug("sigAlg = " + algorithmIdentifier);
        PKIXUtils.verifyNotNull(algorithmIdentifier);
        this.b = algorithmIdentifier;
    }

    public Name getIssuer() {
        return this.c;
    }

    public void setIssuer(Name name) {
        this.debug("issuer = " + name);
        PKIXUtils.verifyNotNull(name);
        this.c = name;
    }

    public Time getThisUpdate() {
        return this.d;
    }

    public void setThisUpdate(Time time) {
        this.debug("thisUpdate = " + time);
        PKIXUtils.verifyNotNull(time);
        this.d = time;
    }

    public Time getNextUpdate() {
        return this.e;
    }

    public void setNextUpdate(Time time) {
        this.debug("nextUpdate = " + time);
        this.e = time;
    }

    public RevokedCertificates getRevokedCertificates() {
        return this.f;
    }

    public void setRevokedCertificates(RevokedCertificates revokedCertificates) {
        this.debug("revokedCertificates = " + revokedCertificates);
        if (revokedCertificates != null && revokedCertificates.hasExtensions() && this.a != Version.v2) {
            throw new IllegalArgumentException("Revoked certificates extensions is present, version MUST be v2");
        }
        this.f = revokedCertificates;
    }

    public Extensions getCrlExtensions() {
        return this.g;
    }

    public void setCrlExtensions(Extensions extensions) {
        this.debug("crlExtensions = " + extensions);
        if (extensions != null && this.a != Version.v2) {
            throw new IllegalArgumentException("CRL extensions present, version MUST be v2");
        }
        this.g = extensions;
    }

    public ASN1Integer getCRLNumber() throws DecodeExtensionException {
        DebugLogger debugLogger;
        if (this.g != null && (debugLogger = this.g.getExtension(CRLNumber.OID)) != null) {
            debugLogger = (CRLNumber)debugLogger.getDecoded();
            return ((CRLNumber)debugLogger).getNumber();
        }
        return null;
    }

    public int getRCCount() {
        if (this.f == null) {
            return 0;
        }
        return this.f.size();
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != null) {
            aSN1Sequence.addElement((ASN1Value)this.a.getASNValue());
        }
        aSN1Sequence.addElement((ASN1Value)this.b);
        aSN1Sequence.addElement((ASN1Value)this.c);
        aSN1Sequence.addElement((ASN1Value)this.d);
        aSN1Sequence.addOptionalElement((ASN1Value)this.e);
        aSN1Sequence.addOptionalElement((ASN1Value)this.f);
        aSN1Sequence.addOptionalExplicitElement(ASN1Tag.get((long)0L), (ASN1Value)this.g);
        aSN1Sequence.encode(aSN1Tag, outputStream);
    }

    public String toString() {
        return "TBSCertList [version=" + (Object)((Object)this.a) + ", signature=" + this.b + ", issuer=" + this.c + ", thisUpdate=" + this.d + ", nextUpdate=" + this.e + ", revokedCertificates=" + this.f + ", crlExtensions=" + this.g + "]";
    }

    private static final class a
    extends AbstractASN1Sequence.AbstractTemplateSequence {
        public a() {
            this.seqt.addOptionalElement(ASN1Integer.TEMPLATE);
            this.seqt.addElement(AlgorithmIdentifier.TEMPLATE);
            this.seqt.addElement(Name.TEMPLATE);
            this.seqt.addElement((ASN1Template)Time.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)Time.TEMPLATE);
            this.seqt.addOptionalElement(RevokedCertificates.TEMPLATE);
            this.seqt.addOptionalElement((ASN1Template)ASN1Explicit.getTemplate((ASN1Tag)ASN1Tag.get((long)0L), (ASN1Template)Extensions.TEMPLATE));
        }

        @Override
        public final ASN1Value decode(ASN1Tag aSN1Tag, InputStream object) throws IOException, InvalidBERException {
            object = (object = (ASN1Integer)(aSN1Tag = this.getSequence(aSN1Tag, (InputStream)object)).elementAt(0)) == null ? null : Version.fromASNInt((ASN1Integer)object);
            AlgorithmIdentifier algorithmIdentifier = (AlgorithmIdentifier)aSN1Tag.elementAt(1);
            Name name = (Name)aSN1Tag.elementAt(2);
            Time time = (Time)aSN1Tag.elementAt(3);
            Time time2 = (Time)aSN1Tag.elementAt(4);
            RevokedCertificates revokedCertificates = (RevokedCertificates)aSN1Tag.elementAt(5);
            aSN1Tag = (ASN1Explicit)aSN1Tag.elementAt(6);
            object = new TBSCertList((Version)((Object)object), algorithmIdentifier, name, time);
            ((TBSCertList)object).setNextUpdate(time2);
            ((TBSCertList)object).setRevokedCertificates(revokedCertificates);
            ((TBSCertList)object).setCrlExtensions(aSN1Tag == null ? null : (Extensions)aSN1Tag.getContent());
            return object;
        }
    }
}

