/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.GeneralName;
import com.bifit.security.pkix.x509.GeneralNames;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public abstract class AlternativeName
extends BaseExtension {
    protected GeneralNames names;

    public AlternativeName(Extension extension, ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(extension, AlternativeName.class, aSN1ObjectIdentifier);
    }

    public AlternativeName() {
        super(AlternativeName.class);
    }

    protected AlternativeName(GeneralNames generalNames) {
        super(AlternativeName.class);
        this.debug("names = " + generalNames);
        PKIXUtils.verifyNotNull(generalNames);
        this.names = generalNames;
    }

    protected AlternativeName(GeneralName generalName) {
        super(AlternativeName.class);
        this.debug("initial = " + generalName);
        PKIXUtils.verifyNotNull(generalName);
        this.names = new GeneralNames(generalName);
    }

    protected AlternativeName(Extension extension) {
        super(AlternativeName.class);
        this.debug("ext = " + extension);
        PKIXUtils.verifyNotNull(extension);
    }

    public void addName(GeneralName generalName) {
        this.debug("name = " + generalName);
        PKIXUtils.verifyNotNull(generalName);
        this.names.addElement(generalName);
    }

    public GeneralName nameAt(int n) {
        this.debug("INDEX = " + n);
        return (GeneralName)this.names.elementAt(n);
    }

    public void removeNameAt(int n) {
        this.debug("INDEX = " + n);
        this.names.removeElementAt(n);
    }

    public GeneralNames getNames() {
        return this.names;
    }

    public int size() {
        return this.names.size();
    }

    public int hashCode() {
        return 31 + (this.names == null ? 0 : this.names.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (AlternativeName)object;
        return !(this.names == null ? ((AlternativeName)object).names != null : !this.names.equals(((AlternativeName)object).names));
    }

    public String toString() {
        return "AlternativeName [names=" + this.names + "]";
    }
}

