/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.DistributionPoint;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import com.bifit.security.pkix.x509.ext.CRLDistributionPoints;

public abstract class DistributionPoints
extends BaseExtension {
    protected ASN1Sequence points;
    private static final ASN1Sequence.OF_Template a = ASN1Sequence.getSequenceTemplate((ASN1Template)DistributionPoint.TEMPLATE);

    protected DistributionPoints(DistributionPoint distributionPoint) {
        super(CRLDistributionPoints.class);
        this.debug("initial = " + distributionPoint);
        PKIXUtils.verifyNotNull(distributionPoint);
        this.points = new ASN1Sequence();
        this.points.addElement((ASN1Value)distributionPoint);
    }

    protected DistributionPoints(Extension extension, ASN1ObjectIdentifier aSN1ObjectIdentifier) throws InvalidBERException {
        super(extension, CRLDistributionPoints.class, aSN1ObjectIdentifier);
        this.points = ASN1Sequence.getInstance((ASN1Template)a, (byte[])extension.getContent());
    }

    public void addPoint(DistributionPoint distributionPoint) {
        this.debug("point = " + distributionPoint);
        PKIXUtils.verifyNotNull(distributionPoint);
        this.points.addElement((ASN1Value)distributionPoint);
    }

    public DistributionPoint pointAt(int n) {
        this.debug("INDEX = " + n);
        return (DistributionPoint)this.points.elementAt(n);
    }

    public void insertPointAt(DistributionPoint distributionPoint, int n) {
        this.debug("point = " + distributionPoint + ", index = " + n);
        PKIXUtils.verifyNotNull(distributionPoint);
        this.points.insertElementAt((ASN1Value)distributionPoint, n);
    }

    public void removePointAt(int n) {
        this.debug("INDEX = " + n);
        if (this.points.size() == 1) {
            throw new IllegalStateException("Must containt at leasn 1 element");
        }
        this.points.removeElementAt(n);
    }

    public int size() {
        return this.points.size();
    }

    public int hashCode() {
        return 31 + (this.points == null ? 0 : this.points.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (DistributionPoints)object;
        return !(this.points == null ? ((DistributionPoints)object).points != null : !this.points.equals((Object)((DistributionPoints)object).points));
    }

    public String toString() {
        return "DistributionPoints [points=" + this.points + "]";
    }
}

