/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import java.util.Collection;

public class ExtKeyUsage
extends BaseExtension {
    private final ASN1Sequence a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.37");
    private static final ASN1Sequence.OF_Template b = ASN1Sequence.getSequenceTemplate((ASN1Template)ASN1ObjectIdentifier.TEMPLATE);

    public ExtKeyUsage(Extension extension) throws InvalidBERException {
        super(extension, ExtKeyUsage.class, OID);
        this.a = ASN1Sequence.getInstance((ASN1Template)b, (byte[])extension.getContent());
    }

    public ExtKeyUsage(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        super(ExtKeyUsage.class);
        this.debug("keyPurposeId = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a = new ASN1Sequence();
        this.a.addElement((ASN1Value)aSN1ObjectIdentifier);
    }

    public void addKeyPurposeId(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        this.debug("keyPurposeId = " + aSN1ObjectIdentifier);
        PKIXUtils.verifyNotNull(aSN1ObjectIdentifier);
        this.a.addElement((ASN1Value)aSN1ObjectIdentifier);
    }

    public ASN1ObjectIdentifier keyPurposeIdAt(int n) {
        this.debug("index=" + n);
        return (ASN1ObjectIdentifier)this.a.elementAt(n);
    }

    public void insertKeyPurposeIdAt(ASN1ObjectIdentifier aSN1ObjectIdentifier, int n) {
        this.debug("keyPurposeId=" + aSN1ObjectIdentifier + ", index=" + n);
        this.a.insertElementAt((ASN1Value)aSN1ObjectIdentifier, n);
    }

    public void removeKeyPurposeIdAt(int n) {
        this.debug("index=" + n);
        if (this.a.size() == 1) {
            throw new IllegalStateException("Must contain at least 1 element");
        }
        this.a.removeElementAt(n);
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (ExtKeyUsage)object;
        return !(this.a == null ? ((ExtKeyUsage)object).a != null : !this.a.equals((Object)((ExtKeyUsage)object).a));
    }

    public String toString() {
        return "ExtKeyUsage [keyPurposeIds=" + this.a + "]";
    }

    public static ExtKeyUsage initFrom(Collection<ASN1ObjectIdentifier> object) throws IllegalArgumentException {
        if (object.isEmpty()) {
            throw new IllegalArgumentException("oids is empty");
        }
        ExtKeyUsage extKeyUsage = null;
        object = object.iterator();
        while (object.hasNext()) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)object.next();
            if (extKeyUsage == null) {
                extKeyUsage = new ExtKeyUsage(aSN1ObjectIdentifier);
                continue;
            }
            extKeyUsage.addKeyPurposeId(aSN1ObjectIdentifier);
        }
        return extKeyUsage;
    }
}

