/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1BitString;
import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;
import com.bifit.security.pkix.x509.ext.UsageBits;
import java.util.BitSet;

public class KeyUsage
extends BaseExtension {
    private final BitSet a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.15");

    public KeyUsage(UsageBits ... usageBitsArray) {
        super(KeyUsage.class);
        this.a = new BitSet();
        this.a.clear();
        for (UsageBits usageBits : usageBitsArray) {
            this.a.set(usageBits.getIndex(), true);
        }
    }

    public KeyUsage(Extension extension) throws InvalidBERException {
        super(extension, KeyUsage.class, OID);
        extension = ASN1BitString.getInstance((byte[])extension.getContent());
        this.a = extension.toBitSet();
    }

    public KeyUsage() {
        super(KeyUsage.class);
        this.a = new BitSet(9);
        this.a.clear();
    }

    public void setBit(UsageBits usageBits, boolean bl) {
        this.debug("bit = " + (Object)((Object)usageBits) + ", state = " + bl);
        this.a.set(usageBits.getIndex(), bl);
    }

    public boolean getBit(UsageBits usageBits) {
        this.debug("bit = " + (Object)((Object)usageBits));
        return this.a.get(usageBits.getIndex());
    }

    @Override
    public Extension getExtension(boolean bl) {
        ASN1BitString aSN1BitString = new ASN1BitString(this.a, this.a.length());
        return this.buildExtension(OID, bl, aSN1BitString.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (KeyUsage)object;
        return !(this.a == null ? ((KeyUsage)object).a != null : !this.a.equals(((KeyUsage)object).a));
    }

    public String toString() {
        return "KeyUsage [bitset=" + this.a + "]";
    }
}

