/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1Sequence;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.exception.PKIXException;
import com.bifit.security.pkix.primitive.Attribute;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class SubjectDirectoryAttributes
extends BaseExtension {
    private final ASN1Sequence a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.9");
    private static final ASN1Sequence.OF_Template b = ASN1Sequence.getSequenceTemplate((ASN1Template)Attribute.TEMPLATE);

    public SubjectDirectoryAttributes(Extension extension) throws PKIXException {
        super(extension, SubjectDirectoryAttributes.class, OID);
        try {
            this.a = ASN1Sequence.getInstance((ASN1Template)b, (byte[])extension.getContent());
            return;
        }
        catch (InvalidBERException invalidBERException) {
            throw new PKIXException(2, (Throwable)invalidBERException);
        }
    }

    public SubjectDirectoryAttributes(Attribute attribute) {
        super(SubjectDirectoryAttributes.class);
        this.debug("initial = " + attribute);
        PKIXUtils.verifyNotNull(attribute);
        this.a = new ASN1Sequence();
        this.a.addElement((ASN1Value)attribute);
    }

    public void addElement(Attribute attribute) {
        this.debug("attr = " + attribute);
        PKIXUtils.verifyNotNull(attribute);
        this.a.addElement((ASN1Value)attribute);
    }

    public Attribute elementAt(int n) {
        this.debug("INDEX = " + n);
        return (Attribute)this.a.elementAt(n);
    }

    public void insertElementAt(Attribute attribute, int n) {
        this.debug("attr = " + attribute + ", index = " + n);
        PKIXUtils.verifyNotNull(attribute);
        this.a.insertElementAt((ASN1Value)attribute, n);
    }

    public void removeElementAt(int n) {
        this.debug("INDEX = " + n);
        if (this.a.size() == 1) {
            throw new IllegalStateException("Must contain at least 1 element");
        }
        this.a.removeElementAt(n);
    }

    public int size() {
        return this.a.size();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SubjectDirectoryAttributes)object;
        return !(this.a == null ? ((SubjectDirectoryAttributes)object).a != null : !this.a.equals((Object)((SubjectDirectoryAttributes)object).a));
    }

    public String toString() {
        return "SubjectDirectoryAttributes [attrs=" + this.a + "]";
    }
}

