/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.pkix.x509.ext;

import com.bifit.security.asn1.ASN1ObjectIdentifier;
import com.bifit.security.asn1.ASN1OctetString;
import com.bifit.security.asn1.InvalidBERException;
import com.bifit.security.pkix.crypto.DigestAdapter;
import com.bifit.security.pkix.exception.CryptoException;
import com.bifit.security.pkix.utils.PKIXUtils;
import com.bifit.security.pkix.x509.Extension;
import com.bifit.security.pkix.x509.KeyIdentifier;
import com.bifit.security.pkix.x509.SubjectPublicKeyInfo;
import com.bifit.security.pkix.x509.ext.BaseExtension;

public class SubjectKeyIdentifier
extends BaseExtension {
    private KeyIdentifier a;
    public static final ASN1ObjectIdentifier OID = new ASN1ObjectIdentifier("2.5.29.14");

    public SubjectKeyIdentifier(Extension extension) throws InvalidBERException {
        super(extension, SubjectKeyIdentifier.class, OID);
        extension = ASN1OctetString.getInstance((byte[])extension.getContent());
        this.a = new KeyIdentifier((ASN1OctetString)extension);
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo subjectPublicKeyInfo, DigestAdapter digestAdapter) throws CryptoException {
        super(SubjectKeyIdentifier.class);
        this.debug("keyInfo = " + subjectPublicKeyInfo + ", adapter = " + digestAdapter);
        PKIXUtils.verifyNotNull(subjectPublicKeyInfo, digestAdapter);
        this.a = new KeyIdentifier(subjectPublicKeyInfo, digestAdapter);
    }

    public SubjectKeyIdentifier(KeyIdentifier keyIdentifier) {
        super(SubjectKeyIdentifier.class);
        this.debug("keyIdentifier = " + (Object)((Object)keyIdentifier));
        PKIXUtils.verifyNotNull(new Object[]{keyIdentifier});
        this.a = keyIdentifier;
    }

    public void setKeyIdentifier(KeyIdentifier keyIdentifier) {
        this.debug("keyIdentifier = " + (Object)((Object)keyIdentifier));
        PKIXUtils.verifyNotNull(new Object[]{keyIdentifier});
        this.a = keyIdentifier;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.a;
    }

    public byte[] getKeyIdentifierBytes() {
        return this.a.getIdentifier().toByteArray();
    }

    @Override
    public Extension getExtension(boolean bl) {
        return this.buildExtension(OID, bl, this.a.encode());
    }

    public int hashCode() {
        return 31 + (this.a == null ? 0 : this.a.hashCode());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (SubjectKeyIdentifier)object;
        return !(this.a == null ? ((SubjectKeyIdentifier)object).a != null : !this.a.equals((Object)((SubjectKeyIdentifier)object).a));
    }

    public String toString() {
        return "SubjectKeyIdentifier [keyIdentifier=" + (Object)((Object)this.a) + "]";
    }
}

