/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.AESSecretKey;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;

public class AESKeyGenerator {
    private final SecurePRNG a;

    public AESKeyGenerator(SecurePRNG securePRNG) {
        this.a = securePRNG;
    }

    public AESSecretKey generate() {
        byte[] byArray = new byte[32];
        this.a.nextBytes(byArray);
        AESSecretKey aESSecretKey = new AESSecretKey(byArray);
        Utils.clean(byArray);
        return aESSecretKey;
    }

    public AESSecretKey generate(int n2) {
        if (n2 != 128 && n2 != 192 && n2 != 256) {
            throw new IllegalArgumentException("size must be 128/192/256");
        }
        byte[] byArray = new byte[n2 / 8];
        this.a.nextBytes(byArray);
        AESSecretKey aESSecretKey = new AESSecretKey(byArray);
        Utils.clean(byArray);
        return aESSecretKey;
    }
}

