/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSAParams;
import com.bifit.security.core.Digest;
import com.bifit.security.core.GFp;
import com.bifit.security.core.SHA1Digest;
import com.bifit.security.core.SHA256Digest;
import com.bifit.security.core.Utils;
import java.security.SecureRandom;
import java.util.Random;

public class DSAParametersGenerator {
    private Digest a;
    private final SecureRandom b;
    private final int c;
    private int d;
    private final int e;
    private boolean f;
    private final BigInt g;
    private final int[] h;
    private int[] i;
    private final int[] j;

    public DSAParametersGenerator(int n2, SecureRandom secureRandom) {
        if (n2 < 512 || n2 > 3072 || n2 % 64 != 0) {
            throw new IllegalArgumentException("strength must be from 512 - 3072 and a multiple of 64");
        }
        this.c = n2;
        this.b = secureRandom;
        if (n2 > 1024) {
            this.a = new SHA256Digest();
            this.d = 256;
            this.f = true;
        } else {
            this.a = new SHA1Digest();
            this.d = 160;
            this.f = false;
        }
        this.a.init();
        this.e = n2 / 32;
        this.g = new BigInt(this.e);
        this.h = new int[this.e];
        this.i = new int[this.e];
        this.j = new int[this.e];
    }

    /*
     * Unable to fully structure code
     */
    public DSAParams generateParameters() {
        if (this.f) {
            var1_1 = this;
            var2_3 = var1_1.a.getDigestSize() << 3;
            var3_5 = var1_1.d;
            var4_8 = new byte[var3_5 / 8];
            var5_10 = (var1_1.c - 1) / var2_3;
            var6_12 = (var1_1.c - 1) % var2_3;
            var7_14 = new byte[var1_1.a.getDigestSize()];
            var8_16 = new int[var1_1.e];
            var9_18 = new int[var1_1.e / 2];
            var10_21 = new BigInt(var1_1.e / 2);
            while (true) {
                var1_1.b.nextBytes(var4_8);
                var1_1.a(var4_8, var7_14);
                var11_23 = Utils.fromByteArray(var7_14, var1_1.c / 32);
                var12_27 = new int[var1_1.e];
                BigInt.shiftLeft(var1_1.g.getOne(), var1_1.d - 1, var12_27);
                var1_1.g.divide(var11_23, var12_27, null, var8_16);
                var1_1.g.divide(var8_16, var1_1.g.getTwo(), null, var1_1.i);
                var1_1.g.subtract(var1_1.g.getOne(), var1_1.i, var1_1.i);
                var1_1.g.add(var8_16, var1_1.i, var1_1.i);
                var1_1.g.add(var12_27, var1_1.i, var1_1.i);
                if (!BigInt.isPrime(var1_1.i)) continue;
                var3_6 = Utils.copy(var4_8);
                var11_24 = 4 * var1_1.c;
                var13_29 = 0;
                while (true) {
                    if (var13_29 >= var11_24) ** break;
                    var14_30 = Utils.copy(var1_1.g.getZero());
                    var15_31 = new int[var1_1.e / 2];
                    var16_32 = new int[var1_1.e / 2];
                    var17_34 = 0;
                    var18_36 = 0;
                    while (var17_34 <= var5_10) {
                        DSAParametersGenerator.a(var3_6);
                        var1_1.a(var3_6, var7_14);
                        var19_37 = Utils.fromByteArray(var7_14, var1_1.e);
                        if (var17_34 == var5_10) {
                            BigInt.shiftLeft(var10_21.getOne(), var6_12, var15_31);
                            var10_21.divide(var19_37, var15_31, null, var16_32);
                            System.arraycopy(var16_32, 0, var19_37, var1_1.e / 2, var16_32.length);
                        }
                        BigInt.shiftLeft(var19_37, var18_36, var19_37);
                        var1_1.g.add(var14_30, var19_37, var14_30);
                        ++var17_34;
                        var18_36 += var2_3;
                    }
                    var17_33 = new int[var1_1.e];
                    BigInt.shiftLeft(var1_1.g.getOne(), var1_1.c - 1, var12_27);
                    var1_1.g.add(var14_30, var12_27, var17_33);
                    var18_35 = new int[var1_1.e];
                    var19_37 = new int[var1_1.e];
                    BigInt.shiftLeft(var1_1.i, 1, var19_37);
                    System.arraycopy(var19_37, var1_1.e / 2, var9_18, 0, var9_18.length);
                    var10_21.divide(var17_33, var9_18, null, var16_32);
                    System.arraycopy(var16_32, 0, var18_35, var1_1.e / 2, var16_32.length);
                    var1_1.g.subtract(var18_35, var1_1.g.getOne(), var1_1.h);
                    var1_1.g.subtract(var17_33, var1_1.h, var1_1.h);
                    if (BigInt.bitLength(var1_1.h) != var1_1.c || !BigInt.isPrime(var1_1.h)) {
                        ++var13_29;
                        continue;
                    }
                    ** GOTO lbl122
                    break;
                }
                break;
            }
        } else {
            var1_2 = this;
            var2_4 = new byte[20];
            var3_7 = new byte[20];
            var4_9 = new byte[20];
            var5_11 = new byte[20];
            var6_13 = (var1_2.c - 1) / 160;
            var7_15 = new byte[var1_2.c / 8];
            var8_17 = new int[var1_2.e];
            while (true) {
                var1_2.b.nextBytes(var2_4);
                var1_2.a(var2_4, var3_7);
                DSAParametersGenerator.a(var4_9);
                var1_2.a(var4_9, var4_9);
                for (var9_19 = 0; var9_19 != var5_11.length; ++var9_19) {
                    var5_11[var9_19] = (byte)(var3_7[var9_19] ^ var4_9[var9_19]);
                }
                var5_11[0] = (byte)(var5_11[0] | -128);
                var5_11[19] = (byte)(var5_11[19] | 1);
                var1_2.i = Utils.fromByteArray(var5_11, var1_2.e);
                if (!BigInt.isPrime(var1_2.i)) continue;
                var9_20 = Utils.copy(var2_4);
                DSAParametersGenerator.a(var9_20);
                var10_22 = 0;
                while (true) {
                    if (var10_22 >= 4096) ** break;
                    for (var11_26 = 0; var11_26 < var6_13; ++var11_26) {
                        DSAParametersGenerator.a(var9_20);
                        var1_2.a(var9_20, var3_7);
                        System.arraycopy(var3_7, 0, var7_15, var7_15.length - (var11_26 + 1) * var3_7.length, var3_7.length);
                    }
                    DSAParametersGenerator.a(var9_20);
                    var1_2.a(var9_20, var3_7);
                    System.arraycopy(var3_7, var3_7.length - (var7_15.length - var6_13 * var3_7.length), var7_15, 0, var7_15.length - var6_13 * var3_7.length);
                    var7_15[0] = (byte)(var7_15[0] | -128);
                    var11_25 = Utils.fromByteArray(var7_15, var1_2.e);
                    var12_28 = new int[var1_2.e];
                    BigInt.shiftLeft(var1_2.i, 1, var12_28);
                    var1_2.g.divide(var11_25, var12_28, null, var8_17);
                    var1_2.g.subtract(var8_17, var1_2.g.getOne(), var8_17);
                    var1_2.g.subtract(var11_25, var8_17, var1_2.h);
                    if (BigInt.bitLength(var1_2.h) == var1_2.c && BigInt.isPrime(var1_2.h)) {
                        var1_2.a();
                        return new DSAParams(var1_2.h, var1_2.i, var1_2.j);
                    }
                    ++var10_22;
                }
                break;
            }
        }
lbl122:
        // 1 sources

        var1_1.a();
        return new DSAParams(var1_1.h, var1_1.i, var1_1.j);
    }

    private void a() {
        int[] nArray = new int[this.e];
        int[] nArray2 = new int[this.e];
        int[] nArray3 = new int[this.e];
        int[] nArray4 = new int[this.e / 2];
        BigInt bigInt = new BigInt(this.e / 2);
        GFp gFp = new GFp(this.h);
        this.g.subtract(this.h, this.g.getOne(), nArray);
        System.arraycopy(this.i, this.e / 2, nArray4, 0, nArray4.length);
        bigInt.divide(nArray, nArray4, nArray, null);
        this.g.subtract(this.h, this.g.getTwo(), nArray2);
        do {
            this.g.getRandomNumber((Random)this.b, nArray2, nArray3);
            gFp.modPow(nArray3, nArray, this.j);
        } while (BigInt.bitLength(this.j) <= 1);
    }

    private void a(byte[] byArray, byte[] byArray2) {
        this.a.update(byArray, 0, byArray.length);
        this.a.doFinal(byArray2, 0);
    }

    private static void a(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)(byArray[i2] + 1);
            if (byArray[i2] != 0) break;
        }
    }
}

