/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.DSTU4145ECPublicKey;
import com.bifit.security.core.GF2m;
import com.bifit.security.core.LongIntUtils;
import com.bifit.security.core.Utils;
import com.bifit.security.core.i;
import com.bifit.security.core.j;
import com.bifit.security.core.n;
import com.bifit.security.core.p;
import java.util.Hashtable;
import java.util.Vector;

public class DSTU4145ECParams {
    private static final a a = new a(new int[]{163, 7, 6, 3, 0}, 1, new long[]{25759385670L, 3039305367783998354L, 6801431705480944929L}, new int[]{4, 0, 0, 179905, 736241197, 968683853});
    private static final n b = new n(new long[]{30828560275L, -6252471286329572945L, -111314159704734688L}, new long[]{575315001L, 5153573279446441311L, 5384072195163291035L});
    private static final n c = new n(new long[]{12397862749L, -2932712505693953166L, 3015996283523965886L}, new long[]{15073214602L, -8335644244332717616L, 4607428764749361722L});
    public static final DSTU4145ECParams DEFAULT_STD_1 = new DSTU4145ECParams(a, c, null);
    public static final DSTU4145ECParams DEFAULT_1 = new DSTU4145ECParams(a, b, null);
    private static final a d = new a(new int[]{167, 6, 0}, 1, new long[]{476268391203L, 581375153209969161L, 3526780515086663084L}, new int[]{63, -1, -1, -20178, -1127753742, -1611173857});
    private static final n e = new n(new long[]{7523676952L, 1752969445768858635L, -1772594148711036693L}, new long[]{453603315472L, 1525851118544520018L, -8219602391391431060L});
    private static final n f = new n(new long[]{524512809848L, 7667406025247492669L, 3509045187187952980L}, new long[]{409262040696L, 2021771778737657561L, -8154833770284476136L});
    public static final DSTU4145ECParams DEFAULT_STD_2 = new DSTU4145ECParams(d, f, null);
    public static final DSTU4145ECParams DEFAULT_2 = new DSTU4145ECParams(d, e, null);
    private static final a g = new a(new int[]{173, 10, 2, 1, 0}, 0, new long[]{18165409514649L, -2652688973583448773L, -4960838772926957607L}, new int[]{2048, 0, 0, 1612622, 1734372920, 633022513});
    private static final n h = new n(new long[]{7435025588362L, -8454918793609104977L, 7758116407448570824L}, new long[]{7586171245375L, -1212000065851086614L, -8079133565273891640L});
    private static final n i = new n(new long[]{5309022182348L, 7975294692401229741L, 6231453021204875722L}, new long[]{18370057545801L, -5605636427786091893L, -576640948178939487L});
    public static final DSTU4145ECParams DEFAULT_STD_3 = new DSTU4145ECParams(g, i, null);
    public static final DSTU4145ECParams DEFAULT_3 = new DSTU4145ECParams(g, h, null);
    private static final a j = new a(new int[]{179, 4, 2, 1, 0}, 1, new long[]{1309383147726403L, 8011772745012691427L, 3243744318170511120L}, new int[]{262143, -1, -1, -4619882, 70647386, -1237174545});
    private static final n k = new n(new long[]{758717990850524L, -4243295705922133221L, -927135247279043711L}, new long[]{1178362820198616L, 3250430202400681434L, 3726985072667246381L});
    private static final n l = new n(new long[]{1893389059573323L, 3157706983751582107L, -6226993501537796861L}, new long[]{668211921388252L, -1439374516814706774L, -69391783421003106L});
    public static final DSTU4145ECParams DEFAULT_STD_4 = new DSTU4145ECParams(j, l, null);
    public static final DSTU4145ECParams DEFAULT_4 = new DSTU4145ECParams(j, k, null);
    private static final a m = new a(new int[]{191, 9, 0}, 1, new long[]{8919500150063247044L, -3059898479858318849L, 2873375895962188803L}, new int[]{0x40000000, 0, 0, 1772583370, -1042629529, -1997060273});
    private static final n n = new n(new long[]{8160826777643712330L, 8724218851934910901L, -4396359349787987671L}, new long[]{3009563808046237207L, -1160362797140568326L, -7632530937924089638L});
    public static final DSTU4145ECParams DEFAULT_STD_5 = new DSTU4145ECParams(m, n, null);
    public static final DSTU4145ECParams DEFAULT_5 = new DSTU4145ECParams(m, n, null);
    private static final a o = new a(new int[]{233, 9, 4, 1, 0}, 1, new long[]{452912566421L, 7445915591711286434L, 2005596026949044739L, 2786201423598406956L}, new int[]{256, 0, 0, 0, 1304948, -416314775, 570629414, 63955159});
    private static final n p = new n(new long[]{264924913652L, -2322681505689660446L, 5900192019285315862L, -5110986252971857284L}, new long[]{581885447049L, -8251395032409564860L, -1788662688025962911L, -1091157134779302659L});
    private static final n q = new n(new long[]{274033092278L, -3605065938739793061L, 4337377783954404135L, 2940854880402603670L}, new long[]{672845363859L, 5500266157265209979L, -4982847904431356595L, 3656372720593898805L});
    public static final DSTU4145ECParams DEFAULT_STD_6 = new DSTU4145ECParams(o, q, null);
    public static final DSTU4145ECParams DEFAULT_6 = new DSTU4145ECParams(o, p, null);
    private static final a r = new a(new int[]{257, 12, 0}, 0, new long[]{1L, -3534036590213634690L, 1799532024991851412L, -30357785459009658L, 2278516206172618256L}, new int[]{0, 0, Integer.MIN_VALUE, 0, 0, 0, 1733894458, -243078777, -740198636, -1870838003});
    private static final n s = new n(new long[]{0L, -1311470187853955981L, -1839655875665586691L, 3668058240778757893L, -5589039563345877244L}, new long[]{1L, -6139909388483018067L, 379931803445732198L, -5471570491003560658L, 7919429548838331066L});
    private static final n t = new n(new long[]{0L, 3038222346454211436L, 6182639692948471296L, 8846355865286002211L, 3794820196264447927L}, new long[]{1L, 470296444864353348L, -6931894314853191422L, -1837138160269259881L, -8399163889990232849L});
    public static final DSTU4145ECParams DEFAULT_STD_7 = new DSTU4145ECParams(r, t, null);
    public static final DSTU4145ECParams DEFAULT_7 = new DSTU4145ECParams(r, s, null);
    private static final a u = new a(new int[]{307, 8, 4, 2, 0}, 1, new long[]{1006911995852390L, -5402829309042934295L, 5711293032152294114L, -2143426390206488432L, -4771280652764354373L}, new int[]{262143, -1, -1, -1, -1, -4163134, -209560153, 221843387, -1517759392, 1076017079});
    private static final n v = new n(new long[]{932935682572204L, -5709635616022739520L, -2188049213076069766L, -2402647930690556071L, 4607902369394676606L}, new long[]{1755839754958344L, 3635922603701552614L, -8926246934734458166L, -4105165294016827317L, -1973733067087160919L});
    private static final n w = new n(new long[]{588163745094953L, 1874100631470248689L, -3356317119317648888L, 8801048690450065268L, 4346747891724989098L}, new long[]{1646176871698987L, 9200485277892910190L, 2911231712316318376L, -940446817885620290L, -8988996692778421600L});
    public static final DSTU4145ECParams DEFAULT_STD_8 = new DSTU4145ECParams(u, w, null);
    public static final DSTU4145ECParams DEFAULT_8 = new DSTU4145ECParams(u, v, null);
    private static final a x = new a(new int[]{367, 21, 0}, 1, new long[]{74751939855024L, -5213211438008838811L, 4919995037179144868L, -6464059461366265126L, -5117991803294025305L, -7542047803949100746L}, new int[]{16384, 0, 0, 0, 0, 0, 10235915, 1973680770, 1327645327, -762517375, 575008580, 77278537});
    private static final n y = new n(new long[]{48307928502557L, -8999195072944830792L, 7376691107974115073L, 2645404085393465202L, -1347969231203814252L, 1883317212583307067L}, new long[]{47082731665423L, 5119694571429024166L, -8922529422575393829L, 8760675007926925415L, -6946962281015851327L, 647631663117652990L});
    private static final n z = new n(new long[]{55295269000466L, -1113434015070628871L, 6996758144416119784L, 1891525752778692153L, -5332804131418497160L, -4662853762313635423L}, new long[]{1835452226372L, 8643989028859807687L, -470677127696930044L, 4200106612914177022L, 3783493128339407290L, 2235217143667571728L});
    public static final DSTU4145ECParams DEFAULT_STD_9 = new DSTU4145ECParams(x, z, null);
    public static final DSTU4145ECParams DEFAULT_9 = new DSTU4145ECParams(x, y, null);
    private static final a A = new a(new int[]{431, 5, 3, 1, 0}, 1, new long[]{4183571369834L, 8110915231595380007L, -4253282160175950401L, -465884162651410722L, -7540935875217304725L, 1778409218715044145L, 1718866981999921907L}, new int[]{16383, -1, -1, -1, -1, -1, -1, -4574859, 1166018984, -1062787856, 797026954, 533442432, -653493611, 285541583});
    private static final n B = new n(new long[]{20745903127946L, 8548332473486692657L, -8443372187705234668L, 4161218104511804899L, 1077648306179453912L, 2915753318692145326L, -8488678456152491673L}, new long[]{41925825616072L, 5472224357555516321L, -4291113112372200206L, -8372721531516316819L, -5015296172375921276L, -5627841541410185489L, 4821084490047359556L});
    private static final n C = new n(new long[]{29011337664897L, 3720373217683937934L, 271111015084948207L, 8284522725436709550L, 5314946769323469136L, 6342902427197841049L, -199491242609048195L}, new long[]{123926481027121L, -4470091190198944290L, 7418644050402387444L, -8240951855368488597L, -8279804519764625765L, 2207128465286149602L, 8230087390964755897L});
    public static final DSTU4145ECParams DEFAULT_STD_10 = new DSTU4145ECParams(A, C, null);
    public static final DSTU4145ECParams DEFAULT_10 = new DSTU4145ECParams(A, B, null);
    private static final a D = new a(173, 0, new long[]{4662154728217L, -847908143163680960L, -2168935003778287417L}, new long[]{2125065680640L, -6435965125594972850L, 1438798152247354546L}, new int[]{2048, 0, 0, 1612622, 1734372920, 633022513});
    private static final n E = new n(new long[]{804714930821L, -373706957287220676L, 349001696825350315L}, new long[]{25934776894350L, -8294631180604351902L, -3959631297186680211L});
    private static final n F = new n(new long[]{32052890577958L, 5179614777339868680L, 8733219244801960095L}, new long[]{3445126743377L, -3490450019702257136L, -5602320302800452921L});
    private static final n G = new n(new long[]{33509242504179L, 2697008415233315808L, 8552741745172790464L}, new long[]{25422165527938L, 3409455587612048693L, 2738538656602977303L});
    private static final n H = new n(new long[]{11250860650560L, -8524677370900834025L, -3788017345366201770L}, new long[]{387685150239L, 4612611597655149684L, -1073647191812158712L});
    public static final DSTU4145ECParams DEFAULT_STD_11 = new DSTU4145ECParams(D, G, H);
    public static final DSTU4145ECParams DEFAULT_11 = new DSTU4145ECParams(D, E, F);
    private static final a I = new a(179, 1, new long[]{194965511326618L, -4008006912470354462L, 9133726709019652283L}, new long[]{272791071937994L, -5300918948997347521L, -8514371675399123126L}, new int[]{262143, -1, -1, -4619882, 70647386, -1237174545});
    private static final n J = new n(new long[]{1249404621361137L, -1561751894980853952L, 549088104053494505L}, new long[]{143929457520698L, 6132096414049288573L, 3495083450099751507L});
    private static final n K = new n(new long[]{980443186154724L, -7169717839296404293L, -5509782622045514080L}, new long[]{1047866338056319L, -4184335209736990000L, -8007862088984343787L});
    private static final a L = new a(179, 1, new long[]{453680554825776L, -9109704910930000569L, -4021944904559965237L}, new long[]{1346497346613987L, 3247611880815747543L, 637760639757108960L}, new int[]{262143, -1, -1, -4619882, 70647386, -1237174545});
    private static final n M = new n(new long[]{2151601579228969L, -8267634314937738877L, -6134293612916872647L}, new long[]{801253024609098L, 5199792831360558949L, -123027592338801427L});
    private static final n N = new n(new long[]{315839314547728L, 5147994671223643076L, -6031764368577042759L}, new long[]{785459512133146L, -8781615669014326837L, 2769194912717482812L});
    public static final DSTU4145ECParams DEFAULT_STD_12 = new DSTU4145ECParams(L, M, N);
    public static final DSTU4145ECParams DEFAULT_12 = new DSTU4145ECParams(I, J, K);
    private static final a O = new a(191, 1, new long[]{703562434956978037L, 4181568864200136685L, -2942312864977678468L}, new long[]{6812936873063696629L, -5982784165646633813L, -5934897711998410581L}, new int[]{0x40000000, 0, 0, 1772583370, -1042629529, -1997060273});
    private static final n P = new n(new long[]{536849980781516782L, -821235531430889300L, 8359519367411935273L}, new long[]{7160601654226225192L, 6557464499276266343L, 7995552368692453866L});
    private static final n Q = new n(new long[]{2332226347509772096L, -6497968234348187218L, -8630953319167827160L}, new long[]{3168500988432211665L, 3154413269598351852L, 1249349618337288522L});
    private static final a R = new a(191, 1, new long[]{1407124869913956074L, 8363137728400273371L, -5884625729955356936L}, new long[]{4210306193157503695L, -1364921327913303534L, -835220795607798943L}, new int[]{0x40000000, 0, 0, 1772583370, -1042629529, -1997060273});
    private static final n S = new n(new long[]{2786426455214437072L, -8808024102873253400L, 5430348815391207127L}, new long[]{3368018561719442532L, -8565393709019577652L, 6692639060536475267L});
    private static final n T = new n(new long[]{8167806599874462892L, 5394823835879389519L, 3094635669991818707L}, new long[]{6333289593158639646L, -7564393531001995107L, 3599815920823969470L});
    public static final DSTU4145ECParams DEFAULT_STD_13 = new DSTU4145ECParams(R, S, T);
    public static final DSTU4145ECParams DEFAULT_13 = new DSTU4145ECParams(O, P, Q);
    private static final a U = new a(233, 1, new long[]{553935476010L, 8082964860140528832L, 1796555110089123059L, -6916437667101042034L}, new long[]{1805274951062L, -51108663090019652L, -6580205870198626530L, 8292391541916039334L}, new int[]{256, 0, 0, 0, 1304948, -416314775, 570629414, 63955159});
    private static final n V = new n(new long[]{1845349551561L, -4873621790389368865L, -2445982887412005491L, 8722632819544405998L}, new long[]{1877556379216L, -5004673593013693024L, 2523351668532648615L, -1815067000762096945L});
    private static final n W = new n(new long[]{920788345152L, -3939315374592451854L, -5054061844035656789L, -8740432805273515369L}, new long[]{1226881755623L, 6262833331791366741L, -7308369275359788321L, -4833780698932637717L});
    private static final n X = new n(new long[]{2171227369008L, 867269413550830913L, -3648297534105600521L, 5579328635887703380L}, new long[]{807971314437L, 4708376314533615345L, 7143934032251699495L, -940081227180834245L});
    private static final n Y = new n(new long[]{689379707599L, 477131825960081138L, 2130443647822944146L, -3028854452966026501L}, new long[]{1776742968051L, 2797644645241296191L, 7082512757083121569L, -4395248620806092155L});
    public static final DSTU4145ECParams DEFAULT_STD_14 = new DSTU4145ECParams(U, X, Y);
    public static final DSTU4145ECParams DEFAULT_14 = new DSTU4145ECParams(U, V, W);
    private static final a Z = new a(431, 1, new long[]{28008820784732L, -235283292243625747L, 978529442763381481L, 9100198833829690786L, 252207315350285149L, 7584550171307679631L, -3889975028237034633L}, new long[]{89888065617888L, 7823341052057364900L, 3580025197933209347L, 5415278312132476291L, -5368746264062219042L, -3286864284389718938L, 5962225172782082127L}, new int[]{16383, -1, -1, -1, -1, -1, -1, -4574859, 1166018984, -1062787856, 797026954, 533442432, -653493611, 285541583});
    private static final n aa = new n(new long[]{126241225303787L, -765524493543802367L, 6542714438852421330L, 8298002775257508768L, 662325208743273940L, 9046209792501870469L, 8867351730317476775L}, new long[]{35084365588092L, 2518808264870374516L, -3557027669384964740L, -1360846969600241672L, 8781867943771560120L, 3212110458701649551L, -794695485477842302L});
    private static final n ab = new n(new long[]{75345787905210L, 120111690891288549L, -2060541132141847866L, -1268161517300304991L, 7842645442550456945L, -5776446861450369194L, -180974457105968465L}, new long[]{96150130619998L, 6401231215411185250L, 4235400516519716712L, -753281849488054705L, -2835512234462169633L, 8068708148313121588L, -4243541827132738455L});
    private static final a ac = new a(431, 1, new long[]{92339564950592L, 8070634091209124781L, 2897932523621577209L, 4648007612381753062L, 6797044610431397638L, -4186079368562121445L, -3026547563556793703L}, new long[]{89325793467220L, 4962020573602612001L, 7861349346540921579L, 7002510885962937315L, 9085991639626645842L, -5825735570324950385L, -9130019144537846443L}, new int[]{16383, -1, -1, -1, -1, -1, -1, -4574859, 1166018984, -1062787856, 797026954, 533442432, -653493611, 285541583});
    private static final n ad = new n(new long[]{115309691980509L, 2004989287802568698L, 3146366219732454765L, 4207000138459032926L, -30031254386553457L, -251885446462662311L, -5947920941928823467L}, new long[]{65074835530028L, -6648368467238498956L, 6450847415975530958L, 7125303489850594614L, 2451792278945074984L, 1466653420045072030L, 8031815752603019152L});
    private static final n ae = new n(new long[]{35322216643799L, -4097126142065161537L, -3116101365131355811L, 5646537940858951147L, -5367936496650633075L, 4531713582432794067L, 652405920895786662L}, new long[]{27357715870350L, -1186100796574798505L, -4085706834707372542L, -7728170562911043440L, 4198244535946979549L, 9160727703370731930L, 308927514331360685L});
    public static final DSTU4145ECParams DEFAULT_STD_15 = new DSTU4145ECParams(ac, ad, ae);
    public static final DSTU4145ECParams DEFAULT_15 = new DSTU4145ECParams(Z, aa, ab);
    private a af;
    private n ag;
    private byte[] ah = null;
    private byte[] ai = null;
    private byte[] aj = null;
    private static Hashtable ak = new Hashtable();

    private static void a(a a2, DSTU4145ECParams dSTU4145ECParams) {
        Vector<DSTU4145ECParams> vector = (Vector<DSTU4145ECParams>)ak.get(a2);
        if (vector == null) {
            vector = new Vector<DSTU4145ECParams>();
            vector.addElement(dSTU4145ECParams);
            ak.put(a2, vector);
            return;
        }
        vector.addElement(dSTU4145ECParams);
    }

    private static DSTU4145ECParams a(DSTU4145ECParams dSTU4145ECParams) {
        Vector vector = (Vector)ak.get(dSTU4145ECParams.af);
        if (vector == null) {
            dSTU4145ECParams.e();
            DSTU4145ECParams.a(dSTU4145ECParams.af, dSTU4145ECParams);
            return dSTU4145ECParams;
        }
        for (int i2 = vector.size() - 1; i2 >= 0; --i2) {
            DSTU4145ECParams dSTU4145ECParams2 = (DSTU4145ECParams)vector.elementAt(i2);
            if (!dSTU4145ECParams.equals(dSTU4145ECParams2)) continue;
            return dSTU4145ECParams2;
        }
        dSTU4145ECParams.e();
        vector.addElement(dSTU4145ECParams);
        return dSTU4145ECParams;
    }

    private DSTU4145ECParams(a a2) {
        this.af = a2;
    }

    private void a(byte[] byArray, byte[] byArray2) {
        if (Utils.byteLength(byArray) > 8 * this.af.b) {
            throw new IllegalArgumentException("base point X-coordinate is not an element of GF(2^m)");
        }
        if (Utils.byteLength(byArray2) > 8 * this.af.b) {
            throw new IllegalArgumentException("base point Y-coordinate is not an element of GF(2^m)");
        }
        long[] lArray = LongIntUtils.fromByteArray(byArray, this.af.b);
        long[] lArray2 = LongIntUtils.fromByteArray(byArray2, this.af.b);
        if (LongIntUtils.bitLength(lArray) > this.af.a[0]) {
            throw new IllegalArgumentException("base point X-coordinate is not an element of GF(2^m)");
        }
        if (LongIntUtils.bitLength(lArray2) > this.af.a[0]) {
            throw new IllegalArgumentException("base point Y-coordinate is not an element of GF(2^m)");
        }
        if (this.isONB()) {
            GF2m gF2m = new GF2m(this.af.a);
            this.a(gF2m, lArray);
            this.a(gF2m, lArray2);
        }
        this.ag = new n(lArray, lArray2);
        this.ah = Utils.justifyArray(byArray, this.af.a[0] + 7 >>> 3);
        this.ai = Utils.justifyArray(byArray2, this.af.a[0] + 7 >>> 3);
    }

    private void a(byte[] object) {
        try {
            object = new DSTU4145ECPublicKey(this, (byte[])object);
            this.ag = ((DSTU4145ECPublicKey)object).a();
            this.ah = Utils.justifyArray(((DSTU4145ECPublicKey)object).getQx(), this.af.a[0] + 7 >>> 3);
            this.ai = Utils.justifyArray(((DSTU4145ECPublicKey)object).getQy(), this.af.a[0] + 7 >>> 3);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("compressed base point is not an element of GF(2^m)");
        }
    }

    public DSTU4145ECParams() {
    }

    private DSTU4145ECParams(a a2, n n2, n n3) {
        this.af = a2;
        this.ag = n2;
        if (n3 == null) {
            this.ah = LongIntUtils.toByteArray(n2.a(), a2.a[0] + 7 >>> 3);
            this.ai = LongIntUtils.toByteArray(n2.b(), a2.a[0] + 7 >>> 3);
            return;
        }
        this.ah = LongIntUtils.toByteArray(n3.a(), a2.a[0] + 7 >>> 3);
        this.ai = LongIntUtils.toByteArray(n3.b(), a2.a[0] + 7 >>> 3);
    }

    public static DSTU4145ECParams getParams(int[] object, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object v2 = ak.get(object = (Object)new a((int[])object, n2, byArray, byArray2));
        if (v2 == null) {
            ((a)object).a();
        }
        object = new DSTU4145ECParams((a)object);
        ((DSTU4145ECParams)object).a(byArray3, byArray4);
        return DSTU4145ECParams.a((DSTU4145ECParams)object);
    }

    public static DSTU4145ECParams getParams(int[] object, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Object v2 = ak.get(object = (Object)new a((int[])object, n2, byArray, byArray2));
        if (v2 == null) {
            ((a)object).a();
        }
        object = new DSTU4145ECParams((a)object);
        ((DSTU4145ECParams)object).a(byArray3);
        return DSTU4145ECParams.a((DSTU4145ECParams)object);
    }

    public static DSTU4145ECParams getParams(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        Object object = new a(n2, n3, byArray, byArray2);
        Object v2 = ak.get(object);
        if (v2 == null) {
            ((a)object).a();
        }
        object = new DSTU4145ECParams((a)object);
        ((DSTU4145ECParams)object).a(byArray3, byArray4);
        return DSTU4145ECParams.a((DSTU4145ECParams)object);
    }

    public static DSTU4145ECParams getParams(int n2, int n3, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        Object object = new a(n2, n3, byArray, byArray2);
        Object v2 = ak.get(object);
        if (v2 == null) {
            ((a)object).a();
        }
        object = new DSTU4145ECParams((a)object);
        ((DSTU4145ECParams)object).a(byArray3);
        return DSTU4145ECParams.a((DSTU4145ECParams)object);
    }

    public boolean isONB() {
        return this.af.i != null;
    }

    public int getM() {
        if (this.af.i == null) {
            throw new IllegalStateException("parameters given in polynomial basis");
        }
        return this.af.a[0];
    }

    public int[] getF() {
        if (this.af.i != null) {
            throw new IllegalStateException("parameters given in optimal normal basis");
        }
        return Utils.copy(this.af.a);
    }

    public int getA() {
        return this.af.c;
    }

    public byte[] getB() {
        int n2 = this.af.a[0] + 7 >>> 3;
        return Utils.justifyArray(this.af.d, n2);
    }

    public byte[] getN() {
        int n2 = this.af.a[0] + 7 >>> 3;
        return Utils.toByteArray(this.af.e, n2);
    }

    public byte[] getPx() {
        int n2 = this.af.a[0] + 7 >>> 3;
        return Utils.justifyArray(this.ah, n2);
    }

    public byte[] getPy() {
        int n2 = this.af.a[0] + 7 >>> 3;
        return Utils.justifyArray(this.ai, n2);
    }

    public byte[] getPc() {
        DSTU4145ECParams dSTU4145ECParams = this;
        synchronized (dSTU4145ECParams) {
            if (this.aj == null) {
                DSTU4145ECPublicKey dSTU4145ECPublicKey = new DSTU4145ECPublicKey(this, this.ah, this.ai);
                this.aj = dSTU4145ECPublicKey.getQc();
            }
        }
        int n2 = this.af.a[0] + 7 >>> 3;
        return Utils.justifyArray(this.aj, n2);
    }

    public int getSignatureLength() {
        return BigInt.bitLength(this.af.e) + 7 >>> 3 << 1;
    }

    public synchronized void setOptLevel(int n2) {
        int n3 = Utils.getWidthByOptLevel(n2);
        if (n3 != 0) {
            p p2 = new p(this);
            n[] nArray = p2.a(this.ag, Utils.getWidthByOptLevel(n2));
            this.ag.a(nArray);
            return;
        }
        this.ag.a(null);
    }

    public synchronized void setOptData(byte[] objectArray) {
        if (objectArray != null) {
            p p2 = new p(this);
            if (!this.ag.equals((objectArray = (Object[])p2.a((byte[])objectArray))[1])) {
                throw new IllegalArgumentException("precomputations are not for current base point");
            }
            this.ag.a((n[])objectArray);
            return;
        }
        this.ag.a(null);
    }

    public synchronized byte[] getOptData() {
        n[] nArray = this.ag.d();
        if (nArray != null) {
            p p2 = new p(this);
            return p2.a(nArray);
        }
        return null;
    }

    final int[] a() {
        return this.af.a;
    }

    final long[] b() {
        return this.af.f;
    }

    final int[] c() {
        return this.af.e;
    }

    final n d() {
        return this.ag;
    }

    public int[] getCofactor() {
        int n2 = this.af.b << 1;
        BigInt bigInt = new BigInt(n2);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[2 * n2];
        BigInt.shiftLeft(bigInt.getOne(), this.af.a[0], nArray2);
        bigInt.squareRoot(nArray2, nArray);
        int n3 = bigInt.add(nArray, nArray, nArray);
        n3 += bigInt.add(nArray, bigInt.getOne(), nArray);
        System.arraycopy(nArray, 0, nArray3, n2, n2);
        nArray3[n2 - 1] = n3 += bigInt.add(nArray, nArray2, nArray);
        bigInt.divide(nArray3, this.af.e, nArray3, null);
        System.arraycopy(nArray3, n2, nArray, 0, n2);
        return nArray;
    }

    private void e() {
        n n2 = new n(this.ah, this.ai, this.af.b);
        Object object = n2.a();
        long[] lArray = n2.b();
        int[] nArray = this.af.e;
        int n3 = this.af.a[0];
        p p2 = new p(this);
        if (LongIntUtils.bitLength((long[])object) > n3) {
            throw new IllegalArgumentException("base point X-coordinate is not an element of GF(2^m)");
        }
        if (LongIntUtils.bitLength(lArray) > n3) {
            throw new IllegalArgumentException("base point Y-coordinate is not an element of GF(2^m)");
        }
        if (this.isONB()) {
            this.a(p2.a(), (long[])object);
            this.a(p2.a(), lArray);
        }
        if (!p2.a(this.ag)) {
            throw new IllegalArgumentException("base point doesn't belong to the elliptic curve");
        }
        object = new n(p2.a().getZero(), p2.a().getZero());
        p2.a(n2, nArray, (n)object);
        if (!((n)object).equals(p2.c())) {
            throw new IllegalArgumentException("base point order is not equals n");
        }
    }

    static boolean a(GF2m gF2m, int[] object) {
        Object[] objectArray = new long[object[0] + 63 >>> 6];
        for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
            int n2 = objectArray.length - 1 - (object[i2] >>> 6);
            objectArray[n2] = objectArray[n2] | 1L << (object[i2] & 0x3F);
        }
        BigInt bigInt = gF2m.getBigInt();
        int n3 = gF2m.getN();
        long[] lArray = new long[n3];
        long[] lArray2 = new long[n3];
        int[] nArray = new int[2 * n3];
        Object[] objectArray2 = lArray;
        lArray[objectArray2.length - 1] = 2L;
        long[] lArray3 = new long[bigInt.getTwo().length / 2];
        long[] lArray4 = new long[bigInt.getOne().length / 2];
        lArray3[lArray3.length - 1] = 2L;
        lArray4[lArray4.length - 1] = 1L;
        long[] lArray5 = lArray2;
        for (int i3 = 1; i3 < object[0] / 2; ++i3) {
            gF2m.square((long[])objectArray2, (long[])objectArray2);
            GF2m.add(objectArray2, lArray3, lArray5);
            gF2m.gcd((long[])objectArray, lArray5, lArray5, null, null);
            if (LongIntUtils.equals(lArray5, lArray4)) continue;
            return false;
        }
        LongIntUtils.shiftLeft(lArray4, (int)object[0], lArray);
        LongIntUtils.toIntArray(lArray, nArray);
        bigInt.subtract(nArray, bigInt.getOne(), nArray);
        int[] nArray2 = new int[4 * n3];
        Utils.copy(nArray, nArray2);
        int[][] nArray3 = com.bifit.security.core.i.a((int)object[0]);
        if (nArray3 == null) {
            throw new IllegalArgumentException("field order is not acceptable");
        }
        objectArray = new int[4 * n3];
        int[][] nArray4 = nArray3;
        n3 = nArray3.length;
        for (int i4 = 0; i4 < n3; ++i4) {
            int[] nArray5 = nArray4[i4];
            objectArray2 = nArray5;
            Utils.copy(nArray5, nArray);
            bigInt.divide(nArray2, nArray, (int[])objectArray, null);
            objectArray2 = lArray2;
            LongIntUtils.copy(lArray4, objectArray2);
            for (int i5 = BigInt.bitLength((int[])objectArray) - 1; i5 >= 0; --i5) {
                gF2m.square((long[])objectArray2, (long[])objectArray2);
                if (BigInt.getBit((int[])objectArray, i5) != 1) continue;
                gF2m.multiply((long[])objectArray2, lArray3, (long[])objectArray2);
            }
            if (!LongIntUtils.equals(objectArray2, lArray4)) continue;
            return false;
        }
        return true;
    }

    static boolean a(BigInt bigInt, int[] nArray, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        int[] nArray4 = new int[2 * n3];
        Utils.copy(bigInt.getOne(), nArray2);
        BigInt.shiftLeft(bigInt.getOne(), n2, nArray3);
        Utils.copy(nArray3, nArray4);
        bigInt.divide(nArray4, nArray, null, nArray3);
        for (n2 = 1; n2 < 32; ++n2) {
            bigInt.multiply(nArray2, nArray3, nArray4);
            bigInt.divide(nArray4, nArray, null, nArray2);
            if (!BigInt.equals(nArray2, bigInt.getOne())) continue;
            return false;
        }
        return true;
    }

    static long[] a(long[] lArray) {
        int n2 = (LongIntUtils.bitLength(lArray) + 8) / 9;
        long[] lArray2 = new long[n2];
        int n3 = 0;
        int n4 = lArray.length;
        while (--n4 >= 0) {
            while (n3 < 56 && --n2 >= 0) {
                lArray2[n2] = lArray[n4] >> n3 & 0x1FFL;
                n3 += 9;
            }
            if (--n2 < 0) continue;
            if (n3 != 64) {
                lArray2[n2] = lArray[n4] >>> n3 & 0x1FFL;
            }
            n3 -= 55;
            if (n4 <= 0) continue;
            int n5 = n2;
            lArray2[n5] = lArray2[n5] | lArray[n4 - 1] << 9 - n3 & 0x1FFL;
        }
        return lArray2;
    }

    final void a(GF2m gF2m, long[] lArray) {
        this.af.a(gF2m, lArray);
    }

    final void b(GF2m gF2m, long[] lArray) {
        this.af.b(gF2m, lArray);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DSTU4145ECParams)) {
            return false;
        }
        object = (DSTU4145ECParams)object;
        if (!((DSTU4145ECParams)object).af.equals(this.af)) {
            return false;
        }
        if (!BigInt.equals(this.ah, ((DSTU4145ECParams)object).ah)) {
            return false;
        }
        return BigInt.equals(this.ai, ((DSTU4145ECParams)object).ai);
    }

    public int hashCode() {
        return 31 * this.af.hashCode() + this.ag.hashCode();
    }

    static {
        DSTU4145ECParams.a(a, DEFAULT_1);
        DSTU4145ECParams.a(d, DEFAULT_2);
        DSTU4145ECParams.a(g, DEFAULT_3);
        DSTU4145ECParams.a(j, DEFAULT_4);
        DSTU4145ECParams.a(m, DEFAULT_5);
        DSTU4145ECParams.a(o, DEFAULT_6);
        DSTU4145ECParams.a(r, DEFAULT_7);
        DSTU4145ECParams.a(u, DEFAULT_8);
        DSTU4145ECParams.a(x, DEFAULT_9);
        DSTU4145ECParams.a(A, DEFAULT_10);
        DSTU4145ECParams.a(D, DEFAULT_11);
        DSTU4145ECParams.a(I, DEFAULT_12);
        DSTU4145ECParams.a(O, DEFAULT_13);
        DSTU4145ECParams.a(U, DEFAULT_14);
        DSTU4145ECParams.a(Z, DEFAULT_15);
        DSTU4145ECParams.a(a, DEFAULT_STD_1);
        DSTU4145ECParams.a(d, DEFAULT_STD_2);
        DSTU4145ECParams.a(g, DEFAULT_STD_3);
        DSTU4145ECParams.a(j, DEFAULT_STD_4);
        DSTU4145ECParams.a(m, DEFAULT_STD_5);
        DSTU4145ECParams.a(o, DEFAULT_STD_6);
        DSTU4145ECParams.a(r, DEFAULT_STD_7);
        DSTU4145ECParams.a(u, DEFAULT_STD_8);
        DSTU4145ECParams.a(x, DEFAULT_STD_9);
        DSTU4145ECParams.a(A, DEFAULT_STD_10);
        DSTU4145ECParams.a(D, DEFAULT_STD_11);
        DSTU4145ECParams.a(L, DEFAULT_STD_12);
        DSTU4145ECParams.a(R, DEFAULT_STD_13);
        DSTU4145ECParams.a(U, DEFAULT_STD_14);
        DSTU4145ECParams.a(ac, DEFAULT_STD_15);
    }

    static final class a {
        private int[] a;
        private int b;
        private int c;
        private byte[] d;
        private int[] e;
        private long[] f;
        private long[] g = null;
        private long[] h = null;
        private long[] i = null;
        private long[][] j = null;
        private long[][] k = null;

        public a() {
        }

        public a(int n2, int n3, byte[] byArray, byte[] byArray2) {
            this.b = n2 + 63 >>> 6;
            if (Utils.byteLength(byArray) > 8 * this.b) {
                throw new IllegalArgumentException("parameter b is not an element of GF(2^m)");
            }
            if (Utils.byteLength(byArray2) > 8 * this.b) {
                throw new IllegalArgumentException("bit length EC order must not be greater than GF order");
            }
            this.c = n3;
            this.d = Utils.justifyArray(byArray, n2 + 7 >>> 3);
            this.e = Utils.fromByteArray(byArray2, 2 * this.b);
            long[][] lArray = com.bifit.security.core.j.a(n2);
            if (lArray == null) {
                throw new IllegalArgumentException("field order is not acceptable");
            }
            this.i = DSTU4145ECParams.a(lArray[0]);
            this.a = new int[lArray[1].length];
            for (n3 = 0; n3 < lArray[1].length; ++n3) {
                this.a[n3] = (int)lArray[1][n3];
            }
            this.g = lArray[2];
            this.h = lArray[3];
            GF2m gF2m = new GF2m(this.a);
            this.f = LongIntUtils.fromByteArray(this.d, this.b);
            this.a(gF2m, this.f);
        }

        public a(int[] nArray, int n2, byte[] byArray, byte[] byArray2) {
            this.b = nArray[0] + 63 >>> 6;
            if (Utils.byteLength(byArray) > 8 * this.b) {
                throw new IllegalArgumentException("parameter b is not an element of GF(2^m)");
            }
            if (Utils.byteLength(byArray2) > 8 * this.b) {
                throw new IllegalArgumentException("bit length EC order must not be greater than GF order");
            }
            this.a = Utils.copy(nArray);
            this.c = n2;
            this.d = Utils.justifyArray(byArray, nArray[0] + 7 >>> 3);
            this.f = LongIntUtils.fromByteArray(this.d, this.b);
            this.e = Utils.fromByteArray(byArray2, 2 * this.b);
        }

        public a(int n2, int n3, long[] lArray, long[] lArray2, int[] nArray) {
            this.b = n2 + 63 >>> 6;
            this.c = n3;
            this.d = LongIntUtils.toByteArray(lArray, n2 + 7 >>> 3);
            this.e = nArray;
            this.f = lArray2;
            long[][] lArray3 = com.bifit.security.core.j.a(n2);
            this.i = DSTU4145ECParams.a(lArray3[0]);
            this.a = new int[lArray3[1].length];
            for (n3 = 0; n3 < lArray3[1].length; ++n3) {
                this.a[n3] = (int)lArray3[1][n3];
            }
            this.g = lArray3[2];
            this.h = lArray3[3];
        }

        public a(int[] nArray, int n2, long[] lArray, int[] nArray2) {
            this.b = nArray[0] + 63 >>> 6;
            this.a = nArray;
            this.c = n2;
            this.f = lArray;
            this.e = nArray2;
            this.d = LongIntUtils.toByteArray(lArray, this.a[0] + 7 >>> 3);
        }

        final void a() {
            Object[] objectArray = this.f;
            int n2 = this.a[0];
            GF2m gF2m = new GF2m(this.a);
            BigInt bigInt = gF2m.getBigInt();
            if (this.i == null) {
                for (int i2 = 1; i2 < this.a.length; ++i2) {
                    if (this.a[i2 - 1] > this.a[i2]) continue;
                    throw new IllegalArgumentException("representation of field polynomial is incorrect");
                }
                if (this.a.length != 3 && this.a.length != 5) {
                    throw new IllegalArgumentException("field polynomial must be trinomial or pentanomial");
                }
                if (!DSTU4145ECParams.a(gF2m, this.a)) {
                    throw new IllegalArgumentException("field polynomial is not primitive");
                }
            }
            if (this.c != 0 && this.c != 1) {
                throw new IllegalArgumentException("parameter a must be 0 or 1");
            }
            if (LongIntUtils.bitLength(objectArray) > n2) {
                throw new IllegalArgumentException("parameter b is not an element of GF(2^m)");
            }
            if (LongIntUtils.bitLength(objectArray) == 0) {
                throw new IllegalArgumentException("parameter b is zero");
            }
            if (this.e.length == 1 && this.e[0] <= 2) {
                throw new IllegalArgumentException("parameter n must be greater than 2");
            }
            if (!BigInt.isPrime(this.e)) {
                throw new IllegalArgumentException("base point order must be prime");
            }
            if (BigInt.bitLength(this.e) > n2) {
                throw new IllegalArgumentException("bit length EC order must not be greater than GF order");
            }
            if (!DSTU4145ECParams.a(bigInt, this.e, this.a[0])) {
                throw new IllegalArgumentException("Menezes-Okamoto-Vanstoune condition is not met");
            }
            int[] nArray = new int[this.b << 1];
            objectArray = new int[this.b << 1];
            BigInt.shiftLeft(bigInt.getOne(), 160, nArray);
            BigInt.shiftLeft(bigInt.getOne(), this.a[0], (int[])objectArray);
            bigInt.squareRoot((int[])objectArray, (int[])objectArray);
            n2 = bigInt.add((int[])objectArray, bigInt.getOne(), (int[])objectArray);
            n2 = 2 * n2 + bigInt.add((int[])objectArray, (int[])objectArray, (int[])objectArray);
            n2 = 2 * n2 + bigInt.add((int[])objectArray, (int[])objectArray, (int[])objectArray);
            if (n2 > 0 || BigInt.compare(this.e, nArray) < 0 || BigInt.compare(this.e, (int[])objectArray) < 0) {
                throw new IllegalArgumentException("condition n >= max(2^160, sqrt(2^(m + 4)) + 4) is not met");
            }
        }

        final void a(GF2m gF2m, long[] lArray) {
            int n2;
            int n3 = gF2m.getF()[0];
            int n4 = gF2m.getN();
            Object object = this;
            synchronized (object) {
                if (this.k == null) {
                    this.k = new long[n3][];
                    this.k[0] = this.g;
                    for (n2 = 1; n2 < n3; ++n2) {
                        this.k[n2] = new long[n4];
                        gF2m.square(this.k[n2 - 1], this.k[n2]);
                    }
                }
            }
            object = new long[n4];
            --n4;
            n2 = 0;
            int n5 = n3 - 1;
            while (n2 < n3) {
                long l2 = lArray[n4 - (n5 >>> 6)] >>> n5 & 1L;
                long[] lArray2 = this.k[n2];
                for (int i2 = 0; i2 < n3; ++i2) {
                    Object object2 = object;
                    int n6 = n4 - (i2 >>> 6);
                    object2[n6] = object2[n6] ^ (l2 & lArray2[n4 - (i2 >>> 6)] >>> i2) << i2;
                }
                ++n2;
                --n5;
            }
            LongIntUtils.copy((long[])object, lArray);
            Utils.clean((long[])object);
        }

        final void b(GF2m gF2m, long[] lArray) {
            int n2 = gF2m.getF()[0];
            int n3 = gF2m.getN();
            Object object = this;
            synchronized (object) {
                if (this.j == null) {
                    int n4;
                    long[] lArray2 = this.h;
                    this.j = new long[n2][];
                    this.j[0] = new long[n3];
                    for (n4 = 0; n4 < n3; ++n4) {
                        this.j[0][n4] = -1L;
                    }
                    LongIntUtils.truncate(this.j[0], n2);
                    for (n4 = 1; n4 < n2; ++n4) {
                        this.j[n4] = new long[n3];
                        long[] lArray3 = this.j[n4];
                        long[] lArray4 = lArray2;
                        long[] lArray5 = this.j[n4 - 1];
                        a a2 = this;
                        int n5 = a2.a[0];
                        int n6 = n5 + 63 >> 6;
                        long[] lArray6 = new long[n6];
                        long[] lArray7 = new long[n6];
                        LongIntUtils.copy(lArray5, lArray6);
                        LongIntUtils.copy(lArray4, lArray7);
                        for (int i2 = 0; i2 < n5; ++i2) {
                            int n7 = 0;
                            for (int i3 = 0; i3 < n5 - 1; ++i3) {
                                n7 ^= (LongIntUtils.getBit(lArray7, (int)(a2.i[2 * i3] + (long)i2 + 1L) % n5) ^ LongIntUtils.getBit(lArray7, (int)(a2.i[2 * i3 + 1] + (long)i2 + 1L) % n5)) & LongIntUtils.getBit(lArray6, (i3 + i2 + 1) % n5);
                            }
                            int n8 = n6 - 1 - (i2 >>> 6);
                            lArray3[n8] = lArray3[n8] ^ (long)(n7 ^= LongIntUtils.getBit(lArray7, (int)(a2.i[2 * n5 - 2] + (long)i2 + 1L) % n5) & LongIntUtils.getBit(lArray6, (n5 - 1 + i2 + 1) % n5)) << i2;
                        }
                    }
                }
            }
            object = new long[n3];
            --n3;
            for (int i4 = 0; i4 < n2; ++i4) {
                long[] lArray8 = this.j[i4];
                long l2 = lArray[n3 - (i4 >>> 6)] >>> i4 & 1L;
                int n9 = 0;
                int n10 = n2 - 1;
                while (n9 < n2) {
                    Object object2 = object;
                    int n11 = n3 - (n9 >>> 6);
                    object2[n11] = object2[n11] ^ (l2 & lArray8[n3 - (n10 >>> 6)] >>> n10) << n9;
                    ++n9;
                    --n10;
                }
            }
            LongIntUtils.copy((long[])object, lArray);
            Utils.clean((long[])object);
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof a)) {
                return false;
            }
            object = (a)object;
            if (this.c != ((a)object).c) {
                return false;
            }
            if (!BigInt.equals(this.a, ((a)object).a)) {
                return false;
            }
            if (!BigInt.equals(this.d, ((a)object).d)) {
                return false;
            }
            return BigInt.equals(this.e, ((a)object).e);
        }

        public final int hashCode() {
            return BigInt.hashCode(this.e);
        }
    }
}

