/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.Utils;
import com.bifit.security.core.l;
import com.bifit.security.core.m;
import com.bifit.security.core.o;
import java.util.Hashtable;

public final class ECDSAParams
extends l {
    private static final l a = new l(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{100, 33, 5, 25, -27, -100, -128, -25, 15, -89, -23, -85, 114, 36, 48, 73, -2, -72, -34, -20, -63, 70, -71, -79}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -103, -34, -8, 54, 20, 107, -55, -79, -76, -46, 40, 49}, 6);
    private static final m b = new m(new byte[]{24, -115, -88, 14, -80, 48, -112, -10, 124, -65, 32, -21, 67, -95, -120, 0, -12, -1, 10, -3, -126, -1, 16, 18}, new byte[]{7, 25, 43, -107, -1, -56, -38, 120, 99, 16, 17, -19, 107, 36, -51, -43, 115, -7, 119, -95, 30, 121, 72, 17}, 6);
    public static final ECDSAParams DEFAULT_P192 = new ECDSAParams(a, b);
    private static final l c = new l(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2}, new byte[]{-76, 5, 10, -123, 12, 4, -77, -85, -11, 65, 50, 86, 80, 68, -80, -73, -41, -65, -40, -70, 39, 11, 57, 67, 35, 85, -1, -76}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -94, -32, -72, -16, 62, 19, -35, 41, 69, 92, 92, 42, 61}, 7);
    private static final m d = new m(new byte[]{-73, 14, 12, -67, 107, -76, -65, 127, 50, 19, -112, -71, 74, 3, -63, -45, 86, -62, 17, 34, 52, 50, -128, -42, 17, 92, 29, 33}, new byte[]{-67, 55, 99, -120, -75, -9, 35, -5, 76, 34, -33, -26, -51, 67, 117, -96, 90, 7, 71, 100, 68, -43, -127, -103, -123, 0, 126, 52}, 7);
    public static final ECDSAParams DEFAULT_P224 = new ECDSAParams(c, d);
    private static final l e = new l(new byte[]{-1, -1, -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{90, -58, 53, -40, -86, 58, -109, -25, -77, -21, -67, 85, 118, -104, -122, -68, 101, 29, 6, -80, -52, 83, -80, -10, 59, -50, 60, 62, 39, -46, 96, 75}, new byte[]{-1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -68, -26, -6, -83, -89, 23, -98, -124, -13, -71, -54, -62, -4, 99, 37, 81}, 8);
    private static final m f = new m(new byte[]{107, 23, -47, -14, -31, 44, 66, 71, -8, -68, -26, -27, 99, -92, 64, -14, 119, 3, 125, -127, 45, -21, 51, -96, -12, -95, 57, 69, -40, -104, -62, -106}, new byte[]{79, -29, 66, -30, -2, 26, 127, -101, -114, -25, -21, 74, 124, 15, -98, 22, 43, -50, 51, 87, 107, 49, 94, -50, -53, -74, 64, 104, 55, -65, 81, -11}, 8);
    public static final ECDSAParams DEFAULT_P256 = new ECDSAParams(e, f);
    private static final l g = new l(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -4}, new byte[]{-77, 49, 47, -89, -30, 62, -25, -28, -104, -114, 5, 107, -29, -8, 45, 25, 24, 29, -100, 110, -2, -127, 65, 18, 3, 20, 8, -113, 80, 19, -121, 90, -58, 86, 57, -115, -118, 46, -47, -99, 42, -123, -56, -19, -45, -20, 42, -17}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -57, 99, 77, -127, -12, 55, 45, -33, 88, 26, 13, -78, 72, -80, -89, 122, -20, -20, 25, 106, -52, -59, 41, 115}, 12);
    private static final m h = new m(new byte[]{-86, -121, -54, 34, -66, -117, 5, 55, -114, -79, -57, 30, -13, 32, -83, 116, 110, 29, 59, 98, -117, -89, -101, -104, 89, -9, 65, -32, -126, 84, 42, 56, 85, 2, -14, 93, -65, 85, 41, 108, 58, 84, 94, 56, 114, 118, 10, -73}, new byte[]{54, 23, -34, 74, -106, 38, 44, 111, 93, -98, -104, -65, -110, -110, -36, 41, -8, -12, 29, -67, 40, -102, 20, 124, -23, -38, 49, 19, -75, -16, -72, -64, 10, 96, -79, -50, 29, 126, -127, -99, 122, 67, 29, 124, -112, -22, 14, 95}, 12);
    public static final ECDSAParams DEFAULT_P384 = new ECDSAParams(g, h);
    private static final l i = new l(new byte[]{1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{0, 81, -107, 62, -71, 97, -114, 28, -102, 31, -110, -102, 33, -96, -74, -123, 64, -18, -94, -38, 114, 91, -103, -77, 21, -13, -72, -76, -119, -111, -114, -15, 9, -31, 86, 25, 57, 81, -20, 126, -109, 123, 22, 82, -64, -67, 59, -79, -65, 7, 53, 115, -33, -120, 61, 44, 52, -15, -17, 69, 31, -44, 107, 80, 63, 0}, new byte[]{1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -6, 81, -122, -121, -125, -65, 47, -106, 107, 127, -52, 1, 72, -9, 9, -91, -48, 59, -75, -55, -72, -119, -100, 71, -82, -69, 111, -73, 30, -111, 56, 100, 9}, 17);
    private static final m j = new m(new byte[]{0, -58, -123, -114, 6, -73, 4, 4, -23, -51, -98, 62, -53, 102, 35, -107, -76, 66, -100, 100, -127, 57, 5, 63, -75, 33, -8, 40, -81, 96, 107, 77, 61, -70, -95, 75, 94, 119, -17, -25, 89, 40, -2, 29, -63, 39, -94, -1, -88, -34, 51, 72, -77, -63, -123, 106, 66, -101, -7, 126, 126, 49, -62, -27, -67, 102}, new byte[]{1, 24, 57, 41, 106, 120, -102, 59, -64, 4, 92, -118, 95, -76, 44, 125, 27, -39, -104, -11, 68, 73, 87, -101, 68, 104, 23, -81, -67, 23, 39, 62, 102, 44, -105, -18, 114, -103, 94, -12, 38, 64, -59, 80, -71, 1, 63, -83, 7, 97, 53, 60, 112, -122, -94, 114, -62, 64, -120, -66, -108, 118, -97, -47, 102, 80}, 17);
    public static final ECDSAParams DEFAULT_P521 = new ECDSAParams(i, j);
    private static Hashtable k = new Hashtable<String, ECDSAParams>();
    private final m l;

    public static ECDSAParams getParams(int n2) {
        switch (n2) {
            case 192: {
                return DEFAULT_P192;
            }
            case 224: {
                return DEFAULT_P224;
            }
            case 256: {
                return DEFAULT_P256;
            }
            case 384: {
                return DEFAULT_P384;
            }
            case 521: {
                return DEFAULT_P521;
            }
        }
        throw new IllegalArgumentException("size must be from 192, 224, 256, 384, 521");
    }

    private ECDSAParams(l l2, m m2) {
        super(l2);
        this.l = m2;
    }

    public static ECDSAParams getParams(byte[] object, byte[] object2, byte[] object3, byte[] object4, byte[] objectArray, byte[] objectArray2, int n2) {
        if (Utils.byteLength(object) < 21) {
            throw new IllegalArgumentException("p must be 21 byte long");
        }
        if (Utils.byteLength((byte[])object4) < 21) {
            throw new IllegalArgumentException("n must be 21 byte long");
        }
        object = new l((byte[])object, (byte[])object2, (byte[])object3, (byte[])object4, n2);
        object2 = new m((byte[])objectArray, (byte[])objectArray2, n2);
        ECDSAParams eCDSAParams = new ECDSAParams((l)object, (m)object2);
        object = eCDSAParams;
        object2 = eCDSAParams;
        object3 = eCDSAParams.b();
        object4 = ((l)object2).c();
        objectArray = ((l)object2).d();
        objectArray2 = ((l)object2).e();
        if (!BigInt.isPrime((int[])object3)) {
            throw new IllegalArgumentException("parameter p is composite");
        }
        if (BigInt.bitLength((int[])object4) == 0 || BigInt.compare((int[])object4, (int[])object3) >= 0) {
            throw new IllegalArgumentException("condition 0 < a < p is not met");
        }
        if (BigInt.bitLength(objectArray) == 0 || BigInt.compare(objectArray, (int[])object3) >= 0) {
            throw new IllegalArgumentException("condition 0 < b < p is not met");
        }
        if (!BigInt.isPrime(objectArray2)) {
            throw new IllegalArgumentException("parameter n is not prime");
        }
        object2 = object;
        object3 = new o((ECDSAParams)object2);
        object4 = ((l)object2).b();
        objectArray = ((l)object2).e();
        objectArray2 = ((ECDSAParams)object2).l.a();
        int[] nArray = ((ECDSAParams)object2).l.b();
        if (BigInt.compare(objectArray2, (int[])object4) >= 0) {
            throw new IllegalArgumentException("base point X-coordinate doesn't meet condition 0 <= Px < p");
        }
        if (BigInt.bitLength(nArray) == 0 || BigInt.compare(nArray, (int[])object4) >= 0) {
            throw new IllegalArgumentException("base point Y-coordinate doesn't meet condition 0 < Py < p");
        }
        if (!((o)object3).a(((ECDSAParams)object2).l)) {
            throw new IllegalArgumentException("base point is not on the elliptic curve");
        }
        object4 = new m(((o)object3).b().getZero(), ((o)object3).b().getZero());
        ((o)object3).a(((ECDSAParams)object2).l, (int[])objectArray, (m)object4);
        if (!((m)object4).equals(((o)object3).a())) {
            throw new IllegalArgumentException("base point order doesn't equal q");
        }
        return object;
    }

    public final byte[] getGx() {
        return Utils.toByteArray(this.l.a(), Utils.wordLength(this.l.a()) << 2);
    }

    public final byte[] getGy() {
        return Utils.toByteArray(this.l.b(), Utils.wordLength(this.l.b()) << 2);
    }

    public final int getSignatureLength() {
        return BigInt.bitLength(this.b()) + 7 >>> 3 << 1;
    }

    final m a() {
        return this.l;
    }

    public final synchronized void setOptLevel(int n2) {
        int n3 = Utils.getWidthByOptLevel(n2);
        if (n3 != 0) {
            o o2 = new o(this);
            m[] mArray = o2.a(this.l, Utils.getWidthByOptLevel(n2));
            this.l.a(mArray);
            return;
        }
        this.l.a(null);
    }

    public final synchronized void setOptData(byte[] objectArray) {
        if (objectArray != null) {
            o o2 = new o(this);
            objectArray = o2.a((byte[])objectArray);
            m m2 = new m(objectArray[1].a(), objectArray[1].b());
            o2.b().fromInternalDomain(m2.a(), m2.a());
            o2.b().fromInternalDomain(m2.b(), m2.b());
            if (!this.l.equals(m2)) {
                throw new IllegalArgumentException("precomputations are not for current base point");
            }
            this.l.a((m[])objectArray);
            return;
        }
        this.l.a(null);
    }

    public final synchronized byte[] getOptData() {
        m[] mArray = this.l.d();
        if (mArray != null) {
            o o2 = new o(this);
            return o2.a(mArray);
        }
        return null;
    }

    public final synchronized byte[] getOptData(int n2) {
        m[] mArray = this.l.d();
        if (mArray != null) {
            o o2 = new o(this);
            mArray = o2.a(mArray, GFp.a(this.b(), n2));
            return o2.a(mArray);
        }
        return null;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECDSAParams)) {
            return false;
        }
        if (!super.equals(object = (ECDSAParams)object)) {
            return false;
        }
        return ((ECDSAParams)object).l.equals(this.l);
    }

    @Override
    public final int hashCode() {
        return 31 * super.hashCode() + this.l.hashCode();
    }

    static {
        k.put("P-192", DEFAULT_P192);
        k.put("P-224", DEFAULT_P224);
        k.put("P-256", DEFAULT_P256);
        k.put("P-384", DEFAULT_P384);
        k.put("P-521", DEFAULT_P521);
    }
}

