/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.Digest;
import com.bifit.security.core.DigestEngine;
import com.bifit.security.core.ECDSAParams;
import com.bifit.security.core.ECDSAPrivateKey;
import com.bifit.security.core.ECDSAPublicKey;
import com.bifit.security.core.GFp;
import com.bifit.security.core.Sign;
import com.bifit.security.core.Utils;
import com.bifit.security.core.m;
import com.bifit.security.core.o;
import java.security.SecureRandom;
import java.util.Random;

public class ECDSASign
implements Sign {
    public static final int SHA1 = 0;
    public static final int SHA224 = 1;
    public static final int SHA256 = 2;
    public static final int SHA384 = 3;
    public static final int SHA512 = 4;
    private final Digest a;
    private ECDSAPrivateKey b = null;
    private ECDSAPublicKey c = null;
    private ECDSAParams d;
    private o e;
    private GFp f;
    private BigInt g;
    private m h;
    private int[] i;
    private byte[] j;
    private byte[] k;
    private int[] l;
    private int[] m;
    private int[] n;
    private int[] o;
    private int[] p;
    private int[] q;
    private SecureRandom r;

    public ECDSASign() {
        this(0);
    }

    public ECDSASign(int n2) {
        if (n2 < 0 && n2 > 4) {
            throw new IllegalArgumentException("invalid type digest");
        }
        this.a = new DigestEngine(n2);
    }

    public void initSign(ECDSAPrivateKey eCDSAPrivateKey, SecureRandom secureRandom) {
        this.b = eCDSAPrivateKey;
        this.d = eCDSAPrivateKey.getParams();
        this.r = secureRandom;
        this.a.init();
        this.a();
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    @Override
    public byte[] sign(byte[] byArray) {
        this.update(byArray, 0, byArray.length);
        return this.sign();
    }

    private void a() {
        this.a.init();
        this.e = new o(this.d);
        this.f = new GFp(this.d.e());
        this.g = this.f.getBigInt();
        int n2 = this.d.getSignatureLength() / 2;
        int n3 = this.d.f();
        this.j = new byte[n2];
        this.k = new byte[n2];
        this.i = new int[n3];
        this.l = new int[n3];
        this.m = new int[n3];
        this.n = new int[n3];
        this.o = new int[n3];
        this.q = new int[n3];
        this.p = new int[n3];
        this.h = new m(new int[n3], new int[n3]);
    }

    @Override
    public byte[] sign() {
        if (this.b == null) {
            throw new IllegalStateException("instance was not initialized");
        }
        Object[] objectArray = this.a.doFinal();
        Object[] objectArray2 = this.b.getParams().e();
        objectArray = this.a((int[])objectArray2, (byte[])objectArray);
        this.f.reduce((int[])objectArray, (int[])objectArray);
        while (true) {
            this.f.getBigInt().getRandomNumber((Random)this.r, this.f.getOrder(), this.i);
            this.e.a(this.b.getParams().a(), this.i, this.h);
            this.f.reduce(this.h.a(), this.l);
            if (BigInt.equals(this.l, this.g.getZero())) continue;
            this.f.secureMultiply(this.b.a(), this.l, this.m);
            this.f.add((int[])objectArray, this.m, this.m);
            this.f.invert(this.i, this.i);
            this.f.secureMultiply(this.i, this.m, this.m);
            if (!BigInt.equals(this.m, this.g.getZero())) break;
        }
        Utils.clean(this.i);
        int n2 = this.d.getSignatureLength();
        objectArray2 = new byte[n2];
        Utils.toByteArray(this.l, this.j);
        Utils.toByteArray(this.m, this.k);
        System.arraycopy(this.k, 0, objectArray2, 0, n2 >>>= 1);
        System.arraycopy(this.j, 0, objectArray2, n2, n2);
        return objectArray2;
    }

    public void initVerify(ECDSAPublicKey eCDSAPublicKey) {
        this.d = eCDSAPublicKey.getParams();
        this.c = eCDSAPublicKey;
        this.a();
    }

    @Override
    public boolean verify(byte[] objectArray) {
        int n2;
        if (this.c == null) {
            throw new IllegalStateException("instance was not initialized");
        }
        int n3 = objectArray.length;
        int n4 = this.d.getSignatureLength();
        if ((n3 & 1) == 1 || n3 < n4) {
            return false;
        }
        n3 >>>= 1;
        n4 >>>= 1;
        for (n2 = 0; n2 < n3 - n4; ++n2) {
            if (objectArray[n2] == 0) continue;
            return false;
        }
        for (n2 = n3; n2 < 2 * n3 - n4; ++n2) {
            if (objectArray[n2] == 0) continue;
            return false;
        }
        System.arraycopy(objectArray, n3 - n4, this.k, 0, n4);
        System.arraycopy(objectArray, 2 * n3 - n4, this.j, 0, n4);
        Utils.fromByteArray(this.k, this.m);
        Utils.fromByteArray(this.j, this.l);
        byte[] byArray = this.a.doFinal();
        objectArray = this.c.getParams().e();
        objectArray = this.a((int[])objectArray, byArray);
        this.f.reduce((int[])objectArray, (int[])objectArray);
        if (BigInt.compare(this.g.getOne(), this.l) >= 0 || BigInt.compare(this.d.e(), this.l) <= 0) {
            return false;
        }
        if (BigInt.compare(this.g.getOne(), this.m) >= 0 || BigInt.compare(this.d.e(), this.m) <= 0) {
            return false;
        }
        this.f.invert(this.m, this.q);
        this.f.secureMultiply((int[])objectArray, this.q, this.n);
        this.f.secureMultiply(this.l, this.q, this.o);
        this.e.a(this.c.getParams().a(), this.n, this.c.a(), this.o, this.h);
        this.f.reduce(this.h.a(), this.p);
        return BigInt.equals(this.p, this.l);
    }

    @Override
    public boolean verify(byte[] byArray, byte[] byArray2) {
        this.update(byArray, 0, byArray.length);
        return this.verify(byArray2);
    }

    private int[] a(int[] nArray, byte[] byArray) {
        int n2 = BigInt.bitLength(nArray);
        int n3 = this.d.f();
        if (n2 >= byArray.length << 3) {
            return Utils.fromByteArray(byArray, n3);
        }
        byte[] byArray2 = new byte[n2 / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return Utils.fromByteArray(byArray2, n3);
    }
}

