/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GOST3410ECParams2012;
import com.bifit.security.core.Utils;

public final class GOST3410ECPrivateKey2012 {
    private final int[] a;
    private final GOST3410ECParams2012 b;

    public GOST3410ECPrivateKey2012(GOST3410ECParams2012 gOST3410ECParams2012, byte[] byArray) {
        int[] nArray = gOST3410ECParams2012.e();
        int[] nArray2 = Utils.fromByteArray(byArray, nArray.length);
        if (Utils.byteLength(byArray) > gOST3410ECParams2012.getNbyte() || BigInt.bitLength(nArray2) == 0 || BigInt.compare(nArray2, nArray) >= 0) {
            Utils.clean(nArray2);
            throw new IllegalArgumentException("condition 0 < d < q is not met");
        }
        this.b = gOST3410ECParams2012;
        this.a = nArray2;
    }

    GOST3410ECPrivateKey2012(GOST3410ECParams2012 gOST3410ECParams2012, int[] nArray) {
        this.b = gOST3410ECParams2012;
        this.a = nArray;
    }

    public final byte[] getD() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return Utils.toByteArray(this.a, this.b.getNbyte());
    }

    public final GOST3410ECParams2012 getParams() {
        return this.b;
    }

    public final void free() {
        Utils.clean(this.a);
    }

    final int[] a() {
        if (this.a == null) {
            throw new IllegalStateException("key was deallocated");
        }
        return this.a;
    }
}

