/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.GOST3410ECParams;
import com.bifit.security.core.GOST3410ECPrivateKey;
import com.bifit.security.core.GOST3410ECPublicKey;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;
import com.bifit.security.core.m;
import com.bifit.security.core.o;

public final class GOST3410ECSign {
    private SecurePRNG a;
    private GOST3410ECPrivateKey b = null;
    private m c = null;
    private GOST3410ECParams d;
    private o e;
    private GFp f;
    private final byte[] g;
    private final byte[] h;
    private final int[] i = new int[8];
    private final int[] j = new int[8];
    private final int[] k = new int[8];
    private final int[] l = new int[8];
    private final int[] m = new int[8];
    private final int[] n = new int[8];
    private final int[] o = new int[8];
    private final int[] p = new int[8];
    private final m q;
    private final int[] r = new int[16];

    public GOST3410ECSign() {
        this.g = new byte[32];
        this.h = new byte[32];
        this.q = new m(new int[8], new int[8]);
    }

    public final void initSign(GOST3410ECPrivateKey gOST3410ECPrivateKey, SecurePRNG securePRNG) {
        if (!gOST3410ECPrivateKey.getParams().equals(this.d)) {
            this.d = gOST3410ECPrivateKey.getParams();
            this.e = new o(this.d);
            this.f = new GFp(this.d.e());
        }
        this.a = securePRNG;
        this.b = gOST3410ECPrivateKey;
        this.c = null;
    }

    public final byte[] sign(byte[] byArray) {
        if (this.b == null) {
            if (this.c == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for verification of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        m m2 = this.d.a();
        BigInt bigInt = this.f.getBigInt();
        Utils.fromByteArray(byArray, this.r);
        this.f.reduce(this.r, this.k);
        if (BigInt.equals(this.k, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.k);
        }
        while (true) {
            bigInt.getRandomNumber(this.a, this.f.getOrder(), this.l);
            this.e.a(m2, this.l, this.q);
            Utils.copy(this.q.a(), this.r);
            this.f.reduce(this.r, this.i);
            if (BigInt.equals(this.i, bigInt.getZero())) continue;
            this.f.secureMultiply(this.i, this.b.a(), this.j);
            this.f.secureMultiply(this.k, this.l, this.l);
            this.f.add(this.j, this.l, this.j);
            Utils.clean(this.l);
            if (!BigInt.equals(this.j, bigInt.getZero())) break;
        }
        byArray = new byte[64];
        Utils.toByteArray(this.i, this.g);
        Utils.toByteArray(this.j, this.h);
        System.arraycopy(this.g, 0, byArray, 0, 32);
        System.arraycopy(this.h, 0, byArray, 32, 32);
        return byArray;
    }

    public final void initVerify(GOST3410ECPublicKey gOST3410ECPublicKey) {
        if (!gOST3410ECPublicKey.getParams().equals(this.d)) {
            this.d = gOST3410ECPublicKey.getParams();
            this.e = new o(this.d);
            this.f = new GFp(this.d.e());
        }
        this.c = gOST3410ECPublicKey.a();
        this.b = null;
    }

    public final boolean verify(byte[] byArray, byte[] byArray2) {
        if (this.c == null) {
            if (this.b == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for generation of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        if (byArray2.length != 64) {
            throw new IllegalArgumentException("wrong sign length");
        }
        m m2 = this.d.a();
        BigInt bigInt = this.f.getBigInt();
        System.arraycopy(byArray2, 0, this.g, 0, 32);
        Utils.fromByteArray(this.g, this.i);
        System.arraycopy(byArray2, 32, this.h, 0, 32);
        Utils.fromByteArray(this.h, this.j);
        if (BigInt.compare(this.i, this.f.getOrder()) >= 0 || BigInt.compare(this.j, this.f.getOrder()) >= 0 || BigInt.compare(this.i, bigInt.getZero()) <= 0 || BigInt.compare(this.j, bigInt.getZero()) <= 0) {
            return false;
        }
        Utils.fromByteArray(byArray, this.r);
        this.f.reduce(this.r, this.k);
        if (BigInt.equals(this.k, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.k);
        }
        this.f.invert(this.k, this.o);
        this.f.multiply(this.o, this.j, this.m);
        this.f.multiply(this.o, this.i, this.n);
        this.f.subtract(bigInt.getZero(), this.n, this.n);
        this.e.a(m2, this.m, this.c, this.n, this.q);
        Utils.copy(this.q.a(), this.r);
        this.f.reduce(this.r, this.p);
        return BigInt.equals(this.p, this.i);
    }
}

