/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.GOST3410ECParams2012;
import com.bifit.security.core.GOST3410ECPrivateKey2012;
import com.bifit.security.core.GOST3410ECPublicKey2012;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;
import com.bifit.security.core.m;
import com.bifit.security.core.o;

public final class GOST3410ECSign2012 {
    private SecurePRNG a;
    private GOST3410ECPrivateKey2012 b = null;
    private m c = null;
    private GOST3410ECParams2012 d;
    private o e;
    private GFp f;
    private byte[] g;
    private byte[] h;
    private int[] i;
    private int[] j;
    private int[] k;
    private int[] l;
    private int[] m;
    private int[] n;
    private int[] o;
    private int[] p;
    private m q;
    private int[] r;

    private void a() {
        int n2 = this.d.f();
        this.i = new int[n2];
        this.j = new int[n2];
        this.k = new int[n2];
        this.l = new int[n2];
        this.m = new int[n2];
        this.n = new int[n2];
        this.o = new int[n2];
        this.p = new int[n2];
        this.r = new int[n2 << 1];
        this.g = new byte[n2 << 2];
        this.h = new byte[n2 << 2];
        this.q = new m(new int[n2], new int[n2]);
    }

    public final void initSign(GOST3410ECPrivateKey2012 gOST3410ECPrivateKey2012, SecurePRNG securePRNG) {
        if (!gOST3410ECPrivateKey2012.getParams().equals(this.d)) {
            this.d = gOST3410ECPrivateKey2012.getParams();
            this.e = new o(this.d);
            this.f = new GFp(this.d.e());
            this.a();
        }
        this.a = securePRNG;
        this.b = gOST3410ECPrivateKey2012;
        this.c = null;
    }

    public final byte[] sign(byte[] byArray) {
        int n2 = this.d.getNbyte();
        if (this.b == null) {
            if (this.c == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for verification of digital signature");
        }
        if (byArray.length != n2) {
            throw new IllegalArgumentException("wrong hash length");
        }
        m m2 = this.d.a();
        BigInt bigInt = this.f.getBigInt();
        Utils.fromByteArray(byArray, this.r);
        this.f.reduce(this.r, this.k);
        if (BigInt.equals(this.k, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.k);
        }
        while (true) {
            bigInt.getRandomNumber(this.a, this.f.getOrder(), this.l);
            this.e.a(m2, this.l, this.q);
            Utils.copy(this.q.a(), this.r);
            this.f.reduce(this.r, this.i);
            if (BigInt.equals(this.i, bigInt.getZero())) continue;
            this.f.secureMultiply(this.i, this.b.a(), this.j);
            this.f.secureMultiply(this.k, this.l, this.l);
            this.f.add(this.j, this.l, this.j);
            Utils.clean(this.l);
            if (!BigInt.equals(this.j, bigInt.getZero())) break;
        }
        byArray = new byte[n2 << 1];
        Utils.toByteArray(this.i, this.g);
        Utils.toByteArray(this.j, this.h);
        System.arraycopy(this.g, 0, byArray, 0, n2);
        System.arraycopy(this.h, 0, byArray, n2, n2);
        return byArray;
    }

    public final void initVerify(GOST3410ECPublicKey2012 gOST3410ECPublicKey2012) {
        if (!gOST3410ECPublicKey2012.getParams().equals(this.d)) {
            this.d = gOST3410ECPublicKey2012.getParams();
            this.e = new o(this.d);
            this.f = new GFp(this.d.e());
        }
        this.c = gOST3410ECPublicKey2012.a();
        this.b = null;
        this.a();
    }

    public final boolean verify(byte[] byArray, byte[] byArray2) {
        int n2 = this.d.getNbyte();
        if (this.c == null) {
            if (this.b == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for generation of digital signature");
        }
        if (byArray.length != n2) {
            throw new IllegalArgumentException("wrong hash length");
        }
        if (byArray2.length != n2 << 1) {
            throw new IllegalArgumentException("wrong sign length");
        }
        m m2 = this.d.a();
        BigInt bigInt = this.f.getBigInt();
        System.arraycopy(byArray2, 0, this.g, 0, n2);
        Utils.fromByteArray(this.g, this.i);
        System.arraycopy(byArray2, n2, this.h, 0, n2);
        Utils.fromByteArray(this.h, this.j);
        if (BigInt.compare(this.i, this.f.getOrder()) >= 0 || BigInt.compare(this.j, this.f.getOrder()) >= 0 || BigInt.compare(this.i, bigInt.getZero()) <= 0 || BigInt.compare(this.j, bigInt.getZero()) <= 0) {
            return false;
        }
        Utils.fromByteArray(byArray, this.r);
        this.f.reduce(this.r, this.k);
        if (BigInt.equals(this.k, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.k);
        }
        this.f.invert(this.k, this.o);
        this.f.multiply(this.o, this.j, this.m);
        this.f.multiply(this.o, this.i, this.n);
        this.f.subtract(bigInt.getZero(), this.n, this.n);
        this.e.a(m2, this.m, this.c, this.n, this.q);
        Utils.copy(this.q.a(), this.r);
        this.f.reduce(this.r, this.p);
        return BigInt.equals(this.p, this.i);
    }
}

