/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.GOST3410Params;
import com.bifit.security.core.GOST3410PrivateKey;
import com.bifit.security.core.GOST3410PublicKey;
import com.bifit.security.core.SecurePRNG;
import com.bifit.security.core.Utils;

public final class GOST3410Sign {
    private SecurePRNG a;
    private GOST3410PrivateKey b = null;
    private int[] c = null;
    private int[][] d = null;
    private GOST3410Params e;
    private GFp f;
    private GFp g;
    private final byte[] h;
    private final byte[] i;
    private final int[] j = new int[32];
    private final int[] k = new int[32];
    private final int[] l = new int[32];
    private final int[] m = new int[32];
    private final int[] n = new int[32];
    private final int[] o = new int[32];
    private final int[] p;
    private final int[] q = new int[32];
    private final int[] r = new int[32];

    public GOST3410Sign() {
        this.p = new int[64];
        this.h = new byte[32];
        this.i = new byte[32];
    }

    public final void initSign(GOST3410PrivateKey gOST3410PrivateKey, SecurePRNG securePRNG) {
        if (!gOST3410PrivateKey.getParams().equals(this.e)) {
            this.e = gOST3410PrivateKey.getParams();
            this.f = new GFp(this.e.a());
            this.g = new GFp(this.e.b());
        }
        this.a = securePRNG;
        this.b = gOST3410PrivateKey;
        this.c = null;
        this.d = null;
    }

    public final byte[] sign(byte[] byArray) {
        if (this.b == null) {
            if (this.c == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for verification of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        int[] nArray = this.e.c();
        BigInt bigInt = this.f.getBigInt();
        Utils.fromByteArray(byArray, this.p);
        this.g.reduce(this.p, this.l);
        if (BigInt.equals(this.l, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.l);
        }
        while (true) {
            bigInt.getRandomNumber(this.a, this.g.getOrder(), this.m);
            this.f.modPow(nArray, this.m, this.e.d(), null, null, null, this.j);
            Utils.copy(this.j, this.p);
            bigInt.divide(this.p, this.g.getOrder(), null, this.j);
            if (BigInt.equals(this.j, bigInt.getZero())) continue;
            this.g.secureMultiply(this.j, this.b.a(), this.k);
            this.g.secureMultiply(this.m, this.l, this.m);
            this.g.add(this.k, this.m, this.k);
            Utils.clean(this.m);
            if (!BigInt.equals(this.k, bigInt.getZero())) break;
        }
        byArray = new byte[64];
        Utils.toByteArray(this.j, this.h);
        Utils.toByteArray(this.k, this.i);
        System.arraycopy(this.h, 0, byArray, 0, 32);
        System.arraycopy(this.i, 0, byArray, 32, 32);
        return byArray;
    }

    public final void initVerify(GOST3410PublicKey gOST3410PublicKey) {
        if (!gOST3410PublicKey.getParams().equals(this.e)) {
            this.e = gOST3410PublicKey.getParams();
            this.f = new GFp(this.e.a());
            this.g = new GFp(this.e.b());
        }
        this.c = gOST3410PublicKey.a();
        this.d = gOST3410PublicKey.b();
        this.b = null;
    }

    public final boolean verify(byte[] byArray, byte[] byArray2) {
        if (this.c == null) {
            if (this.b == null) {
                throw new IllegalStateException("instance was not initialized");
            }
            throw new IllegalStateException("instance is initialized for generation of digital signature");
        }
        if (byArray.length != 32) {
            throw new IllegalArgumentException("wrong hash length");
        }
        if (byArray2.length != 64) {
            throw new IllegalArgumentException("wrong sign length");
        }
        int[] nArray = this.e.c();
        BigInt bigInt = this.f.getBigInt();
        System.arraycopy(byArray2, 0, this.h, 0, 32);
        Utils.fromByteArray(this.h, this.j);
        System.arraycopy(byArray2, 32, this.i, 0, 32);
        Utils.fromByteArray(this.i, this.k);
        if (BigInt.compare(this.j, this.g.getOrder()) >= 0 || BigInt.compare(this.k, this.g.getOrder()) >= 0 || BigInt.compare(this.j, bigInt.getZero()) <= 0 || BigInt.compare(this.k, bigInt.getZero()) <= 0) {
            return false;
        }
        Utils.fromByteArray(byArray, this.p);
        this.g.reduce(this.p, this.l);
        if (BigInt.equals(this.l, bigInt.getZero())) {
            Utils.copy(bigInt.getOne(), this.l);
        }
        this.g.invert(this.l, this.q);
        this.g.subtract(this.g.getOrder(), this.j, this.o);
        this.g.multiply(this.q, this.o, this.o);
        this.g.multiply(this.q, this.k, this.n);
        this.f.modPow(nArray, this.n, this.e.d(), this.c, this.o, this.d, this.r);
        Utils.copy(this.r, this.p);
        bigInt.divide(this.p, this.g.getOrder(), null, this.r);
        return BigInt.equals(this.r, this.j);
    }
}

