/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.core;

import com.bifit.security.core.BigInt;
import com.bifit.security.core.GFp;
import com.bifit.security.core.RSAKey;
import com.bifit.security.core.RSAPrivateKey;
import com.bifit.security.core.w;
import java.io.ByteArrayOutputStream;
import java.security.SecureRandom;
import java.util.Random;

public final class RSACipherNoPadding {
    public static final int ENCRYPT = 0;
    public static final int DECRYPT = 1;
    private final w a;
    private final ByteArrayOutputStream b = new ByteArrayOutputStream();
    private RSAKey c;
    private GFp d;
    private SecureRandom e;
    private boolean f = false;

    public RSACipherNoPadding() {
        this.a = new w();
    }

    public final void init(int n2, RSAKey rSAKey, SecureRandom secureRandom) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("invalid mode specified");
        }
        if (rSAKey == null) {
            throw new IllegalArgumentException("invalid key");
        }
        if (secureRandom == null) {
            throw new IllegalArgumentException("invalid random source");
        }
        this.a.a(n2, rSAKey);
        this.c = rSAKey;
        this.e = secureRandom;
        this.d = new GFp(rSAKey.a());
        this.f = true;
    }

    final byte[] a(byte[] objectArray, int n2, int n3) {
        if (!this.f) {
            throw new IllegalStateException("cipher was not initialized");
        }
        int n4 = this.c.getSize();
        objectArray = this.a.a((byte[])objectArray, n2, n3);
        int[] nArray = new int[n4];
        if (this.c instanceof RSAPrivateKey) {
            Object object = (RSAPrivateKey)this.c;
            int[] nArray2 = ((RSAKey)object).b();
            if (nArray2 != null) {
                object = ((RSAKey)object).a();
                BigInt bigInt = this.d.getBigInt();
                int[] nArray3 = new int[n4];
                int[] nArray4 = new int[n4];
                int[] nArray5 = new int[n4];
                bigInt.subtract((int[])object, bigInt.getOne(), nArray4);
                bigInt.getRandomNumber((Random)this.e, nArray4, nArray3);
                this.d.modPow(nArray3, nArray2, nArray5);
                this.d.secureMultiply(nArray5, (int[])objectArray, nArray5);
                objectArray = this.a.b(nArray5);
                this.d.invert(nArray3, nArray3);
                this.d.secureMultiply(nArray3, (int[])objectArray, nArray);
            } else {
                nArray = this.a.b((int[])objectArray);
            }
        } else {
            nArray = this.a.b((int[])objectArray);
        }
        return this.a.a(nArray);
    }

    public final int getInputBlockSize() {
        return this.a.a();
    }

    final int a() {
        return this.a.b();
    }

    public final void update(byte[] byArray, int n2, int n3) {
        if (!this.f) {
            throw new IllegalStateException("cipher was not initialized");
        }
        this.b.write(byArray, n2, n3);
        if (this.b.size() > this.getInputBlockSize() + 1) {
            throw new ArrayIndexOutOfBoundsException("too much data for RSA block");
        }
    }

    public final byte[] doFinalEncrypt() {
        if (!this.f) {
            throw new IllegalStateException("cipher was not initialized");
        }
        byte[] byArray = this.b.toByteArray();
        this.b.reset();
        return this.a(byArray, 0, byArray.length);
    }
}

