/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ua.com.dbosoft.autoclient.app.RequestSender;
import ua.com.dbosoft.autoclient.app.account.Account;
import ua.com.dbosoft.autoclient.app.account.b;
import ua.com.dbosoft.autoclient.app.account.c;
import ua.com.dbosoft.autoclient.app.client.Client;
import ua.com.dbosoft.autoclient.app.dao.RepositoryManager;
import ua.com.dbosoft.autoclient.app.e;
import ua.com.dbosoft.autoclient.app.f;
import ua.com.dbosoft.autoclient.app.operation.Operation;
import ua.com.dbosoft.autoclient.app.turnover.Turnover;

public class Exporter {
    private final Logger a = LoggerFactory.getLogger(Exporter.class);
    private final DateTimeFormatter b = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private Path c;
    private LocalDate d;
    private LocalDate e;
    private int f = 50000;
    private boolean g;
    private final RepositoryManager h;
    private final RequestSender i;

    public Exporter(RepositoryManager repositoryManager, RequestSender requestSender) {
        this.h = repositoryManager;
        this.i = requestSender;
    }

    public Exporter setOutputDir(Path object) {
        this.c = object;
        object = this;
        ((Exporter)object).a.info(Exporter.c("clientDirCheck"), (Object)((Exporter)object).c);
        File file = ((Exporter)object).c.toFile();
        if (!file.exists() || !file.isDirectory()) {
            throw new IllegalArgumentException(String.format(Exporter.c("clientDirNotFound"), ((Exporter)object).c));
        }
        return this;
    }

    public Exporter setBeginDateParam(String string) {
        this.d = this.b(string);
        return this;
    }

    public Exporter setEndDateParam(String string) {
        this.e = this.b(string);
        return this;
    }

    public Exporter setPageSize(int n2) {
        this.f = n2;
        return this;
    }

    public Exporter setExportAllFields(boolean bl) {
        this.g = bl;
        return this;
    }

    public void clearOutputDirectory() {
        this.a.info(Exporter.c("oldOutputFilesDeleting"));
        Exporter exporter = this;
        if (exporter.a(exporter.c.toFile())) {
            this.a.info(Exporter.c("oldOutputFilesDeletedSuccessfully"));
            return;
        }
        this.a.warn(Exporter.c("notAllOutputFilesDeleted"));
    }

    public List<Account> getAccountsForExport() {
        Object object = this.h.a();
        this.a.info(Exporter.c("receivingClientAccounts"));
        object = object.a().stream().filter(account -> !ua.com.dbosoft.autoclient.app.account.c.b.equals((Object)account.getType()) && !ua.com.dbosoft.autoclient.app.account.b.a.equals((Object)account.getStatus()) && account.getPermission() != null).collect(Collectors.toList());
        this.a.info(Exporter.c("clientAccountsReceived"), (Object)object.size());
        return object;
    }

    public Iterator<Operation> startOperationsLoading(Account account) {
        return new e(this, account);
    }

    public Iterator<Turnover> startTurnoversLoading(Account account) {
        return new f(this, account);
    }

    public Writer createOperationsOutputFile(Account object) {
        object = this.c.resolve(Exporter.a((Account)object) + ((Account)object).getCurrency() + "_opers.txt");
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(Files.newOutputStream((Path)object, new OpenOption[0])), "cp1251");
    }

    public Writer createTurnoversOutputFile(Account object) {
        object = this.c.resolve(Exporter.a((Account)object) + ((Account)object).getCurrency() + "_saldo.txt");
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(Files.newOutputStream((Path)object, new OpenOption[0])), "cp1251");
    }

    public void writeOperationsHeader(Writer writer) {
        writer.write(Exporter.c("baseOperationsHeader"));
        if (this.g) {
            writer.write(59);
            writer.write(Exporter.c("operationsHeaderExtension"));
        }
        writer.write(System.lineSeparator());
    }

    public void writeTurnoversHeader(Writer writer) {
        writer.write(Exporter.c("turnoversHeader"));
        writer.write(System.lineSeparator());
    }

    public void writeOperation(Operation operation, Account object, Writer writer) {
        Object object2 = this.h.e().a();
        Exporter.a(((Client)object2).getCode(), writer);
        Exporter.a(((Account)object).getBankCode(), writer);
        Exporter.a(Exporter.a((Account)object), writer);
        Exporter.a(((Account)object).getCurrency(), writer);
        Exporter.a(operation.getTime(), writer);
        Exporter.a(operation.getCode(), writer);
        Exporter.a(operation.getCorrBankCode(), writer);
        this.b(operation.getCorrBankName(), writer);
        Exporter.a(operation.getCorrAccount(), writer);
        Exporter.a(operation.getCorrInn(), writer);
        this.b(operation.getCorrName(), writer);
        this.b(operation.getDocNumber(), writer);
        Exporter.a(operation.getDocDate(), writer);
        Exporter.a(operation.getDebit(), writer);
        Exporter.a(operation.getCredit(), writer);
        this.b(operation.getDetails(), writer);
        Exporter.a(operation.getHryvniaCoverage(), writer);
        if (this.g) {
            Exporter.a(operation.getOperId(), writer);
            Exporter.a(operation.getPurposeCode(), writer);
            this.b(operation.getAdditionalInfo(), writer);
            Exporter.a(operation.getUetr(), writer);
            Writer writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getCorrPasspNum(), writer2);
            Exporter.a(((Operation)object2).getCorrPasspSer(), writer2);
            super.b(((Operation)object2).getCorrPasspName(), writer2);
            Exporter.a(((Operation)object2).getCorrPostcode(), writer2);
            super.b(((Operation)object2).getCorrRegion(), writer2);
            super.b(((Operation)object2).getCorrDistrict(), writer2);
            super.b(((Operation)object2).getCorrCity(), writer2);
            super.b(((Operation)object2).getCorrStreet(), writer2);
            Exporter.a(((Operation)object2).getCorrHouseNumber(), writer2);
            Exporter.a(((Operation)object2).getCorrOfficeNumber(), writer2);
            Exporter.a(((Operation)object2).getCorrCountryLocation(), writer2);
            Exporter.a(((Operation)object2).getCorrCountryCode(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            ((Exporter)object).b(((Operation)object2).getActPayerName(), writer2);
            Exporter.a(((Operation)object2).getActPayerCode(), writer2);
            Exporter.a(((Operation)object2).getActPayerPasspNum(), writer2);
            Exporter.a(((Operation)object2).getActPayerPasspSer(), writer2);
            super.b(((Operation)object2).getActPayerPasspName(), writer2);
            Exporter.a(((Operation)object2).getActPayerPostcode(), writer2);
            super.b(((Operation)object2).getActPayerRegion(), writer2);
            super.b(((Operation)object2).getActPayerDistrict(), writer2);
            super.b(((Operation)object2).getActPayerCity(), writer2);
            super.b(((Operation)object2).getActPayerStreet(), writer2);
            Exporter.a(((Operation)object2).getActPayerHouseNumber(), writer2);
            Exporter.a(((Operation)object2).getActPayerOfficeNumber(), writer2);
            Exporter.a(((Operation)object2).getActPayerCountryLocation(), writer2);
            Exporter.a(((Operation)object2).getActPayerCountryCode(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            ((Exporter)object).b(((Operation)object2).getActRcptName(), writer2);
            Exporter.a(((Operation)object2).getActRcptCode(), writer2);
            Exporter.a(((Operation)object2).getActRcptPasspNum(), writer2);
            Exporter.a(((Operation)object2).getActRcptPasspSer(), writer2);
            super.b(((Operation)object2).getActRcptPasspName(), writer2);
            Exporter.a(((Operation)object2).getActRcptPostcode(), writer2);
            super.b(((Operation)object2).getActRcptRegion(), writer2);
            super.b(((Operation)object2).getActRcptDistrict(), writer2);
            super.b(((Operation)object2).getActRcptCity(), writer2);
            super.b(((Operation)object2).getActRcptStreet(), writer2);
            Exporter.a(((Operation)object2).getActRcptHouseNumber(), writer2);
            Exporter.a(((Operation)object2).getActRcptOfficeNumber(), writer2);
            Exporter.a(((Operation)object2).getActRcptCountryLocation(), writer2);
            Exporter.a(((Operation)object2).getActRcptCountryCode(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            ((Exporter)object).b(((Operation)object2).getPaymentInitName(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitCode(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitPasspNum(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitPasspSer(), writer2);
            super.b(((Operation)object2).getPaymentInitPasspName(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitPostcode(), writer2);
            super.b(((Operation)object2).getPaymentInitRegion(), writer2);
            super.b(((Operation)object2).getPaymentInitDistrict(), writer2);
            super.b(((Operation)object2).getPaymentInitCity(), writer2);
            super.b(((Operation)object2).getPaymentInitStreet(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitHouseNumber(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitOfficeNumber(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitCountryLocation(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitCountryCode(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getCorrEmployeeFio(), writer2);
            Exporter.a(((Operation)object2).getCorrEmployeePhone(), writer2);
            Exporter.a(((Operation)object2).getCorrEmployeeMobile(), writer2);
            Exporter.a(((Operation)object2).getCorrEmployeeEmail(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getActPayerEmployeeFio(), writer2);
            Exporter.a(((Operation)object2).getActPayerEmployeePhone(), writer2);
            Exporter.a(((Operation)object2).getActPayerEmployeeMobile(), writer2);
            Exporter.a(((Operation)object2).getActPayerEmployeeEmail(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getActRcptEmployeeFio(), writer2);
            Exporter.a(((Operation)object2).getActRcptEmployeePhone(), writer2);
            Exporter.a(((Operation)object2).getActRcptEmployeeMobile(), writer2);
            Exporter.a(((Operation)object2).getActRcptEmployeeEmail(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getPaymentInitEmployeeFio(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitEmployeePhone(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitEmployeeMobile(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitEmployeeEmail(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getCorrBirthDate(), writer2);
            Exporter.a(((Operation)object2).getCorrBirthCity(), writer2);
            Exporter.a(((Operation)object2).getCorrBirthCountry(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getActPayerBirthDate(), writer2);
            Exporter.a(((Operation)object2).getActPayerBirthCity(), writer2);
            Exporter.a(((Operation)object2).getActPayerBirthCountry(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getActRcptBirthDate(), writer2);
            Exporter.a(((Operation)object2).getActRcptBirthCity(), writer2);
            Exporter.a(((Operation)object2).getActRcptBirthCountry(), writer2);
            writer2 = writer;
            object2 = operation;
            object = this;
            Exporter.a(((Operation)object2).getPaymentInitBirthDate(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitBirthCity(), writer2);
            Exporter.a(((Operation)object2).getPaymentInitBirthCountry(), writer2);
        }
        writer.write(System.lineSeparator());
    }

    public void writeTurnover(Turnover turnover, Account account, Writer writer) {
        Exporter.a(turnover.getDate(), writer);
        Exporter.a(Exporter.a(account), writer);
        Exporter.a(account.getCurrency(), writer);
        Exporter.a(turnover.getInRemainder(), writer);
        Exporter.a(turnover.getInRemainderN(), writer);
        Exporter.a(turnover.getDebit(), writer);
        Exporter.a(turnover.getDebitN(), writer);
        Exporter.a(turnover.getCredit(), writer);
        Exporter.a(turnover.getCreditN(), writer);
        Exporter.a(turnover.getOutRemainder(), writer);
        Exporter.a(turnover.getOutRemainderN(), writer);
        writer.write(System.lineSeparator());
    }

    private static void a(String string, Writer writer) {
        if (string != null) {
            writer.write(string);
        }
        writer.write(59);
    }

    private void b(String string, Writer writer) {
        if (string != null) {
            writer.write(Exporter.a(string));
        }
        writer.write(59);
    }

    private static String a(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.replace("\"", "\"\"")).contains(";") || string.contains("\"")) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    private boolean a(File fileArray) {
        boolean bl = true;
        for (File file : fileArray.listFiles()) {
            if (file.isDirectory()) {
                bl &= this.a(file);
                continue;
            }
            bl &= file.delete();
        }
        return bl;
    }

    private LocalDate b(String string) {
        if (string == null || string.isEmpty() || string.equals("0")) {
            return LocalDate.now();
        }
        try {
            if (!string.startsWith("-")) {
                return LocalDate.parse(string, this.b);
            }
            if (string.length() > 9) {
                throw new NumberFormatException("Too long value");
            }
            return LocalDate.now().plusDays(Integer.parseInt(string));
        }
        catch (NumberFormatException | DateTimeParseException runtimeException) {
            throw new RuntimeException(String.format(Exporter.c("wrongDateFormat"), string), runtimeException);
        }
    }

    private static String c(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/export/exportMessages").getString(string);
    }

    private static String a(Account account) {
        if (account.getIban() == null) {
            return account.getNumber();
        }
        return account.getIban();
    }

    static /* synthetic */ LocalDate a(Exporter exporter) {
        return exporter.d;
    }

    static /* synthetic */ DateTimeFormatter b(Exporter exporter) {
        return exporter.b;
    }

    static /* synthetic */ LocalDate c(Exporter exporter) {
        return exporter.e;
    }

    static /* synthetic */ int d(Exporter exporter) {
        return exporter.f;
    }

    static /* synthetic */ boolean e(Exporter exporter) {
        return exporter.g;
    }

    static /* synthetic */ String a(Exporter exporter, String string) {
        return Exporter.c(string);
    }

    static /* synthetic */ Logger f(Exporter exporter) {
        return exporter.a;
    }

    static /* synthetic */ RequestSender g(Exporter exporter) {
        return exporter.i;
    }
}

