/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_payment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.Size;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import ua.com.dbosoft.autoclient.app.ForbiddenUnicode;
import ua.com.dbosoft.autoclient.app.account.Iban;
import ua.com.dbosoft.autoclient.app.c;
import ua.com.dbosoft.autoclient.app.client.OrgCodeKeying;
import ua.com.dbosoft.autoclient.app.ua_payment.BPTemplateTypeSerializer;
import ua.com.dbosoft.autoclient.app.ua_payment.BpSingleAccountRow;
import ua.com.dbosoft.autoclient.app.ua_payment.BudgetPaymentTemplateType;
import ua.com.dbosoft.autoclient.app.validation.d;
import ua.com.dbosoft.autoclient.format.json.BigDecimalSerializer;
import ua.com.dbosoft.autoclient.format.json.LocalDateSerializer;

public class UaPayment
implements c {
    private static final ua.com.dbosoft.autoclient.format.ibank2.c<UaPayment> UA_PAYMENT_WRITER = new ua.com.dbosoft.autoclient.format.ibank2.c<UaPayment>(UaPayment.class);
    private long id;
    private Integer statusCode;
    @JsonProperty(value="DATE_DOC")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate date;
    @JsonProperty(value="NUM_DOC")
    private String number;
    @JsonProperty(value="AMOUNT")
    @JsonSerialize(using=BigDecimalSerializer.class)
    private BigDecimal amount;
    @JsonProperty(value="CLN_NAME")
    private String clientName;
    @JsonProperty(value="CLN_OKPO")
    private String clientCode;
    @JsonProperty(value="CLN_ACCOUNT")
    private String clientAccount;
    @JsonProperty(value="CLN_BANK_NAME")
    private String clientBankName;
    @JsonProperty(value="CLN_BANK_MFO")
    private String clientBankCode;
    @JsonProperty(value="RCPT_NAME")
    private String recipientName;
    @JsonProperty(value="RCPT_OKPO")
    private String recipientCode;
    @JsonProperty(value="RCPT_ACCOUNT")
    private String recipientAccount;
    @JsonProperty(value="RCPT_BANK_NAME")
    private String recipientBankName;
    @JsonProperty(value="RCPT_BANK_MFO")
    private String recipientBankCode;
    @JsonProperty(value="PAYMENT_DETAILS")
    private String paymentDetails;
    @JsonProperty(value="VALUE_DATE")
    @JsonSerialize(using=LocalDateSerializer.class)
    private LocalDate valueDate;
    @JsonProperty(value="RCPT_COUNTRY_CODE")
    private String recipientCountryCode;
    @JsonProperty(value="CLN_COUNTRY_CODE")
    private String clientCountryCode;
    @JsonProperty(value="EXPENSE_ITEM")
    private String expenseItem;
    @JsonProperty(value="RCPT_PASSP_SER")
    private String recipientPassportSerial;
    @JsonProperty(value="RCPT_PASSP_NUM")
    private String recipientPassportNumber;
    @JsonProperty(value="CLN_PASSP_SER")
    private String clientPassportSerial;
    @JsonProperty(value="CLN_PASSP_NUM")
    private String clientPassportNumber;
    @JsonProperty(value="PRIORITY")
    private String priority;
    @JsonProperty(value="CLN_PASSP_TYPE")
    private Integer clientPassportTypeId;
    @JsonProperty(value="CLN_PASSP_NAME")
    private String clientPassportType;
    @JsonProperty(value="CLN_PROPRIETARY")
    private String clientProprietary;
    @JsonProperty(value="RCPT_PASSP_TYPE")
    private Integer recipientPassportTypeId;
    @JsonProperty(value="RCPT_PASSP_NAME")
    private String recipientPassportType;
    @JsonProperty(value="RCPT_PROPRIETARY")
    private String recipientProprietary;
    @JsonProperty(value="CLN_POSTCODE")
    private String clientPostcode;
    @JsonProperty(value="CLN_REGION")
    private String clientRegion;
    @JsonProperty(value="CLN_DISTRICT")
    private String clientDistrict;
    @JsonProperty(value="CLN_CITY")
    private String clientCity;
    @JsonProperty(value="CLN_STREET")
    private String clientStreet;
    @JsonProperty(value="CLN_HOUSE_NUMBER")
    private String clientHouseNumber;
    @JsonProperty(value="CLN_OFFICE_NUMBER")
    private String clientOfficeNumber;
    @JsonProperty(value="CLN_COUNTRY_LOCATION")
    private String clientCountryLocation;
    @JsonProperty(value="RCPT_POSTCODE")
    private String recipientPostcode;
    @JsonProperty(value="RCPT_REGION")
    private String recipientRegion;
    @JsonProperty(value="RCPT_DISTRICT")
    private String recipientDistrict;
    @JsonProperty(value="RCPT_CITY")
    private String recipientCity;
    @JsonProperty(value="RCPT_STREET")
    private String recipientStreet;
    @JsonProperty(value="RCPT_HOUSE_NUMBER")
    private String recipientHouseNumber;
    @JsonProperty(value="RCPT_OFFICE_NUMBER")
    private String recipientOfficeNumber;
    @JsonProperty(value="RCPT_COUNTRY_LOCATION")
    private String recipientCountryLocation;
    @JsonProperty(value="UETR")
    private String uniqueTransactionIdentifier;
    @JsonProperty(value="UCLN_NAME")
    private String actualPayerName;
    @JsonProperty(value="UCLN_OKPO")
    private String actualPayerCode;
    @JsonProperty(value="UCLN_PASSP_NUM")
    private String actualPayerPassportNumber;
    @JsonProperty(value="UCLN_PASSP_SER")
    private String actualPayerPassportSerial;
    @JsonProperty(value="UCLN_PASSP_TYPE")
    private Integer actualPayerPassportTypeId;
    @JsonProperty(value="UCLN_PASSP_NAME")
    private String actualPayerPassportType;
    @JsonProperty(value="UCLN_PROPRIETARY")
    private String actualPayerProprietary;
    @JsonProperty(value="UCLN_POSTCODE")
    private String actualPayerPostcode;
    @JsonProperty(value="UCLN_REGION")
    private String actualPayerRegion;
    @JsonProperty(value="UCLN_DISTRICT")
    private String actualPayerDistrict;
    @JsonProperty(value="UCLN_CITY")
    private String actualPayerCity;
    @JsonProperty(value="UCLN_STREET")
    private String actualPayerStreet;
    @JsonProperty(value="UCLN_HOUSE_NUMBER")
    private String actualPayerHouseNumber;
    @JsonProperty(value="UCLN_OFFICE_NUMBER")
    private String actualPayerOfficeNumber;
    @JsonProperty(value="UCLN_COUNTRY_LOCATION")
    private String actualPayerCountryLocation;
    @JsonProperty(value="UCLN_COUNTRY_CODE")
    private String actualPayerCountryCode;
    @JsonProperty(value="URCPT_NAME")
    private String actualRecipientName;
    @JsonProperty(value="URCPT_OKPO")
    private String actualRecipientCode;
    @JsonProperty(value="URCPT_PASSP_NUM")
    private String actualRecipientPassportNumber;
    @JsonProperty(value="URCPT_PASSP_SER")
    private String actualRecipientPassportSerial;
    @JsonProperty(value="URCPT_PASSP_TYPE")
    private Integer actualRecipientPassportTypeId;
    @JsonProperty(value="URCPT_PASSP_NAME")
    private String actualRecipientPassportType;
    @JsonProperty(value="URCPT_PROPRIETARY")
    private String actualRecipientProprietary;
    @JsonProperty(value="URCPT_POSTCODE")
    private String actualRecipientPostcode;
    @JsonProperty(value="URCPT_REGION")
    private String actualRecipientRegion;
    @JsonProperty(value="URCPT_DISTRICT")
    private String actualRecipientDistrict;
    @JsonProperty(value="URCPT_CITY")
    private String actualRecipientCity;
    @JsonProperty(value="URCPT_STREET")
    private String actualRecipientStreet;
    @JsonProperty(value="URCPT_HOUSE_NUMBER")
    private String actualRecipientHouseNumber;
    @JsonProperty(value="URCPT_OFFICE_NUMBER")
    private String actualRecipientOfficeNumber;
    @JsonProperty(value="URCPT_COUNTRY_LOCATION")
    private String actualRecipientCountryLocation;
    @JsonProperty(value="URCPT_COUNTRY_CODE")
    private String actualRecipientCountryCode;
    @JsonProperty(value="RCPT_BANK_TYPE")
    private String recipientBankType;
    @JsonProperty(value="RCPT_BANK_ASP_MFO")
    private String recipientAspBankCode;
    @JsonProperty(value="BP_TEMPLATE_TYPE")
    @JsonSerialize(using=BPTemplateTypeSerializer.class)
    private BudgetPaymentTemplateType budgetPaymentTemplateType;
    @JsonProperty(value="BP_TAXCODE")
    private String budgetPaymentTaxCode;
    @JsonProperty(value="BP_ADD_INFO")
    private String budgetPaymentAdditionalInfo;
    @JsonProperty(value="BP_INCOME_CODE")
    private String budgetPaymentIncomeCode;
    @JsonProperty(value="ADDITIONAL_INFO")
    private String additionalInfo;
    @JsonIgnore
    private String budgetPaymentAccount;
    @JsonIgnore
    private String budgetPaymentTaxMsg;
    @JsonProperty(value="BP_SINGLE_ACC_ROWS")
    private List<BpSingleAccountRow> bpSingleAccountRows;
    @JsonProperty(value="CLN_EMPLOYEE_FIO")
    private String clnEmployeeFio;
    @JsonProperty(value="CLN_EMPLOYEE_PHONE")
    private String clnEmployeePhone;
    @JsonProperty(value="CLN_EMPLOYEE_MOBILE")
    private String clnEmployeeMobile;
    @JsonProperty(value="CLN_EMPLOYEE_EMAIL")
    private String clnEmployeeEmail;
    @JsonProperty(value="RCPT_EMPLOYEE_FIO")
    private String rcptEmployeeFio;
    @JsonProperty(value="RCPT_EMPLOYEE_PHONE")
    private String rcptEmployeePhone;
    @JsonProperty(value="RCPT_EMPLOYEE_MOBILE")
    private String rcptEmployeeMobile;
    @JsonProperty(value="RCPT_EMPLOYEE_EMAIL")
    private String rcptEmployeeEmail;
    @JsonProperty(value="UCLN_EMPLOYEE_FIO")
    private String uclnEmployeeFio;
    @JsonProperty(value="UCLN_EMPLOYEE_PHONE")
    private String uclnEmployeePhone;
    @JsonProperty(value="UCLN_EMPLOYEE_MOBILE")
    private String uclnEmployeeMobile;
    @JsonProperty(value="UCLN_EMPLOYEE_EMAIL")
    private String uclnEmployeeEmail;
    @JsonProperty(value="URCPT_EMPLOYEE_FIO")
    private String urcptEmployeeFio;
    @JsonProperty(value="URCPT_EMPLOYEE_PHONE")
    private String urcptEmployeePhone;
    @JsonProperty(value="URCPT_EMPLOYEE_MOBILE")
    private String urcptEmployeeMobile;
    @JsonProperty(value="URCPT_EMPLOYEE_EMAIL")
    private String urcptEmployeeEmail;
    @JsonProperty(value="INSTANT_FLAG")
    private String instantFlag;
    @JsonProperty(value="COMMISSION_PAYER")
    private String commissionPayer;
    @JsonProperty(value="COMMISSION_AMOUNT")
    private BigDecimal commissionAmount;
    @JsonProperty(value="COMMISSION_BNK_NAME")
    private String commissionBnkName;
    @JsonProperty(value="COMMISSION_BNK_MFO")
    private String commissionBnkMfo;
    @JsonProperty(value="COMMISSION_TYPE")
    private String commissionType;
    @JsonProperty(value="RCPT_REFERENCE_INFO")
    private String rcptReferenceInfo;
    @JsonProperty(value="INFO_FOR_NEXT_AGENT")
    private String infoForNextAgent;

    @Override
    @ua.com.dbosoft.autoclient.format.ibank2.d(a="DATE_DOC", b=0, c=false)
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
    }

    @Override
    @ua.com.dbosoft.autoclient.format.ibank2.d(a="NUM_DOC", b=1, c=false)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String string) {
        this.number = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(b=2, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)")
    @Positive(message="{docAmountMustBePositive} (AMOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.AMOUNT}\" (AMOUNT)") @Positive(message="{docAmountMustBePositive} (AMOUNT)") BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal bigDecimal) {
        this.amount = bigDecimal;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_NAME", b=3, c=false)
    @ForbiddenUnicode(message="{field} \"{desc.CLN_NAME}\" {containsForbiddenSymbols} (CLN_NAME)")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String string) {
        this.clientName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_OKPO", b=4, c=false)
    public String getClientCode() {
        return this.clientCode;
    }

    public void setClientCode(String string) {
        this.clientCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_ACCOUNT", b=5, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)")
    public @NotNull(message="{emptyRequiredField} \"{desc.CLN_ACCOUNT}\" (CLN_ACCOUNT)") String getClientAccount() {
        return this.clientAccount;
    }

    public void setClientAccount(String string) {
        this.clientAccount = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_BANK_NAME", b=6, c=false)
    public String getClientBankName() {
        return this.clientBankName;
    }

    public void setClientBankName(String string) {
        this.clientBankName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_BANK_MFO", b=7, c=false)
    public String getClientBankCode() {
        return this.clientBankCode;
    }

    public void setClientBankCode(String string) {
        this.clientBankCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_NAME", b=8, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)")
    @Size(min=3, message="{fieldSize} \"{desc.RCPT_NAME}\" {mustBeNotLess} {min} {symbols3} (RCPT_NAME)")
    @ForbiddenUnicode(message="{field} \"{desc.RCPT_NAME}\" {containsForbiddenSymbols} (RCPT_NAME)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_NAME}\" (RCPT_NAME)") @Size(min=3, message="{fieldSize} \"{desc.RCPT_NAME}\" {mustBeNotLess} {min} {symbols3} (RCPT_NAME)") String getRecipientName() {
        return this.recipientName;
    }

    public void setRecipientName(String string) {
        this.recipientName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_OKPO", b=9, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_OKPO}\" (RCPT_OKPO)")
    @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_OKPO}\" {mustContainsOnlyDigits} (RCPT_OKPO)")
    @OrgCodeKeying(fieldName="RCPT_OKPO", groups={d.class}, message="{orgCodeKeyingError} {desc.RCPT_OKPO} ${validatedValue} (RCPT_OKPO)")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_OKPO}\" (RCPT_OKPO)") @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_OKPO}\" {mustContainsOnlyDigits} (RCPT_OKPO)") String getRecipientCode() {
        return this.recipientCode;
    }

    public void setRecipientCode(String string) {
        this.recipientCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_ACCOUNT", b=10, c=false)
    @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ACCOUNT}\" (RCPT_ACCOUNT)")
    @Iban(fieldName="RCPT_ACCOUNT")
    public @NotNull(message="{emptyRequiredField} \"{desc.RCPT_ACCOUNT}\" (RCPT_ACCOUNT)") String getRecipientAccount() {
        return this.recipientAccount;
    }

    public void setRecipientAccount(String string) {
        this.recipientAccount = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_BANK_NAME", b=11, c=false)
    public String getRecipientBankName() {
        return this.recipientBankName;
    }

    public void setRecipientBankName(String string) {
        this.recipientBankName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_BANK_MFO", b=12, c=false)
    public String getRecipientBankCode() {
        return this.recipientBankCode;
    }

    public void setRecipientBankCode(String string) {
        this.recipientBankCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(b=13, c=false)
    @Size(min=3, max=420, message="{fieldSize} \"{desc.PAYMENT_DETAILS}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (PAYMENT_DETAILS)")
    @ForbiddenUnicode(message="{field} \"{desc.PAYMENT_DETAILS}\" {containsForbiddenSymbols} (PAYMENT_DETAILS)")
    public @Size(min=3, max=420, message="{fieldSize} \"{desc.PAYMENT_DETAILS}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (PAYMENT_DETAILS)") String getPaymentDetails() {
        return this.paymentDetails;
    }

    public void setPaymentDetails(String string) {
        this.paymentDetails = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(b=14, c=false)
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(LocalDate localDate) {
        this.valueDate = localDate;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_COUNTRY_CODE", b=15, c=false)
    public String getRecipientCountryCode() {
        return this.recipientCountryCode;
    }

    public void setRecipientCountryCode(String string) {
        this.recipientCountryCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_COUNTRY_CODE", b=16, c=false)
    public String getClientCountryCode() {
        return this.clientCountryCode;
    }

    public void setClientCountryCode(String string) {
        this.clientCountryCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(b=17)
    public String getExpenseItem() {
        return this.expenseItem;
    }

    public void setExpenseItem(String string) {
        this.expenseItem = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_PASSP_SER", b=18)
    public String getRecipientPassportSerial() {
        return this.recipientPassportSerial;
    }

    public void setRecipientPassportSerial(String string) {
        this.recipientPassportSerial = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_PASSP_NUM", b=19)
    @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_PASSP_NUM}\" {mustContainsOnlyDigits} (RCPT_PASSP_NUM)")
    public @Pattern(regexp="\\d+", message="{field} \"{desc.RCPT_PASSP_NUM}\" {mustContainsOnlyDigits} (RCPT_PASSP_NUM)") String getRecipientPassportNumber() {
        return this.recipientPassportNumber;
    }

    public void setRecipientPassportNumber(String string) {
        this.recipientPassportNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_PASSP_SER", b=20)
    public String getClientPassportSerial() {
        return this.clientPassportSerial;
    }

    public void setClientPassportSerial(String string) {
        this.clientPassportSerial = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_PASSP_NUM", b=21)
    public String getClientPassportNumber() {
        return this.clientPassportNumber;
    }

    public void setClientPassportNumber(String string) {
        this.clientPassportNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(b=22)
    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String string) {
        this.priority = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_PASSP_TYPE", b=23)
    public Integer getClientPassportTypeId() {
        return this.clientPassportTypeId;
    }

    public void setClientPassportTypeId(Integer n2) {
        this.clientPassportTypeId = n2;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_PASSP_NAME", b=24)
    public String getClientPassportType() {
        return this.clientPassportType;
    }

    public void setClientPassportType(String string) {
        this.clientPassportType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_PROPRIETARY", b=25)
    public String getClientProprietary() {
        return this.clientProprietary;
    }

    public void setClientProprietary(String string) {
        this.clientProprietary = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_PASSP_TYPE", b=26)
    public Integer getRecipientPassportTypeId() {
        return this.recipientPassportTypeId;
    }

    public void setRecipientPassportTypeId(Integer n2) {
        this.recipientPassportTypeId = n2;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_PASSP_NAME", b=27)
    public String getRecipientPassportType() {
        return this.recipientPassportType;
    }

    public void setRecipientPassportType(String string) {
        this.recipientPassportType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_PROPRIETARY", b=28)
    public String getRecipientProprietary() {
        return this.recipientProprietary;
    }

    public void setRecipientProprietary(String string) {
        this.recipientProprietary = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_POSTCODE", b=29)
    public String getClientPostcode() {
        return this.clientPostcode;
    }

    public void setClientPostcode(String string) {
        this.clientPostcode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_REGION", b=30)
    public String getClientRegion() {
        return this.clientRegion;
    }

    public void setClientRegion(String string) {
        this.clientRegion = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_DISTRICT", b=31)
    public String getClientDistrict() {
        return this.clientDistrict;
    }

    public void setClientDistrict(String string) {
        this.clientDistrict = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_CITY", b=32)
    public String getClientCity() {
        return this.clientCity;
    }

    public void setClientCity(String string) {
        this.clientCity = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_STREET", b=33)
    public String getClientStreet() {
        return this.clientStreet;
    }

    public void setClientStreet(String string) {
        this.clientStreet = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_HOUSE_NUMBER", b=34)
    public String getClientHouseNumber() {
        return this.clientHouseNumber;
    }

    public void setClientHouseNumber(String string) {
        this.clientHouseNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_OFFICE_NUMBER", b=35)
    public String getClientOfficeNumber() {
        return this.clientOfficeNumber;
    }

    public void setClientOfficeNumber(String string) {
        this.clientOfficeNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_COUNTRY_LOCATION", b=36)
    public String getClientCountryLocation() {
        return this.clientCountryLocation;
    }

    public void setClientCountryLocation(String string) {
        this.clientCountryLocation = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_POSTCODE", b=37)
    public String getRecipientPostcode() {
        return this.recipientPostcode;
    }

    public void setRecipientPostcode(String string) {
        this.recipientPostcode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_REGION", b=38)
    public String getRecipientRegion() {
        return this.recipientRegion;
    }

    public void setRecipientRegion(String string) {
        this.recipientRegion = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_DISTRICT", b=39)
    public String getRecipientDistrict() {
        return this.recipientDistrict;
    }

    public void setRecipientDistrict(String string) {
        this.recipientDistrict = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_CITY", b=40)
    public String getRecipientCity() {
        return this.recipientCity;
    }

    public void setRecipientCity(String string) {
        this.recipientCity = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_STREET", b=41)
    public String getRecipientStreet() {
        return this.recipientStreet;
    }

    public void setRecipientStreet(String string) {
        this.recipientStreet = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_HOUSE_NUMBER", b=42)
    public String getRecipientHouseNumber() {
        return this.recipientHouseNumber;
    }

    public void setRecipientHouseNumber(String string) {
        this.recipientHouseNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_OFFICE_NUMBER", b=43)
    public String getRecipientOfficeNumber() {
        return this.recipientOfficeNumber;
    }

    public void setRecipientOfficeNumber(String string) {
        this.recipientOfficeNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_COUNTRY_LOCATION", b=44)
    public String getRecipientCountryLocation() {
        return this.recipientCountryLocation;
    }

    public void setRecipientCountryLocation(String string) {
        this.recipientCountryLocation = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UETR", b=45)
    public String getUniqueTransactionIdentifier() {
        return this.uniqueTransactionIdentifier;
    }

    public void setUniqueTransactionIdentifier(String string) {
        this.uniqueTransactionIdentifier = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_NAME", b=46)
    @ForbiddenUnicode(message="{field} \"{desc.UCLN_NAME}\" {containsForbiddenSymbols} (UCLN_NAME)")
    public String getActualPayerName() {
        return this.actualPayerName;
    }

    public void setActualPayerName(String string) {
        this.actualPayerName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_OKPO", b=47)
    @Size(min=8, max=10, message="{fieldSize} \"{desc.UCLN_OKPO}\" {mustBeNotLess} {min} {andNotGreater} {max} (UCLN_OKPO)")
    @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_OKPO}\" {mustContainsOnlyDigits} (UCLN_OKPO)")
    @OrgCodeKeying(fieldName="UCLN_OKPO", groups={d.class}, message="{orgCodeKeyingError} {desc.UCLN_OKPO} ${validatedValue} (UCLN_OKPO)")
    public @Size(min=8, max=10, message="{fieldSize} \"{desc.UCLN_OKPO}\" {mustBeNotLess} {min} {andNotGreater} {max} (UCLN_OKPO)") @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_OKPO}\" {mustContainsOnlyDigits} (UCLN_OKPO)") String getActualPayerCode() {
        return this.actualPayerCode;
    }

    public void setActualPayerCode(String string) {
        this.actualPayerCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_PASSP_NUM", b=48)
    @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_PASSP_NUM}\" {mustContainsOnlyDigits} (UCLN_PASSP_NUM)")
    public @Pattern(regexp="\\d+", message="{field} \"{desc.UCLN_PASSP_NUM}\" {mustContainsOnlyDigits} (UCLN_PASSP_NUM)") String getActualPayerPassportNumber() {
        return this.actualPayerPassportNumber;
    }

    public void setActualPayerPassportNumber(String string) {
        this.actualPayerPassportNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_PASSP_SER", b=49)
    public String getActualPayerPassportSerial() {
        return this.actualPayerPassportSerial;
    }

    public void setActualPayerPassportSerial(String string) {
        this.actualPayerPassportSerial = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_PASSP_TYPE", b=50)
    public Integer getActualPayerPassportTypeId() {
        return this.actualPayerPassportTypeId;
    }

    public void setActualPayerPassportTypeId(Integer n2) {
        this.actualPayerPassportTypeId = n2;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_PASSP_NAME", b=51)
    public String getActualPayerPassportType() {
        return this.actualPayerPassportType;
    }

    public void setActualPayerPassportType(String string) {
        this.actualPayerPassportType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_PROPRIETARY", b=52)
    public String getActualPayerProprietary() {
        return this.actualPayerProprietary;
    }

    public void setActualPayerProprietary(String string) {
        this.actualPayerProprietary = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_POSTCODE", b=53)
    public String getActualPayerPostcode() {
        return this.actualPayerPostcode;
    }

    public void setActualPayerPostcode(String string) {
        this.actualPayerPostcode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_REGION", b=54)
    public String getActualPayerRegion() {
        return this.actualPayerRegion;
    }

    public void setActualPayerRegion(String string) {
        this.actualPayerRegion = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_DISTRICT", b=55)
    public String getActualPayerDistrict() {
        return this.actualPayerDistrict;
    }

    public void setActualPayerDistrict(String string) {
        this.actualPayerDistrict = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_CITY", b=56)
    public String getActualPayerCity() {
        return this.actualPayerCity;
    }

    public void setActualPayerCity(String string) {
        this.actualPayerCity = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_STREET", b=57)
    public String getActualPayerStreet() {
        return this.actualPayerStreet;
    }

    public void setActualPayerStreet(String string) {
        this.actualPayerStreet = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_HOUSE_NUMBER", b=58)
    public String getActualPayerHouseNumber() {
        return this.actualPayerHouseNumber;
    }

    public void setActualPayerHouseNumber(String string) {
        this.actualPayerHouseNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_OFFICE_NUMBER", b=59)
    public String getActualPayerOfficeNumber() {
        return this.actualPayerOfficeNumber;
    }

    public void setActualPayerOfficeNumber(String string) {
        this.actualPayerOfficeNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_COUNTRY_LOCATION", b=60)
    public String getActualPayerCountryLocation() {
        return this.actualPayerCountryLocation;
    }

    public void setActualPayerCountryLocation(String string) {
        this.actualPayerCountryLocation = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_COUNTRY_CODE", b=61)
    public String getActualPayerCountryCode() {
        return this.actualPayerCountryCode;
    }

    public void setActualPayerCountryCode(String string) {
        this.actualPayerCountryCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_NAME", b=62)
    @ForbiddenUnicode(message="{field} \"{desc.URCPT_NAME}\" {containsForbiddenSymbols} (URCPT_NAME)")
    public String getActualRecipientName() {
        return this.actualRecipientName;
    }

    public void setActualRecipientName(String string) {
        this.actualRecipientName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_OKPO", b=63)
    @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_OKPO}\" {mustContainsOnlyDigits} (URCPT_OKPO)")
    @OrgCodeKeying(fieldName="URCPT_OKPO", groups={d.class}, message="{orgCodeKeyingError} {desc.URCPT_OKPO} ${validatedValue} (URCPT_OKPO)")
    public @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_OKPO}\" {mustContainsOnlyDigits} (URCPT_OKPO)") String getActualRecipientCode() {
        return this.actualRecipientCode;
    }

    public void setActualRecipientCode(String string) {
        this.actualRecipientCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_PASSP_NUM", b=64)
    @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_PASSP_NUM}\" {mustContainsOnlyDigits} (URCPT_PASSP_NUM)")
    public @Pattern(regexp="\\d+", message="{field} \"{desc.URCPT_PASSP_NUM}\" {mustContainsOnlyDigits} (URCPT_PASSP_NUM)") String getActualRecipientPassportNumber() {
        return this.actualRecipientPassportNumber;
    }

    public void setActualRecipientPassportNumber(String string) {
        this.actualRecipientPassportNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_PASSP_SER", b=65)
    public String getActualRecipientPassportSerial() {
        return this.actualRecipientPassportSerial;
    }

    public void setActualRecipientPassportSerial(String string) {
        this.actualRecipientPassportSerial = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_PASSP_TYPE", b=66)
    public Integer getActualRecipientPassportTypeId() {
        return this.actualRecipientPassportTypeId;
    }

    public void setActualRecipientPassportTypeId(Integer n2) {
        this.actualRecipientPassportTypeId = n2;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_PASSP_NAME", b=67)
    public String getActualRecipientPassportType() {
        return this.actualRecipientPassportType;
    }

    public void setActualRecipientPassportType(String string) {
        this.actualRecipientPassportType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_PROPRIETARY", b=68)
    public String getActualRecipientProprietary() {
        return this.actualRecipientProprietary;
    }

    public void setActualRecipientProprietary(String string) {
        this.actualRecipientProprietary = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_POSTCODE", b=69)
    public String getActualRecipientPostcode() {
        return this.actualRecipientPostcode;
    }

    public void setActualRecipientPostcode(String string) {
        this.actualRecipientPostcode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_REGION", b=70)
    public String getActualRecipientRegion() {
        return this.actualRecipientRegion;
    }

    public void setActualRecipientRegion(String string) {
        this.actualRecipientRegion = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_DISTRICT", b=71)
    public String getActualRecipientDistrict() {
        return this.actualRecipientDistrict;
    }

    public void setActualRecipientDistrict(String string) {
        this.actualRecipientDistrict = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_CITY", b=72)
    public String getActualRecipientCity() {
        return this.actualRecipientCity;
    }

    public void setActualRecipientCity(String string) {
        this.actualRecipientCity = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_STREET", b=73)
    public String getActualRecipientStreet() {
        return this.actualRecipientStreet;
    }

    public void setActualRecipientStreet(String string) {
        this.actualRecipientStreet = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_HOUSE_NUMBER", b=74)
    public String getActualRecipientHouseNumber() {
        return this.actualRecipientHouseNumber;
    }

    public void setActualRecipientHouseNumber(String string) {
        this.actualRecipientHouseNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_OFFICE_NUMBER", b=75)
    public String getActualRecipientOfficeNumber() {
        return this.actualRecipientOfficeNumber;
    }

    public void setActualRecipientOfficeNumber(String string) {
        this.actualRecipientOfficeNumber = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_COUNTRY_LOCATION", b=76)
    public String getActualRecipientCountryLocation() {
        return this.actualRecipientCountryLocation;
    }

    public void setActualRecipientCountryLocation(String string) {
        this.actualRecipientCountryLocation = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_COUNTRY_CODE", b=77)
    public String getActualRecipientCountryCode() {
        return this.actualRecipientCountryCode;
    }

    public void setActualRecipientCountryCode(String string) {
        this.actualRecipientCountryCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_BANK_TYPE", b=78)
    public String getRecipientBankType() {
        return this.recipientBankType;
    }

    public void setRecipientBankType(String string) {
        this.recipientBankType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_BANK_ASP_MFO", b=79)
    public String getRecipientAspBankCode() {
        return this.recipientAspBankCode;
    }

    public void setRecipientAspBankCode(String string) {
        this.recipientAspBankCode = string;
    }

    public BudgetPaymentTemplateType getBudgetPaymentTemplateType() {
        return this.budgetPaymentTemplateType;
    }

    public void setBudgetPaymentTemplateType(BudgetPaymentTemplateType budgetPaymentTemplateType) {
        this.budgetPaymentTemplateType = budgetPaymentTemplateType;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_TEMPLATE_TYPE", b=80)
    @JsonIgnore
    public Integer getBudgetPaymentTemplateTypeCode() {
        if (this.budgetPaymentTemplateType == null) {
            return null;
        }
        return this.budgetPaymentTemplateType.getCode();
    }

    public void setBudgetPaymentTemplateTypeCode(Integer n2) {
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_TAXCODE", b=81)
    public String getBudgetPaymentTaxCode() {
        return this.budgetPaymentTaxCode;
    }

    public void setBudgetPaymentTaxCode(String string) {
        this.budgetPaymentTaxCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_ADD_INFO", b=82)
    @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_ADD_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_ADD_INFO)")
    @ForbiddenUnicode(message="{field} \"{desc.BP_ADD_INFO}\" {containsForbiddenSymbols} (BP_ADD_INFO)")
    public @Size(min=3, max=140, message="{fieldSize} \"{desc.BP_ADD_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (BP_ADD_INFO)") String getBudgetPaymentAdditionalInfo() {
        return this.budgetPaymentAdditionalInfo;
    }

    public void setBudgetPaymentAdditionalInfo(String string) {
        this.budgetPaymentAdditionalInfo = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_INCOME_CODE", b=83)
    public String getBudgetPaymentIncomeCode() {
        return this.budgetPaymentIncomeCode;
    }

    public void setBudgetPaymentIncomeCode(String string) {
        this.budgetPaymentIncomeCode = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_ACCOUNT", b=84)
    @Iban(fieldName="BP_ACCOUNT")
    public String getBudgetPaymentAccount() {
        return this.budgetPaymentAccount;
    }

    public void setBudgetPaymentAccount(String string) {
        this.budgetPaymentAccount = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="BP_TAXMSG", b=85)
    @Size(max=140, message="{fieldSize} \"{desc.BP_TAXMSG}\" {mustBeNotGreater} {max} {symbols5} (BP_TAXMSG)")
    @ForbiddenUnicode(message="{field} \"{desc.BP_TAXMSG}\" {containsForbiddenSymbols} (BP_TAXMSG)")
    public @Size(max=140, message="{fieldSize} \"{desc.BP_TAXMSG}\" {mustBeNotGreater} {max} {symbols5} (BP_TAXMSG)") String getBudgetPaymentTaxMsg() {
        return this.budgetPaymentTaxMsg;
    }

    public void setBudgetPaymentTaxMsg(String string) {
        this.budgetPaymentTaxMsg = string;
    }

    public List<BpSingleAccountRow> getBpSingleAccountRows() {
        return this.bpSingleAccountRows;
    }

    public void setBpSingleAccountRows(List<BpSingleAccountRow> list) {
        this.bpSingleAccountRows = list;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="ADDITIONAL_INFO", b=86)
    @Size(min=3, max=140, message="{fieldSize} \"{desc.ADDITIONAL_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (ADDITIONAL_INFO)")
    @ForbiddenUnicode(message="{field} \"{desc.ADDITIONAL_INFO}\" {containsForbiddenSymbols} (ADDITIONAL_INFO)")
    public @Size(min=3, max=140, message="{fieldSize} \"{desc.ADDITIONAL_INFO}\" {mustBeNotLess} {min} {andNotGreater} {max} {symbols5} (ADDITIONAL_INFO)") String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String string) {
        this.additionalInfo = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_EMPLOYEE_FIO", b=87)
    @Size(max=140, message="{fieldSize} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)")
    @ForbiddenUnicode(message="{field} \"{desc.CLN_EMPLOYEE_FIO}\" {containsForbiddenSymbols} (CLN_EMPLOYEE_FIO)")
    public @Size(max=140, message="{fieldSize} \"{desc.CLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (CLN_EMPLOYEE_FIO)") String getClnEmployeeFio() {
        return this.clnEmployeeFio;
    }

    public void setClnEmployeeFio(String string) {
        this.clnEmployeeFio = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_EMPLOYEE_PHONE", b=88)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (CLN_EMPLOYEE_PHONE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (CLN_EMPLOYEE_PHONE)") String getClnEmployeePhone() {
        return this.clnEmployeePhone;
    }

    public void setClnEmployeePhone(String string) {
        this.clnEmployeePhone = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_EMPLOYEE_MOBILE", b=89)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (CLN_EMPLOYEE_MOBILE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (CLN_EMPLOYEE_MOBILE)") String getClnEmployeeMobile() {
        return this.clnEmployeeMobile;
    }

    public void setClnEmployeeMobile(String string) {
        this.clnEmployeeMobile = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="CLN_EMPLOYEE_EMAIL", b=90)
    @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (CLN_EMPLOYEE_EMAIL)")
    public @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (CLN_EMPLOYEE_EMAIL)") String getClnEmployeeEmail() {
        return this.clnEmployeeEmail;
    }

    public void setClnEmployeeEmail(String string) {
        this.clnEmployeeEmail = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_EMPLOYEE_FIO", b=91)
    @Size(max=140, message="{fieldSize} \"{desc.RCPT_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (RCPT_EMPLOYEE_FIO)")
    @ForbiddenUnicode(message="{field} \"{desc.RCPT_EMPLOYEE_FIO}\" {containsForbiddenSymbols} (RCPT_EMPLOYEE_FIO)")
    public @Size(max=140, message="{fieldSize} \"{desc.RCPT_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (RCPT_EMPLOYEE_FIO)") String getRcptEmployeeFio() {
        return this.rcptEmployeeFio;
    }

    public void setRcptEmployeeFio(String string) {
        this.rcptEmployeeFio = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_EMPLOYEE_PHONE", b=92)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (RCPT_EMPLOYEE_PHONE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (RCPT_EMPLOYEE_PHONE)") String getRcptEmployeePhone() {
        return this.rcptEmployeePhone;
    }

    public void setRcptEmployeePhone(String string) {
        this.rcptEmployeePhone = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_EMPLOYEE_MOBILE", b=93)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (RCPT_EMPLOYEE_MOBILE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (RCPT_EMPLOYEE_MOBILE)") String getRcptEmployeeMobile() {
        return this.rcptEmployeeMobile;
    }

    public void setRcptEmployeeMobile(String string) {
        this.rcptEmployeeMobile = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_EMPLOYEE_EMAIL", b=94)
    @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (RCPT_EMPLOYEE_EMAIL)")
    public @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (RCPT_EMPLOYEE_EMAIL)") String getRcptEmployeeEmail() {
        return this.rcptEmployeeEmail;
    }

    public void setRcptEmployeeEmail(String string) {
        this.rcptEmployeeEmail = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_EMPLOYEE_FIO", b=95)
    @Size(max=140, message="{fieldSize} \"{desc.UCLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (UCLN_EMPLOYEE_FIO)")
    @ForbiddenUnicode(message="{field} \"{desc.UCLN_EMPLOYEE_FIO}\" {containsForbiddenSymbols} (UCLN_EMPLOYEE_FIO)")
    public @Size(max=140, message="{fieldSize} \"{desc.UCLN_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (UCLN_EMPLOYEE_FIO)") String getUclnEmployeeFio() {
        return this.uclnEmployeeFio;
    }

    public void setUclnEmployeeFio(String string) {
        this.uclnEmployeeFio = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_EMPLOYEE_PHONE", b=96)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (UCLN_EMPLOYEE_PHONE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (UCLN_EMPLOYEE_PHONE)") String getUclnEmployeePhone() {
        return this.uclnEmployeePhone;
    }

    public void setUclnEmployeePhone(String string) {
        this.uclnEmployeePhone = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_EMPLOYEE_MOBILE", b=97)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (UCLN_EMPLOYEE_MOBILE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (UCLN_EMPLOYEE_MOBILE)") String getUclnEmployeeMobile() {
        return this.uclnEmployeeMobile;
    }

    public void setUclnEmployeeMobile(String string) {
        this.uclnEmployeeMobile = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="UCLN_EMPLOYEE_EMAIL", b=98)
    @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (UCLN_EMPLOYEE_EMAIL)")
    public @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (UCLN_EMPLOYEE_EMAIL)") String getUclnEmployeeEmail() {
        return this.uclnEmployeeEmail;
    }

    public void setUclnEmployeeEmail(String string) {
        this.uclnEmployeeEmail = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_EMPLOYEE_FIO", b=99)
    @Size(max=140, message="{fieldSize} \"{desc.URCPT_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (URCPT_EMPLOYEE_FIO)")
    @ForbiddenUnicode(message="{field} \"{desc.URCPT_EMPLOYEE_FIO}\" {containsForbiddenSymbols} (URCPT_EMPLOYEE_FIO)")
    public @Size(max=140, message="{fieldSize} \"{desc.URCPT_EMPLOYEE_FIO}\" {mustBeNotGreater} {max} {symbols5} (URCPT_EMPLOYEE_FIO)") String getUrcptEmployeeFio() {
        return this.urcptEmployeeFio;
    }

    public void setUrcptEmployeeFio(String string) {
        this.urcptEmployeeFio = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_EMPLOYEE_PHONE", b=100)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (URCPT_EMPLOYEE_PHONE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (URCPT_EMPLOYEE_PHONE)") String getUrcptEmployeePhone() {
        return this.urcptEmployeePhone;
    }

    public void setUrcptEmployeePhone(String string) {
        this.urcptEmployeePhone = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_EMPLOYEE_MOBILE", b=101)
    @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (URCPT_EMPLOYEE_MOBILE)")
    public @Pattern(regexp="^(\\+\\d{1,3}( )?)?((\\(\\d{1,3}\\))|\\d{1,3})[- .]?\\d{3,4}[- .]?\\d{4}$", message="{phoneNumberIsNotCorrect} (URCPT_EMPLOYEE_MOBILE)") String getUrcptEmployeeMobile() {
        return this.urcptEmployeeMobile;
    }

    public void setUrcptEmployeeMobile(String string) {
        this.urcptEmployeeMobile = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="URCPT_EMPLOYEE_EMAIL", b=102)
    @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (URCPT_EMPLOYEE_EMAIL)")
    public @Email(regexp="^(?=.{1,64}@)[A-Za-z0-9!#$%&'*+/=?^_`{|}~.-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$", message="{emailIsNotCorrect} (URCPT_EMPLOYEE_EMAIL)") String getUrcptEmployeeEmail() {
        return this.urcptEmployeeEmail;
    }

    public void setUrcptEmployeeEmail(String string) {
        this.urcptEmployeeEmail = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="INSTANT_FLAG", b=106)
    public String getInstantFlag() {
        return this.instantFlag;
    }

    public void setInstantFlag(String string) {
        this.instantFlag = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="COMMISSION_PAYER", b=107)
    public String getCommissionPayer() {
        return this.commissionPayer;
    }

    public void setCommissionPayer(String string) {
        this.commissionPayer = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="COMMISSION_AMOUNT", b=108)
    public BigDecimal getCommissionAmount() {
        return this.commissionAmount;
    }

    public void setCommissionAmount(BigDecimal bigDecimal) {
        this.commissionAmount = bigDecimal;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="COMMISSION_BNK_NAME", b=109)
    public String getCommissionBnkName() {
        return this.commissionBnkName;
    }

    public void setCommissionBnkName(String string) {
        this.commissionBnkName = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="COMMISSION_BNK_MFO", b=110)
    public String getCommissionBnkMfo() {
        return this.commissionBnkMfo;
    }

    public void setCommissionBnkMfo(String string) {
        this.commissionBnkMfo = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="COMMISSION_TYPE", b=111)
    public String getCommissionType() {
        return this.commissionType;
    }

    public void setCommissionType(String string) {
        this.commissionType = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="RCPT_REFERENCE_INFO", b=113)
    public String getRcptReferenceInfo() {
        return this.rcptReferenceInfo;
    }

    public void setRcptReferenceInfo(String string) {
        this.rcptReferenceInfo = string;
    }

    @ua.com.dbosoft.autoclient.format.ibank2.d(a="INFO_FOR_NEXT_AGENT", b=112)
    public String getInfoForNextAgent() {
        return this.infoForNextAgent;
    }

    public void setInfoForNextAgent(String string) {
        this.infoForNextAgent = string;
    }

    @Override
    @JsonIgnore
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public String toIBank2(boolean bl) {
        return UA_PAYMENT_WRITER.a(this, bl);
    }

    @Override
    @JsonIgnore
    public String getType() {
        return "ua_payment";
    }

    @Override
    @JsonIgnore
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public void setStatusCode(Integer n2) {
        this.statusCode = n2;
    }
}

