/*
 * Decompiled with CFR 0.152.
 */
package ua.com.dbosoft.autoclient.app.ua_payment;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.lang.invoke.LambdaMetafactory;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.hibernate.validator.messageinterpolation.ResourceBundleMessageInterpolator;
import org.hibernate.validator.resourceloading.AggregateResourceBundleLocator;
import org.hibernate.validator.spi.resourceloading.ResourceBundleLocator;
import ua.com.dbosoft.autoclient.app.RequestSender;
import ua.com.dbosoft.autoclient.app.ValidatorFactoryRegistry;
import ua.com.dbosoft.autoclient.app.account.Account;
import ua.com.dbosoft.autoclient.app.bank.ua_swift.UaSwift;
import ua.com.dbosoft.autoclient.app.country.Country;
import ua.com.dbosoft.autoclient.app.dao.RepositoryManager;
import ua.com.dbosoft.autoclient.app.id_card_type.IdCardType;
import ua.com.dbosoft.autoclient.app.sys_prop.b;
import ua.com.dbosoft.autoclient.app.ua_payment.BpSingleAccountRow;
import ua.com.dbosoft.autoclient.app.ua_payment.BudgetPaymentTemplateType;
import ua.com.dbosoft.autoclient.app.ua_payment.UaPayment;
import ua.com.dbosoft.autoclient.app.ua_payment.e;
import ua.com.dbosoft.autoclient.app.validation.c;

public class UaPaymentImporter {
    private static final Pattern a = Pattern.compile("^[\u0410\u0411\u0412\u0413\u0490\u0414\u0415\u0404\u0416\u0417\u0418\u0406\u0407\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0422\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042e\u042f\u0430\u0431\u0432\u0433\u0491\u0434\u0435\u0454\u0436\u0437\u0438\u0456\u0457\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0442\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044e\u044f]{2}$");
    private final RepositoryManager b;
    private final RequestSender c;
    private final Validator d;

    public UaPaymentImporter(RepositoryManager object, RequestSender object2, ValidatorFactoryRegistry validatorFactoryRegistry) {
        this.b = object;
        this.c = object2;
        object = validatorFactoryRegistry;
        object2 = UaPaymentImporter.class.getCanonicalName();
        validatorFactoryRegistry = ((ValidatorFactoryRegistry)object).a((String)object2);
        if (validatorFactoryRegistry == null) {
            validatorFactoryRegistry = new AggregateResourceBundleLocator(Arrays.asList("ua/com/dbosoft/autoclient/app/account/account", "ua/com/dbosoft/autoclient/app/ua_payment/fieldDescription", "ua/com/dbosoft/autoclient/app/ua_payment/validationMessages"));
            validatorFactoryRegistry = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ResourceBundleMessageInterpolator((ResourceBundleLocator)validatorFactoryRegistry)).buildValidatorFactory();
            ((ValidatorFactoryRegistry)object).a((String)object2, (ValidatorFactory)validatorFactoryRegistry);
        }
        this.d = validatorFactoryRegistry.getValidator();
    }

    /*
     * Unable to fully structure code
     */
    public void importDocument(UaPayment var1_1) {
        block129: {
            block128: {
                block127: {
                    block126: {
                        var4_2 = var1_1;
                        var3_3 = this;
                        var3_3.a((UaPayment)var4_2, new String[]{"amount", "clientCode", "clientAccount", "recipientName", "recipientCode", "recipientAccount", "paymentDetails"});
                        var4_2 = var1_1;
                        var3_3 = this;
                        if (var4_2.getNumber() == null || var4_2.getDate() == null) {
                            var5_4 = var3_3.c.a("ua_payment");
                            if (var4_2.getNumber() == null) {
                                var4_2.setNumber(var5_4.getNumber());
                            }
                            if (var4_2.getDate() == null) {
                                var4_2.setDate(var5_4.getDate());
                            }
                        }
                        v0 = var1_1;
                        v0.setAmount(v0.getAmount().setScale(2, RoundingMode.DOWN));
                        var4_2 = var1_1;
                        var3_3 = this;
                        var5_4 = var4_2.getValueDate();
                        var6_7 = var3_3.b.o();
                        if (var5_4 != null && (var5_4.isBefore(var4_2.getDate()) || var5_4.isEqual(var4_2.getDate()) && var6_7.a("ua_payment.value_date.check_doc_date", false))) {
                            var4_2.setValueDate(null);
                        }
                        var2_8 = this.b.e().a();
                        var1_1.setClientCode(var2_8.getCode());
                        var4_2 = var1_1;
                        var3_3 = this;
                        var5_4 = var4_2.getClientCode();
                        if (var5_4.length() == 8 && !var5_4.equals("00000000")) {
                            var7_11 = var4_2;
                            var6_7 = var3_3;
                            var7_11.setClientProprietary("USRC");
                            UaPaymentImporter.a((UaPayment)var7_11);
                            UaPaymentImporter.b((UaPayment)var7_11);
                        } else if (var5_4.length() == 9) {
                            var7_11 = var4_2;
                            var6_7 = var3_3;
                            if ("000000000".equals(var7_11.getClientCode())) {
                                var7_11.setClientProprietary("NA");
                            } else {
                                var7_11.setClientProprietary("TRAN");
                            }
                            var8_12 = var6_7.b.e().a();
                            var7_11.setClientPostcode(var8_12.getPostcode());
                            var7_11.setClientRegion(UaPaymentImporter.a(var8_12.getPkiState(), 35));
                            var7_11.setClientDistrict(var8_12.getClientDistrict());
                            var7_11.setClientCity(UaPaymentImporter.a(var8_12.getPkiCity(), 35));
                            var7_11.setClientStreet(UaPaymentImporter.a(var8_12.getPkiAddress(), 70));
                            var7_11.setClientHouseNumber(var8_12.getClnHouseNumber());
                            var7_11.setClientOfficeNumber(var8_12.getClnOfficeNumber());
                            var7_11.setClientCountryLocation(var8_12.getClientCountryLocation());
                            UaPaymentImporter.a((UaPayment)var7_11);
                        } else if (var5_4.length() == 10) {
                            var7_11 = var4_2;
                            var6_7 = var3_3;
                            UaPaymentImporter.b((UaPayment)var7_11);
                            if ("0000000000".equals(var7_11.getClientCode())) {
                                var8_12 = var6_7.b.e().a();
                                var7_11.setClientCountryCode(var8_12.getCountryCode());
                                var9_23 = var8_12.getPassportTypeId();
                                var7_11.setClientProprietary(null);
                                if (var9_23 == 0) {
                                    var7_11.setClientPassportTypeId(null);
                                    var7_11.setClientPassportType(null);
                                } else {
                                    var10_34 = var6_7.b.h();
                                    var11_41 = var10_34.a(var9_23);
                                    if (var11_41 == null) {
                                        throw new RuntimeException(String.format(UaPaymentImporter.c("idCardTypeNotFound"), new Object[]{var9_23}));
                                    }
                                    if ("PSPT".equals(var11_41.getProprietary()) || "OT".equals(var11_41.getProprietary())) {
                                        var7_11.setClientProprietary(var11_41.getProprietary());
                                    }
                                    var7_11.setClientPassportTypeId(var8_12.getPassportTypeId());
                                    var7_11.setClientPassportType(var11_41.getNameUa());
                                    super.a(var11_41.getFormat(), var8_12.getPassportNumber(), var8_12.getPassportSerial());
                                    var7_11.setClientPassportNumber(var8_12.getPassportNumber());
                                    var7_11.setClientPassportSerial(var8_12.getPassportSerial());
                                }
                            } else {
                                var7_11.setClientProprietary("RNRCT");
                                UaPaymentImporter.a((UaPayment)var7_11);
                            }
                        } else {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldHasIncorrectValue"), new Object[]{UaPaymentImporter.d("CLN_OKPO"), var5_4, "CLN_OKPO"}));
                        }
                        var1_1.setClientName(var2_8.getName());
                        var4_2 = var2_8;
                        var3_3 = var1_1;
                        if (ua.com.dbosoft.autoclient.app.client.c.a.equals((Object)var4_2.getType()) && !"0000000000".equals(var3_3.getClientCode())) {
                            var3_3.setClientCountryCode(var4_2.getCountryCode());
                        } else {
                            var3_3.setClientCountryCode(null);
                        }
                        var4_2 = var1_1;
                        var3_3 = this;
                        var5_4 = var4_2.getClientAccount();
                        if (var5_4.length() != 29) break block126;
                        var9_24 = var5_4;
                        var8_12 = var3_3;
                        var10_34 = var8_12.b.a();
                        var11_41 = var10_34.a((String)var9_24).stream().filter((Predicate<Account>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, c(ua.com.dbosoft.autoclient.app.account.Account ), (Lua/com/dbosoft/autoclient/app/account/Account;)Z)()).findAny();
                        if (!var11_41.isPresent()) ** GOTO lbl-1000
                        super.a(var11_41.get());
                        switch (e.a[var11_41.get().getType().ordinal()]) {
                            case 1: {
                                if (!super.a()) {
                                    throw new RuntimeException(super.a(false, (String)var9_24));
                                }
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                throw new RuntimeException(String.format(UaPaymentImporter.c("accountIsMonetaryCoverage"), new Object[]{"(CLN_ACCOUNT)"}));
                            }
                            default: lbl-1000:
                            // 2 sources

                            {
                                v1 = var8_12;
                                throw new RuntimeException(super.a(super.a(), (String)var9_24));
                            }
                        }
                        var4_2.setClientBankCode(var5_4.substring(4, 10));
                        super.a((UaPayment)var4_2, "CLN_ACCOUNT");
                        break block127;
                    }
                    if (var4_2.getClientBankCode() == null) {
                        var6_7 = String.format(UaPaymentImporter.c("bankCodeRequiredIfAccIsNotIban"), new Object[]{"CLN_BANK_MFO", "CLN_ACCOUNT"});
                        throw new RuntimeException((String)var6_7);
                    }
                    var10_34 = var4_2.getClientBankCode();
                    var9_24 = var5_4;
                    var8_12 = var3_3;
                    var11_41 = var8_12.b.a();
                    var2_8 = var11_41.b((String)var9_24).stream().filter((Predicate<Account>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, a(java.lang.String ua.com.dbosoft.autoclient.app.account.Account ), (Lua/com/dbosoft/autoclient/app/account/Account;)Z)((String)var10_34)).findAny();
                    if (!var2_8.isPresent()) {
                        v2 = var8_12;
                        throw new RuntimeException(super.a(super.a(), (String)var9_24, (String)var10_34));
                    }
                    var6_7 = (Account)var2_8.get();
                    var11_41 = var4_2.getClientBankCode();
                    var10_34 = var5_4;
                    var9_24 = var6_7;
                    var8_12 = var3_3;
                    if (ua.com.dbosoft.autoclient.app.account.c.c.equals((Object)var9_24.getType())) {
                        throw new RuntimeException(String.format(UaPaymentImporter.c("accountIsMonetaryCoverage"), new Object[]{"(CLN_ACCOUNT)"}));
                    }
                    if (ua.com.dbosoft.autoclient.app.account.c.b.equals((Object)var9_24.getType()) && !super.a()) {
                        throw new RuntimeException(super.a(false, (String)var10_34, (String)var11_41));
                    }
                    var7_11 = var6_7.getIban();
                    if (var7_11 != null) {
                        var4_2.setClientAccount((String)var7_11);
                    }
                    super.a((Account)var6_7);
                    super.a((UaPayment)var4_2, "CLN_BANK_MFO");
                }
                v3 = var1_1;
                v3.setRecipientName(UaPaymentImporter.a(v3.getRecipientName(), 140));
                v4 = var1_1;
                v4.setRecipientBankCode(v4.getRecipientAccount().substring(4, 10));
                var4_2 = var1_1;
                var3_3 = this;
                var5_4 = var3_3.b.p().a(var4_2.getRecipientBankCode());
                if (var5_4 == null) {
                    throw new RuntimeException(String.format(UaPaymentImporter.c("uaSwiftNotFound"), new Object[]{var4_2.getRecipientBankCode(), "RCPT_ACCOUNT"}));
                }
                var4_2.setRecipientBankName(var5_4.getName());
                var4_2 = var1_1;
                var3_3 = this;
                var5_4 = var4_2.getRecipientCode();
                if (var5_4.length() == 8 && !var5_4.equals("00000000")) {
                    var7_11 = var4_2;
                    var6_7 = var3_3;
                    var7_11.setRecipientProprietary("USRC");
                    UaPaymentImporter.c((UaPayment)var7_11);
                    UaPaymentImporter.d((UaPayment)var7_11);
                    super.a(var7_11.getRecipientCountryCode(), "RCPT_COUNTRY_CODE");
                } else if (var5_4.length() == 9) {
                    var7_11 = var4_2;
                    var6_7 = var3_3;
                    if ("000000000".equals(var7_11.getRecipientCode())) {
                        var7_11.setRecipientProprietary("NA");
                    } else {
                        var7_11.setRecipientProprietary("TRAN");
                    }
                    var8_12 = var7_11;
                    if (var8_12.getRecipientPostcode() != null || var8_12.getRecipientRegion() != null || var8_12.getRecipientDistrict() != null || var8_12.getRecipientCity() != null || var8_12.getRecipientStreet() != null || var8_12.getRecipientHouseNumber() != null || var8_12.getRecipientOfficeNumber() != null || var8_12.getRecipientCountryLocation() != null) {
                        var9_24 = var7_11;
                        var8_12 = var6_7;
                        if (var9_24.getRecipientCity() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("RCPT_CITY"), "RCPT_CITY"}));
                        }
                        if (var9_24.getRecipientCountryLocation() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("RCPT_COUNTRY_LOCATION"), "RCPT_COUNTRY_LOCATION"}));
                        }
                        if (var9_24.getRecipientHouseNumber() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("houseNumberIsRequired"), new Object[]{"RCPT_HOUSE_NUMBER"}));
                        }
                    }
                    UaPaymentImporter.c((UaPayment)var7_11);
                    super.a(var7_11.getRecipientCountryCode(), "RCPT_COUNTRY_CODE");
                    super.a(var7_11.getRecipientCountryLocation(), "RCPT_COUNTRY_LOCATION");
                } else if (var5_4.equals("0000000000")) {
                    var7_11 = var4_2;
                    var6_7 = var3_3;
                    var8_12 = var7_11.getRecipientPassportTypeId();
                    super.a((Integer)var8_12, "RCPT_OKPO", "RCPT_PASSP_TYPE");
                    var9_24 = super.a((Integer)var8_12);
                    if ("PSPT".equals(var9_24.getProprietary()) || "OT".equals(var9_24.getProprietary())) {
                        var7_11.setRecipientProprietary(var9_24.getProprietary());
                    }
                    var7_11.setRecipientPassportType(var9_24.getNameUa());
                    super.a(var9_24.getFormat(), var7_11.getRecipientPassportNumber(), var7_11.getRecipientPassportSerial());
                    super.a((UaPayment)var7_11, new String[]{"recipientPassportNumber"});
                    UaPaymentImporter.d((UaPayment)var7_11);
                    var7_11.setRecipientCountryCode(null);
                } else if (var5_4.length() == 10) {
                    var7_11 = var4_2;
                    var6_7 = var3_3;
                    var7_11.setRecipientProprietary("RNRCT");
                    UaPaymentImporter.c((UaPayment)var7_11);
                    UaPaymentImporter.d((UaPayment)var7_11);
                    super.a(var7_11.getRecipientCountryCode(), "RCPT_COUNTRY_CODE");
                } else if (var5_4.equals("99999")) {
                    var7_11 = var4_2;
                    var6_7 = var3_3;
                    var7_11.setRecipientProprietary("UNKN");
                    UaPaymentImporter.c((UaPayment)var7_11);
                    UaPaymentImporter.d((UaPayment)var7_11);
                    super.a(var7_11.getRecipientCountryCode(), "RCPT_COUNTRY_CODE");
                } else {
                    throw new RuntimeException(String.format(UaPaymentImporter.c("fieldHasIncorrectValue"), new Object[]{UaPaymentImporter.d("RCPT_OKPO"), var5_4, "RCPT_OKPO"}));
                }
                var4_2 = var1_1;
                var3_3 = this;
                v5 = var4_2;
                v5.setActualPayerName(UaPaymentImporter.a(v5.getActualPayerName(), 140));
                if (var4_2.getActualPayerName() == null) {
                    if (var4_2.getActualPayerCode() != null) {
                        super.b("UCLN_OKPO", "UCLN_NAME");
                    }
                    var4_2.setActualPayerCountryCode(null);
                } else if (var4_2.getActualPayerCode() == null) {
                    super.b("UCLN_NAME", "UCLN_OKPO");
                }
                var6_7 = var4_2;
                var5_4 = var3_3;
                var7_11 = var6_7.getActualPayerCode();
                if (var7_11 != null) {
                    super.a((UaPayment)var6_7, new String[]{"actualPayerCode", "actualPayerName"});
                    if (var7_11.length() == 8 && !var7_11.equals("00000000")) {
                        var9_24 = var6_7;
                        var8_12 = var5_4;
                        var9_24.setActualPayerProprietary("USRC");
                        UaPaymentImporter.e(var9_24);
                        UaPaymentImporter.f(var9_24);
                    } else if (var7_11.length() == 9) {
                        var9_24 = var6_7;
                        var8_12 = var5_4;
                        if ("000000000".equals(var9_24.getActualPayerCode())) {
                            var9_24.setActualPayerProprietary("NA");
                        } else {
                            var9_24.setActualPayerProprietary("TRAN");
                        }
                        var11_41 = var9_24;
                        var10_34 = var8_12;
                        if (var11_41.getActualPayerCity() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("UCLN_CITY"), "UCLN_CITY"}));
                        }
                        if (var11_41.getActualPayerCountryLocation() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("UCLN_COUNTRY_LOCATION"), "UCLN_COUNTRY_LOCATION"}));
                        }
                        if (var11_41.getActualPayerHouseNumber() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("houseNumberIsRequired"), new Object[]{"UCLN_HOUSE_NUMBER"}));
                        }
                        super.a(var9_24.getActualPayerCountryLocation(), "UCLN_COUNTRY_LOCATION");
                        UaPaymentImporter.e(var9_24);
                    } else if (var7_11.equals("0000000000")) {
                        var9_24 = var6_7;
                        var8_12 = var5_4;
                        var10_34 = var9_24.getActualPayerPassportTypeId();
                        super.a(var10_34, "UCLN_OKPO", "UCLN_PASSP_TYPE");
                        var11_41 = super.a(var10_34);
                        if ("PSPT".equals(var11_41.getProprietary()) || "OT".equals(var11_41.getProprietary())) {
                            var9_24.setActualPayerProprietary(var11_41.getProprietary());
                        }
                        var9_24.setActualPayerPassportType(var11_41.getNameUa());
                        super.a(var11_41.getFormat(), var9_24.getActualPayerPassportNumber(), var9_24.getActualPayerPassportSerial());
                        super.a(var9_24, new String[]{"actualPayerPassportNumber"});
                        UaPaymentImporter.f(var9_24);
                        var9_24.setActualPayerCountryCode(null);
                    } else if (var7_11.length() == 10) {
                        var9_24 = var6_7;
                        var8_12 = var5_4;
                        var9_24.setActualPayerProprietary("RNRCT");
                        UaPaymentImporter.e(var9_24);
                        UaPaymentImporter.f(var9_24);
                    } else {
                        throw new RuntimeException(String.format(UaPaymentImporter.c("fieldHasIncorrectValue"), new Object[]{UaPaymentImporter.d("UCLN_OKPO"), var7_11, "UCLN_OKPO"}));
                    }
                }
                super.a(var4_2.getActualPayerCountryCode(), "UCLN_COUNTRY_CODE");
                var4_2 = var1_1.getRecipientAccount();
                var3_3 = this;
                var5_4 = var3_3.b.a();
                var6_7 = var5_4.a((String)var4_2).stream().filter((Predicate<Account>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, b(ua.com.dbosoft.autoclient.app.account.Account ), (Lua/com/dbosoft/autoclient/app/account/Account;)Z)()).findAny();
                if (var6_7.isPresent()) {
                    throw new RuntimeException(String.format(UaPaymentImporter.c("noAccountAccessOrReadOnly"), new Object[]{var4_2, "(RCPT_ACCOUNT)"}));
                }
                var4_2 = var1_1;
                var3_3 = this;
                var5_4 = var3_3.b.o().a("ua_payment.instant_payment.option", "false");
                var6_7 = var3_3.b.e().a().getSpecificProperty("ua_payment.instant_payment.option");
                var7_11 = var4_2.getInstantFlag();
                var8_13 = "true".equalsIgnoreCase((String)var6_7);
                var9_25 = "true".equalsIgnoreCase((String)var5_4);
                var10_35 = "false".equalsIgnoreCase((String)var6_7);
                if (var10_35) ** GOTO lbl-1000
                if ((var8_13 || UaPaymentImporter.b((String)var6_7) && var9_25) && var7_11 != null && !"0".equals(var7_11) && !"1".equals(var7_11)) {
                    throw new RuntimeException(UaPaymentImporter.c("cantDeterminateInstantPayment"));
                }
                if (var8_13 || UaPaymentImporter.b((String)var6_7) && var9_25) {
                    if ("1".equals(var7_11)) {
                        var11_41 = var4_2;
                        var11_41.setCommissionAmount(null);
                        var11_41.setCommissionType(null);
                        var11_41.setCommissionBnkName(null);
                        var11_41.setCommissionBnkMfo(null);
                        var4_2.setInfoForNextAgent("PYRHS");
                        v6 = true;
                    } else {
                        UaPaymentImporter.j((UaPayment)var4_2);
                        var4_2.setInstantFlag("0");
                        v6 = false;
                    }
                } else lbl-1000:
                // 2 sources

                {
                    UaPaymentImporter.j((UaPayment)var4_2);
                    v6 = var2_9 = false;
                }
                if (var1_1.getPaymentDetails() != null) break block128;
                var4_2 = var1_1;
                var3_3 = this;
                var4_2.setActualRecipientName(null);
                var4_2.setActualRecipientCode(null);
                var4_2.setActualRecipientProprietary(null);
                var4_2.setActualRecipientCountryCode(null);
                UaPaymentImporter.g((UaPayment)var4_2);
                UaPaymentImporter.h((UaPayment)var4_2);
                var5_5 = var2_9;
                var4_2 = var1_1;
                var3_3 = this;
                if (var4_2.getBudgetPaymentAdditionalInfo() != null) ** GOTO lbl-1000
                if (var4_2.getAdditionalInfo() != null) {
                    var8_14 = var4_2;
                    var7_11 = var3_3;
                    var8_14.setBudgetPaymentTemplateType(BudgetPaymentTemplateType.OTHER_BUDGET_PAYMENT);
                    var8_14.setBudgetPaymentTaxCode(null);
                    var8_14.setBudgetPaymentAccount(null);
                    var8_14.setBudgetPaymentTaxMsg(null);
                    var8_14.setBudgetPaymentIncomeCode(null);
                    super.a((UaPayment)var8_14, new String[]{"additionalInfo"});
                    v7 = var8_14;
                    v7.setPaymentDetails(v7.getAdditionalInfo());
                } else if (var5_5) {
                    var6_7 = var4_2.getRcptReferenceInfo();
                    if (var6_7 == null) {
                        throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequired"), new Object[]{UaPaymentImporter.d("PAYMENT_DETAILS"), "PAYMENT_DETAILS"}));
                    }
                    UaPaymentImporter.i((UaPayment)var4_2);
                    super.a((UaPayment)var4_2, new String[]{"rcptReferenceInfo"});
                    var4_2.setPaymentDetails((String)var6_7);
                } else lbl-1000:
                // 2 sources

                {
                    if (var4_2.getAdditionalInfo() != null) {
                        throw new RuntimeException(UaPaymentImporter.c("cantDetermineBudgetPayment"));
                    }
                    super.a((UaPayment)var4_2, new String[]{"budgetPaymentAdditionalInfo"});
                    if (var4_2.getBudgetPaymentTaxCode() != null) {
                        var8_15 = var4_2;
                        var7_11 = var3_3;
                        var8_15.setBudgetPaymentTemplateType(BudgetPaymentTemplateType.TO_BUDGET_OR_NON_BUDGET_ACCOUNTS);
                        var9_26 = var8_15.getBudgetPaymentTaxCode();
                        var10_36 = var7_11.b.k().a(var9_26);
                        if (var10_36 == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("codeNotFoundInReference"), new Object[]{UaPaymentImporter.d("BP_TAXCODE").toLowerCase(), var9_26, "BP_TAXCODE"}));
                        }
                        var8_15.setBudgetPaymentAccount(null);
                        var8_15.setBudgetPaymentTaxMsg(null);
                        var8_15.setBudgetPaymentIncomeCode(null);
                        var8_15.setPaymentDetails(String.format("%s %s", new Object[]{var9_26, var8_15.getBudgetPaymentAdditionalInfo()}));
                    } else if (var4_2.getBudgetPaymentAccount() != null) {
                        var8_16 = var4_2;
                        var7_11 = var3_3;
                        var8_16.setBudgetPaymentTemplateType(BudgetPaymentTemplateType.TO_SINGLE_ACCOUNT_WITH_DIRECTION);
                        super.a((UaPayment)var8_16, new String[]{"budgetPaymentTaxMsg", "budgetPaymentAccount"});
                        var2_10 = var8_16.getBudgetPaymentAccount().substring(4, 10);
                        var11_41 = var7_11;
                        var3_3 = var11_41.b.p().a(var2_10);
                        if (var3_3 == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("uaSwiftNotFound"), new Object[]{var2_10, "BP_ACCOUNT"}));
                        }
                        var8_16.setBudgetPaymentIncomeCode(null);
                        var9_27 = new BpSingleAccountRow();
                        var9_27.setAdditionalInfo(var8_16.getBudgetPaymentAdditionalInfo());
                        var9_27.setCategory(var8_16.getBudgetPaymentTaxMsg());
                        var9_27.setCategoryDetails(var8_16.getBudgetPaymentAccount());
                        var9_27.setTotalAmount(var8_16.getAmount());
                        var8_16.setBpSingleAccountRows(Collections.singletonList(var9_27));
                        var8_16.setBudgetPaymentAdditionalInfo(null);
                        var10_37 = new StringBuilder(String.format("%s %s ", new Object[]{var9_27.getCategoryDetails(), var9_27.getTotalAmount()}));
                        if (var9_27.getCategory() != null) {
                            var10_37.append(var9_27.getCategory()).append(" ");
                        }
                        var10_37.append(var9_27.getAdditionalInfo());
                        var8_16.setPaymentDetails(var10_37.toString());
                    } else if (var4_2.getBudgetPaymentIncomeCode() != null) {
                        var8_17 = var4_2;
                        var7_11 = var3_3;
                        var8_17.setBudgetPaymentTemplateType(BudgetPaymentTemplateType.FOR_STATE_PROPERTY_LEASE);
                        var9_28 = var8_17.getBudgetPaymentIncomeCode();
                        var10_38 = var7_11.b.d().a(var9_28);
                        if (var10_38 == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("codeNotFoundInReference"), new Object[]{UaPaymentImporter.d("BP_INCOME_CODE").toLowerCase(), var9_28, "BP_INCOME_CODE"}));
                        }
                        var8_17.setBudgetPaymentTaxMsg(null);
                        var8_17.setPaymentDetails(String.format("%s %s", new Object[]{var8_17.getBudgetPaymentAdditionalInfo(), var9_28}));
                    } else {
                        var7_11 = var4_2;
                        var7_11.setBudgetPaymentTemplateType(BudgetPaymentTemplateType.TO_SINGLE_ACCOUNT_NO_DIRECTION);
                        var7_11.setBudgetPaymentTaxMsg(null);
                        v8 = var7_11;
                        v8.setPaymentDetails(v8.getBudgetPaymentAdditionalInfo());
                    }
                }
                break block129;
            }
            if (var2_9 && var1_1.getRcptReferenceInfo() != null) {
                throw new RuntimeException(UaPaymentImporter.c("instantPaymentFieldsConflict"));
            }
            var4_2 = var1_1;
            var3_3 = this;
            v9 = var4_2;
            v9.setActualRecipientName(UaPaymentImporter.a(v9.getActualRecipientName(), 140));
            if (var4_2.getActualRecipientName() == null) {
                if (var4_2.getActualRecipientCode() != null) {
                    super.b("URCPT_OKPO", "URCPT_NAME");
                }
                var4_2.setActualRecipientCountryCode(null);
            } else if (var4_2.getActualRecipientCode() == null) {
                super.b("URCPT_NAME", "URCPT_OKPO");
            }
            var6_7 = var4_2;
            var5_4 = var3_3;
            var7_11 = var6_7.getActualRecipientCode();
            if (var7_11 != null) {
                super.a((UaPayment)var6_7, new String[]{"actualRecipientCode", "actualRecipientName"});
                if (var7_11.length() == 8 && !var7_11.equals("00000000")) {
                    var9_29 = var6_7;
                    var8_18 = var5_4;
                    var9_29.setActualRecipientProprietary("USRC");
                    UaPaymentImporter.g((UaPayment)var9_29);
                    UaPaymentImporter.h((UaPayment)var9_29);
                } else if (var7_11.length() == 9) {
                    var9_30 = var6_7;
                    var8_19 = var5_4;
                    if ("000000000".equals(var9_30.getActualRecipientCode())) {
                        var9_30.setActualRecipientProprietary("NA");
                    } else {
                        var9_30.setActualRecipientProprietary("TRAN");
                    }
                    var10_39 = var9_30;
                    if (var10_39.getActualRecipientPostcode() != null || var10_39.getActualRecipientRegion() != null || var10_39.getActualRecipientDistrict() != null || var10_39.getActualRecipientCity() != null || var10_39.getActualRecipientStreet() != null || var10_39.getActualRecipientHouseNumber() != null || var10_39.getActualRecipientOfficeNumber() != null || var10_39.getActualRecipientCountryLocation() != null) {
                        var11_41 = var9_30;
                        var10_39 = var8_19;
                        if (var11_41.getActualRecipientCity() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("URCPT_CITY"), "URCPT_CITY"}));
                        }
                        if (var11_41.getActualRecipientCountryLocation() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithNineDigitsCode"), new Object[]{UaPaymentImporter.d("URCPT_COUNTRY_LOCATION"), "URCPT_COUNTRY_LOCATION"}));
                        }
                        if (var11_41.getActualRecipientHouseNumber() == null) {
                            throw new RuntimeException(String.format(UaPaymentImporter.c("houseNumberIsRequired"), new Object[]{"URCPT_HOUSE_NUMBER"}));
                        }
                    }
                    super.a(var9_30.getActualRecipientCountryLocation(), "URCPT_COUNTRY_LOCATION");
                    UaPaymentImporter.g((UaPayment)var9_30);
                } else if (var7_11.equals("0000000000")) {
                    var9_31 = var6_7;
                    var8_20 = var5_4;
                    var10_40 = var9_31.getActualRecipientPassportTypeId();
                    super.a(var10_40, "URCPT_OKPO", "URCPT_PASSP_TYPE");
                    var11_41 = super.a(var10_40);
                    if ("PSPT".equals(var11_41.getProprietary()) || "OT".equals(var11_41.getProprietary())) {
                        var9_31.setActualRecipientProprietary(var11_41.getProprietary());
                    }
                    var9_31.setActualRecipientPassportType(var11_41.getNameUa());
                    super.a(var11_41.getFormat(), var9_31.getActualRecipientPassportNumber(), var9_31.getActualRecipientPassportSerial());
                    super.a((UaPayment)var9_31, new String[]{"actualRecipientPassportNumber"});
                    UaPaymentImporter.h((UaPayment)var9_31);
                    var9_31.setActualRecipientCountryCode(null);
                } else if (var7_11.length() == 10) {
                    var9_32 = var6_7;
                    var8_21 = var5_4;
                    var9_32.setActualRecipientProprietary("RNRCT");
                    UaPaymentImporter.g((UaPayment)var9_32);
                    UaPaymentImporter.h((UaPayment)var9_32);
                } else if (var7_11.equals("99999")) {
                    var9_33 = var6_7;
                    var8_22 = var5_4;
                    var9_33.setActualRecipientProprietary("UNKN");
                    UaPaymentImporter.g((UaPayment)var9_33);
                    UaPaymentImporter.h((UaPayment)var9_33);
                } else {
                    throw new RuntimeException(String.format(UaPaymentImporter.c("fieldHasIncorrectValue"), new Object[]{UaPaymentImporter.d("URCPT_OKPO"), var7_11, "URCPT_OKPO"}));
                }
            }
            super.a(var4_2.getActualRecipientCountryCode(), "URCPT_COUNTRY_CODE");
            var4_2 = var1_1;
            var3_3 = this;
            if ("899998".equals(var4_2.getRecipientBankCode())) {
                throw new RuntimeException(String.format(UaPaymentImporter.c("treasuryPaymentNotBudget"), new Object[]{"BP_ADD_INFO"}));
            }
            UaPaymentImporter.i(var1_1);
        }
        var4_2 = var1_1;
        var3_3 = this;
        if (var4_2.getClnEmployeeMobile() != null && var4_2.getClnEmployeePhone() != null) {
            throw new RuntimeException(UaPaymentImporter.c("onlyPhoneOrMobileForClnEmpl"));
        }
        var5_6 = var4_2.getClnEmployeeMobile() != null || var4_2.getClnEmployeePhone() != null || var4_2.getClnEmployeeEmail() != null;
        if (var5_6 && var4_2.getClnEmployeeFio() == null) {
            throw new RuntimeException(UaPaymentImporter.c("clnEmployeeFioIsRequired"));
        }
        if (var4_2.getClnEmployeeFio() != null && !var5_6) {
            throw new RuntimeException(UaPaymentImporter.c("clnEmployeeContactFieldsIsRequired"));
        }
        super.a((UaPayment)var4_2, new String[]{"clnEmployeeFio", "clnEmployeeEmail", "clnEmployeeMobile", "clnEmployeePhone"});
        var4_2 = var1_1;
        var3_3 = this;
        if (var4_2.getRcptEmployeeMobile() != null && var4_2.getRcptEmployeePhone() != null) {
            throw new RuntimeException(UaPaymentImporter.c("onlyPhoneOrMobileForRcptEmpl"));
        }
        var5_6 = var4_2.getRcptEmployeeMobile() != null || var4_2.getRcptEmployeePhone() != null || var4_2.getRcptEmployeeEmail() != null;
        if (var5_6 && var4_2.getRcptEmployeeFio() == null) {
            throw new RuntimeException(UaPaymentImporter.c("rcptEmployeeFioIsRequired"));
        }
        if (var4_2.getRcptEmployeeFio() != null && !var5_6) {
            throw new RuntimeException(UaPaymentImporter.c("rcptEmployeeContactFieldsIsRequired"));
        }
        super.a((UaPayment)var4_2, new String[]{"rcptEmployeeFio", "rcptEmployeeEmail", "rcptEmployeeMobile", "rcptEmployeePhone"});
        var4_2 = var1_1;
        var3_3 = this;
        if (var4_2.getUclnEmployeeMobile() != null && var4_2.getUclnEmployeePhone() != null) {
            throw new RuntimeException(UaPaymentImporter.c("onlyPhoneOrMobileForUclnEmpl"));
        }
        var5_6 = var4_2.getUclnEmployeeMobile() != null || var4_2.getUclnEmployeePhone() != null || var4_2.getUclnEmployeeEmail() != null;
        if (var5_6 && var4_2.getUclnEmployeeFio() == null) {
            throw new RuntimeException(UaPaymentImporter.c("uclnEmployeeFioIsRequired"));
        }
        if (var4_2.getUclnEmployeeFio() != null && !var5_6) {
            throw new RuntimeException(UaPaymentImporter.c("uclnEmployeeContactFieldsIsRequired"));
        }
        super.a((UaPayment)var4_2, new String[]{"uclnEmployeeFio", "uclnEmployeeEmail", "uclnEmployeeMobile", "uclnEmployeePhone"});
        var4_2 = var1_1;
        var3_3 = this;
        if (var4_2.getUrcptEmployeeMobile() != null && var4_2.getUrcptEmployeePhone() != null) {
            throw new RuntimeException(UaPaymentImporter.c("onlyPhoneOrMobileForUrcptEmpl"));
        }
        var5_6 = var4_2.getUrcptEmployeeMobile() != null || var4_2.getUrcptEmployeePhone() != null || var4_2.getUrcptEmployeeEmail() != null;
        if (var5_6 && var4_2.getUrcptEmployeeFio() == null) {
            throw new RuntimeException(UaPaymentImporter.c("urcptEmployeeFioIsRequired"));
        }
        if (var4_2.getUrcptEmployeeFio() != null && !var5_6) {
            throw new RuntimeException(UaPaymentImporter.c("urcptEmployeeContactFieldsIsRequired"));
        }
        super.a((UaPayment)var4_2, new String[]{"urcptEmployeeFio", "urcptEmployeeEmail", "urcptEmployeeMobile", "urcptEmployeePhone"});
        var1_1.setUniqueTransactionIdentifier(null);
        this.a(var1_1, new String[]{"clientName"});
        this.c.a(var1_1);
    }

    private static void a(UaPayment uaPayment) {
        uaPayment.setClientPassportTypeId(null);
        uaPayment.setClientPassportType(null);
        uaPayment.setClientPassportNumber(null);
        uaPayment.setClientPassportSerial(null);
    }

    private static void b(UaPayment uaPayment) {
        uaPayment.setClientPostcode(null);
        uaPayment.setClientRegion(null);
        uaPayment.setClientDistrict(null);
        uaPayment.setClientCity(null);
        uaPayment.setClientStreet(null);
        uaPayment.setClientHouseNumber(null);
        uaPayment.setClientOfficeNumber(null);
        uaPayment.setClientCountryLocation(null);
    }

    private void a(String string, String string2, String string3) {
        int n2 = -1;
        switch (string.hashCode()) {
            case 110119: {
                if (!string.equals("old")) break;
                n2 = 0;
                break;
            }
            case 108960: {
                if (!string.equals("new")) break;
                n2 = 1;
                break;
            }
            case 109446: {
                if (!string.equals("num")) break;
                n2 = 2;
                break;
            }
            case 96748: {
                if (!string.equals("any")) break;
                n2 = 3;
            }
        }
        switch (n2) {
            case 0: {
                if (string2 != null && string3 != null && string2.length() == 6 && a.matcher(string3).matches()) break;
                throw new RuntimeException(UaPaymentImporter.a("old"));
            }
            case 1: {
                if (string2 != null && string2.length() == 9 && UaPaymentImporter.b(string3)) break;
                throw new RuntimeException(UaPaymentImporter.a("new"));
            }
            case 2: {
                if (!UaPaymentImporter.b(string2) && string2.length() <= 20 && UaPaymentImporter.b(string3)) break;
                throw new RuntimeException(UaPaymentImporter.a("num"));
            }
            case 3: {
                if (!(UaPaymentImporter.b(string2) && UaPaymentImporter.b(string3) || string2 != null && string2.length() > 20) && (string3 == null || string3.length() <= 15)) break;
                throw new RuntimeException(UaPaymentImporter.a("any"));
            }
        }
    }

    private static String a(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_payment/validationMessages");
        return String.format(resourceBundle.getString("formatMustMeetRequirements"), string) + " " + resourceBundle.getString(string + "IdCardFormatRequirements");
    }

    private boolean a() {
        b b2 = this.b.o();
        return b2.a("license.service.corp.cards", false) && b2.a("documents.uah_documents.enable_corp_accounts", false);
    }

    private String a(boolean bl, String string) {
        String string2 = bl ? "currentOrCorporateAccWithIbanNotBelongToClient" : "accWithIbanNotBelongToClient";
        return String.format(UaPaymentImporter.c(string2), string, "CLN_ACCOUNT");
    }

    private String a(boolean bl, String string, String string2) {
        String string3 = bl ? "currentOrCorporateAccWithBankCodeNotBelongToClient" : "accWithBankCodeNotBelongToClient";
        return String.format(UaPaymentImporter.c(string3), string, string2, "CLN_ACCOUNT");
    }

    private void a(Account account) {
        if (ua.com.dbosoft.autoclient.app.account.b.a.equals((Object)account.getStatus()) || ua.com.dbosoft.autoclient.app.account.b.b.equals((Object)account.getStatus())) {
            throw new RuntimeException(String.format(UaPaymentImporter.c("accountIsBlockedOrClosed"), account.getIban(), "(CLN_ACCOUNT)"));
        }
    }

    private void a(UaPayment uaPayment, String string) {
        UaSwift uaSwift = this.b.p().a(uaPayment.getClientBankCode());
        if (uaSwift == null) {
            throw new RuntimeException(String.format(UaPaymentImporter.c("uaSwiftNotFound"), uaPayment.getClientBankCode(), string));
        }
        uaPayment.setClientBankName(uaSwift.getName());
    }

    private void a(Integer n2, String string, String string2) {
        if (n2 == null) {
            throw new RuntimeException(String.format(UaPaymentImporter.c("fieldIsRequiredWithTenZeroesCode"), UaPaymentImporter.d(string), UaPaymentImporter.d(string2), string2));
        }
    }

    private IdCardType a(Integer n2) {
        IdCardType idCardType = this.b.h().a(n2);
        if (idCardType == null) {
            throw new RuntimeException(String.format(UaPaymentImporter.c("idCardTypeNotFound"), n2));
        }
        return idCardType;
    }

    private static void c(UaPayment uaPayment) {
        uaPayment.setRecipientPassportTypeId(null);
        uaPayment.setRecipientPassportType(null);
        uaPayment.setRecipientPassportSerial(null);
        uaPayment.setRecipientPassportNumber(null);
    }

    private static void d(UaPayment uaPayment) {
        uaPayment.setRecipientPostcode(null);
        uaPayment.setRecipientRegion(null);
        uaPayment.setRecipientDistrict(null);
        uaPayment.setRecipientCity(null);
        uaPayment.setRecipientStreet(null);
        uaPayment.setRecipientHouseNumber(null);
        uaPayment.setRecipientOfficeNumber(null);
        uaPayment.setRecipientCountryLocation(null);
    }

    private void a(String string, String string2) {
        if (string == null) {
            return;
        }
        Country country = null;
        if (string.matches("^\\d{3}$")) {
            country = this.b.f().a(string);
        }
        if (country == null) {
            throw new RuntimeException(String.format(UaPaymentImporter.c("numeric3CountryCodeNotFound"), UaPaymentImporter.d(string2), string, string2));
        }
    }

    private void b(String string, String string2) {
        string = String.format(UaPaymentImporter.c("fieldIsRequiredIfOtherIsFilled"), UaPaymentImporter.d(string), UaPaymentImporter.d(string2), string2);
        throw new RuntimeException(string);
    }

    private static void e(UaPayment uaPayment) {
        uaPayment.setActualPayerPassportTypeId(null);
        uaPayment.setActualPayerPassportType(null);
        uaPayment.setActualPayerPassportNumber(null);
        uaPayment.setActualPayerPassportSerial(null);
    }

    private static void f(UaPayment uaPayment) {
        uaPayment.setActualPayerPostcode(null);
        uaPayment.setActualPayerRegion(null);
        uaPayment.setActualPayerDistrict(null);
        uaPayment.setActualPayerCity(null);
        uaPayment.setActualPayerStreet(null);
        uaPayment.setActualPayerHouseNumber(null);
        uaPayment.setActualPayerOfficeNumber(null);
        uaPayment.setActualPayerCountryLocation(null);
    }

    private static void g(UaPayment uaPayment) {
        uaPayment.setActualRecipientPassportTypeId(null);
        uaPayment.setActualRecipientPassportType(null);
        uaPayment.setActualRecipientPassportNumber(null);
        uaPayment.setActualRecipientPassportSerial(null);
    }

    private static void h(UaPayment uaPayment) {
        uaPayment.setActualRecipientPostcode(null);
        uaPayment.setActualRecipientRegion(null);
        uaPayment.setActualRecipientDistrict(null);
        uaPayment.setActualRecipientCity(null);
        uaPayment.setActualRecipientStreet(null);
        uaPayment.setActualRecipientHouseNumber(null);
        uaPayment.setActualRecipientOfficeNumber(null);
        uaPayment.setActualRecipientCountryLocation(null);
    }

    private static void i(UaPayment uaPayment) {
        uaPayment.setAdditionalInfo(null);
        uaPayment.setBudgetPaymentTaxCode(null);
        uaPayment.setBudgetPaymentAdditionalInfo(null);
        uaPayment.setBudgetPaymentAccount(null);
        uaPayment.setBudgetPaymentTaxMsg(null);
        uaPayment.setBudgetPaymentIncomeCode(null);
    }

    private static boolean b(String string) {
        return string == null || string.isEmpty();
    }

    private static void j(UaPayment uaPayment) {
        uaPayment.setInstantFlag(null);
        uaPayment.setCommissionPayer(null);
        uaPayment.setRcptReferenceInfo(null);
        uaPayment.setInfoForNextAgent(null);
        uaPayment.setCommissionAmount(null);
        uaPayment.setCommissionType(null);
        uaPayment.setCommissionBnkName(null);
        uaPayment.setCommissionBnkMfo(null);
    }

    private void a(UaPayment uaPayment, String ... stringArray) {
        for (String string : stringArray) {
            Set set = this.d.validateProperty((Object)uaPayment, string, new Class[]{c.class});
            Iterator iterator = set.iterator();
            if (!iterator.hasNext()) continue;
            throw new RuntimeException(((ConstraintViolation)iterator.next()).getMessage());
        }
    }

    private static String c(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_payment/validationMessages").getString(string);
    }

    private static String d(String string) {
        return ResourceBundle.getBundle("ua/com/dbosoft/autoclient/app/ua_payment/fieldDescription").getString("desc." + string);
    }

    private static String a(String string, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() > n2) {
            return string.substring(0, n2);
        }
        return string;
    }

    private static /* synthetic */ boolean b(Account account) {
        return (ua.com.dbosoft.autoclient.app.account.b.a.equals((Object)account.getStatus()) || ua.com.dbosoft.autoclient.app.account.b.b.equals((Object)account.getStatus())) && account.getPermission() != null && "UAH".equals(account.getCurrency());
    }

    private static /* synthetic */ boolean a(String string, Account account) {
        return (ua.com.dbosoft.autoclient.app.account.c.a.equals((Object)account.getType()) || ua.com.dbosoft.autoclient.app.account.c.c.equals((Object)account.getType()) || ua.com.dbosoft.autoclient.app.account.c.b.equals((Object)account.getType())) && account.getPermission() != null && "UAH".equals(account.getCurrency()) && string.equals(account.getBankCode());
    }

    private static /* synthetic */ boolean c(Account account) {
        return "UAH".equals(account.getCurrency()) && account.getPermission() != null;
    }
}

