/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Boolean
extends AbstractASN1Value {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 1L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();
    private final boolean val;

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    private Header getHeader(ASN1Tag aSN1Tag) {
        return new Header(aSN1Tag, FORM, 1L);
    }

    public static ASN1Boolean getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1Boolean)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        this.getHeader(aSN1Tag).encode(outputStream);
        if (this.val) {
            outputStream.write(255);
        } else {
            outputStream.write(0);
        }
    }

    public ASN1Boolean(boolean bl) {
        this.val = bl;
    }

    public boolean toBoolean() {
        return this.val;
    }

    public String toString() {
        if (this.val) {
            return "true";
        }
        return "false";
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1Boolean)) {
            return false;
        }
        ASN1Boolean aSN1Boolean = (ASN1Boolean)object;
        return this.getTag().equals(aSN1Boolean.getTag()) && this.val == aSN1Boolean.val;
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, FORM);
                int n = inputStream.read();
                if (n == -1) {
                    throw new InvalidBERException("End-of-file reached while decoding ASN1Boolean");
                }
                if (n == 0) {
                    return new ASN1Boolean(false);
                }
                return new ASN1Boolean(true);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Boolean");
            }
        }
    }
}

