/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Integer;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.IOException;
import java.io.InputStream;

public class ASN1Enumerated
extends ASN1Integer {
    private static final long serialVersionUID = 5075460216131961186L;
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 10L);
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public ASN1Enumerated(long l) {
        super(l);
    }

    ASN1Enumerated(byte[] byArray) {
        super(byArray);
    }

    public long getValue() {
        return this.longValue();
    }

    public static ASN1Enumerated getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1Enumerated)ASN1Util.decode(TEMPLATE, byArray);
    }

    @Override
    public byte[] encode() {
        return ASN1Util.encode(this.getTag(), this);
    }

    public static class Template
    extends ASN1Integer.Template
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws InvalidBERException, IOException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, ASN1Integer.FORM);
                if (header.getContentLength() < 1L) {
                    throw new InvalidBERException("Invalid 0 length for ENUMERATED");
                }
                byte[] byArray = new byte[(int)header.getContentLength()];
                ASN1Util.readFully(byArray, inputStream);
                return new ASN1Enumerated(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Enumerated");
            }
        }
    }
}

