/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.AbstractASN1TimeBase;
import com.bifit.security.asn1.InvalidBERException;
import java.util.Date;

public class ASN1GeneralizedTime
extends AbstractASN1TimeBase {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.UNIVERSAL, 24L);
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    public ASN1GeneralizedTime() {
        this(new Date());
    }

    public ASN1GeneralizedTime(Date date) {
        super(date);
    }

    @Override
    protected boolean isUTC() {
        return false;
    }

    public static ASN1GeneralizedTime getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1GeneralizedTime)ASN1Util.decode(TEMPLATE, byArray);
    }

    public static class Template
    extends AbstractASN1TimeBase.AbstractTemplate
    implements ASN1Template {
        @Override
        protected ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return TAG.equals(aSN1Tag);
        }

        @Override
        protected String typeName() {
            return "ASN1GeneralizedTime";
        }

        @Override
        protected boolean isUTC() {
            return false;
        }

        @Override
        protected AbstractASN1TimeBase generateInstance(Date date) {
            return new ASN1GeneralizedTime(date);
        }
    }
}

