/*
 * Decompiled with CFR 0.152.
 */
package com.bifit.security.asn1;

import com.bifit.security.asn1.ASN1Form;
import com.bifit.security.asn1.ASN1Tag;
import com.bifit.security.asn1.ASN1Template;
import com.bifit.security.asn1.ASN1Util;
import com.bifit.security.asn1.ASN1Value;
import com.bifit.security.asn1.AbstractASN1Value;
import com.bifit.security.asn1.Header;
import com.bifit.security.asn1.InvalidBERException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ASN1Null
extends AbstractASN1Value {
    public static final ASN1Tag TAG = new ASN1Tag(ASN1Tag.Class.UNIVERSAL, 5L);
    public static final ASN1Form FORM = ASN1Form.PRIMITIVE;
    public static final ASN1Template TEMPLATE = new Template();

    @Override
    public ASN1Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(ASN1Tag aSN1Tag, OutputStream outputStream) throws IOException {
        Header header = new Header(aSN1Tag, FORM, 0L);
        header.encode(outputStream);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ASN1Null)) {
            return false;
        }
        ASN1Null aSN1Null = (ASN1Null)object;
        return this.getTag().equals(aSN1Null.getTag());
    }

    public static ASN1Null getInstance() {
        return new ASN1Null();
    }

    public static ASN1Null getInstance(byte[] byArray) throws InvalidBERException {
        return (ASN1Null)ASN1Util.decode(TEMPLATE, byArray);
    }

    public static class Template
    implements ASN1Template {
        public ASN1Tag getTag() {
            return TAG;
        }

        @Override
        public boolean tagMatch(ASN1Tag aSN1Tag) {
            return aSN1Tag.equals(TAG);
        }

        @Override
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        @Override
        public ASN1Value decode(ASN1Tag aSN1Tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                Header header = new Header(inputStream);
                header.validate(aSN1Tag, FORM);
                if (header.getContentLength() != 0L) {
                    throw new InvalidBERException("Invalid length (" + header.getContentLength() + ") for ASN1Null; only 0 is permitted");
                }
                return new ASN1Null();
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "ASN1Null");
            }
        }
    }
}

